/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.table;

import com.sun.java.accessibility.Accessible;
import com.sun.java.accessibility.AccessibleAction;
import com.sun.java.accessibility.AccessibleComponent;
import com.sun.java.accessibility.AccessibleContext;
import com.sun.java.accessibility.AccessibleRole;
import com.sun.java.accessibility.AccessibleSelection;
import com.sun.java.accessibility.AccessibleStateSet;
import com.sun.java.accessibility.AccessibleText;
import com.sun.java.accessibility.AccessibleValue;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTable;
import com.sun.java.swing.ToolTipManager;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.TableColumnModelEvent;
import com.sun.java.swing.event.TableColumnModelListener;
import com.sun.java.swing.plaf.TableHeaderUI;
import com.sun.java.swing.table.DefaultTableColumnModel;
import com.sun.java.swing.table.TableCellRenderer;
import com.sun.java.swing.table.TableColumn;
import com.sun.java.swing.table.TableColumnModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Locale;

public class JTableHeader
extends JComponent
implements TableColumnModelListener,
Accessible {
    protected JTable table;
    protected TableColumnModel columnModel;
    protected boolean reorderingAllowed;
    protected boolean resizingAllowed;
    protected boolean updateTableInRealTime;
    protected transient TableColumn resizingColumn;
    protected transient TableColumn draggedColumn;
    protected transient int draggedDistance;

    public JTableHeader() {
        this(null);
    }

    public JTableHeader(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            tableColumnModel = this.createDefaultColumnModel();
        }
        this.setColumnModel(tableColumnModel);
        this.initializeLocalVars();
        this.updateUI();
    }

    public void setTable(JTable jTable) {
        this.table = jTable;
    }

    public JTable getTable() {
        return this.table;
    }

    public void setReorderingAllowed(boolean bl) {
        this.reorderingAllowed = bl;
    }

    public boolean getReorderingAllowed() {
        return this.reorderingAllowed;
    }

    public void setResizingAllowed(boolean bl) {
        this.resizingAllowed = bl;
    }

    public boolean getResizingAllowed() {
        return this.resizingAllowed;
    }

    public TableColumn getDraggedColumn() {
        return this.draggedColumn;
    }

    public int getDraggedDistance() {
        return this.draggedDistance;
    }

    public TableColumn getResizingColumn() {
        return this.resizingColumn;
    }

    public void setUpdateTableInRealTime(boolean bl) {
        this.updateTableInRealTime = bl;
    }

    public boolean getUpdateTableInRealTime() {
        return this.updateTableInRealTime;
    }

    public int columnAtPoint(Point point) {
        return this.getColumnModel().getColumnIndexAtX(point.x);
    }

    public Rectangle getHeaderRect(int n) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        if (n < 0 || n >= tableColumnModel.getColumnCount()) {
            throw new IllegalArgumentException("Column index out of range");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.getColumnModel().getColumnMargin();
        Enumeration enumeration = this.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            if (n3 == n) {
                return new Rectangle(n2, 0, tableColumn.getWidth() + n4, this.getSize().height);
            }
            n2 += tableColumn.getWidth() + n4;
            ++n3;
        }
        return new Rectangle();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        TableColumn tableColumn;
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnModel.getColumnIndexAtX(point.x);
        if (n != -1 && (component = (tableCellRenderer = (tableColumn = this.columnModel.getColumn(n)).getHeaderRenderer()).getTableCellRendererComponent(this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n)) instanceof JComponent) {
            Rectangle rectangle = this.getHeaderRect(n);
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }

    public TableHeaderUI getUI() {
        return (TableHeaderUI)this.ui;
    }

    public void setUI(TableHeaderUI tableHeaderUI) {
        if (this.ui != tableHeaderUI) {
            super.setUI(tableHeaderUI);
            this.repaint();
        }
    }

    public void updateUI() {
        this.setUI((TableHeaderUI)UIManager.getUI(this));
        this.resizeAndRepaint();
        this.invalidate();
    }

    public String getUIClassID() {
        return "TableHeaderUI";
    }

    public void setColumnModel(TableColumnModel tableColumnModel) {
        if (tableColumnModel == null) {
            throw new IllegalArgumentException("Cannot set a null ColumnModel");
        }
        TableColumnModel tableColumnModel2 = this.columnModel;
        if (tableColumnModel != tableColumnModel2) {
            if (tableColumnModel2 != null) {
                tableColumnModel2.removeColumnModelListener(this);
            }
            this.columnModel = tableColumnModel;
            tableColumnModel.addColumnModelListener(this);
            this.resizeAndRepaint();
        }
    }

    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }

    public boolean isOpaque() {
        return true;
    }

    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        this.resizeAndRepaint();
    }

    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        this.repaint();
    }

    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.resizeAndRepaint();
    }

    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }

    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModel();
    }

    protected void initializeLocalVars() {
        this.table = null;
        this.reorderingAllowed = true;
        this.resizingAllowed = true;
        this.draggedColumn = null;
        this.draggedDistance = 0;
        this.resizingColumn = null;
        this.updateTableInRealTime = true;
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    public void resizeAndRepaint() {
        this.revalidate();
        this.repaint();
    }

    public void setDraggedColumn(TableColumn tableColumn) {
        this.draggedColumn = tableColumn;
    }

    public void setDraggedDistance(int n) {
        this.draggedDistance = n;
    }

    public void setResizingColumn(TableColumn tableColumn) {
        this.resizingColumn = tableColumn;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTableHeader();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJTableHeader
    extends JComponent.AccessibleJComponent {
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = JTableHeader.this.columnAtPoint(point);
            if (n != -1) {
                TableColumn tableColumn = JTableHeader.this.columnModel.getColumn(n);
                TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
                return new AccessibleJTableHeaderEntry(n, JTableHeader.this, JTableHeader.this.table);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            return JTableHeader.this.columnModel.getColumnCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                return null;
            }
            TableColumn tableColumn = JTableHeader.this.columnModel.getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
            return new AccessibleJTableHeaderEntry(n, JTableHeader.this, JTableHeader.this.table);
        }

        AccessibleJTableHeader() {
            JTableHeader.this = JTableHeader.this;
        }

        protected class AccessibleJTableHeaderEntry
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JTableHeader parent;
            private int column;
            private JTable table;

            public AccessibleJTableHeaderEntry(int n, JTableHeader jTableHeader, JTable jTable) {
                AccessibleJTableHeader.this = AccessibleJTableHeader.this;
                this.parent = jTableHeader;
                this.column = n;
                this.table = jTable;
                this.setAccessibleParent(this.parent);
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            private AccessibleContext getCurrentAccessibleContext() {
                TableColumn tableColumn;
                TableCellRenderer tableCellRenderer;
                Component component;
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                if (tableColumnModel != null && (component = (tableCellRenderer = (tableColumn = tableColumnModel.getColumn(this.column)).getHeaderRenderer()).getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, this.column)) instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                TableColumnModel tableColumnModel = this.table.getColumnModel();
                if (tableColumnModel != null) {
                    TableColumn tableColumn = tableColumnModel.getColumn(this.column);
                    TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
                    return tableCellRenderer.getTableCellRendererComponent(JTableHeader.this.getTable(), tableColumn.getHeaderValue(), false, false, -1, this.column);
                }
                return null;
            }

            public String getAccessibleName() {
                String string;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (string = accessibleContext.getAccessibleName()) != null && string != "") {
                    return accessibleContext.getAccessibleName();
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return this.table.getColumnName(this.column);
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                    return;
                }
                super.setAccessibleName(string);
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                    return;
                }
                super.setAccessibleDescription(string);
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.COLUMN_HEADER;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleStateSet();
                }
                return new AccessibleStateSet();
            }

            public int getAccessibleIndexInParent() {
                return this.column;
            }

            public int getAccessibleChildrenCount() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleChildrenCount();
                }
                return 0;
            }

            public Accessible getAccessibleChild(int n) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    Accessible accessible = accessibleContext.getAccessibleChild(n);
                    accessibleContext.setAccessibleParent(this);
                    return accessible;
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return null;
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                    return;
                }
                super.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                    return;
                }
                super.removePropertyChangeListener(propertyChangeListener);
            }

            public AccessibleAction getAccessibleAction() {
                return this.getCurrentAccessibleContext().getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }

            public boolean isVisible() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isVisible();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isVisible();
                }
                return false;
            }

            public void setVisible(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setVisible(bl);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setVisible(bl);
                }
            }

            public boolean isShowing() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isShowing();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isShowing();
                }
                return false;
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point point = this.parent.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Point getLocation() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.getLocation();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.getLocation();
                }
                return this.getBounds().getLocation();
            }

            public void setLocation(Point point) {
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.table.getCellRect(-1, this.column, false);
                rectangle.y = 0;
                return rectangle;
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBounds(rectangle);
                }
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                    return;
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }
        }
    }
}

