/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.plaf.TextUI;
import com.sun.java.swing.text.BadLocationException;
import com.sun.java.swing.text.Document;
import com.sun.java.swing.text.Highlighter;
import com.sun.java.swing.text.JTextComponent;
import com.sun.java.swing.text.Position;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;

public class DefaultHighlighter
implements Highlighter {
    private Vector highlights = new Vector();
    private JTextComponent component;

    public void paint(Graphics graphics) {
        Rectangle rectangle = new Rectangle(this.component.getSize());
        Insets insets = this.component.getInsets();
        rectangle.x += insets.left;
        rectangle.y += insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        int n = this.highlights.size();
        int n2 = 0;
        while (n2 < n) {
            HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(n2);
            Highlighter.HighlightPainter highlightPainter = highlightInfo.getPainter();
            highlightPainter.paint(graphics, highlightInfo.getStartOffset(), highlightInfo.getEndOffset(), rectangle, this.component);
            ++n2;
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.component = jTextComponent;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.component = null;
    }

    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        Document document = this.component.getDocument();
        TextUI textUI = this.component.getUI();
        HighlightInfo highlightInfo = new HighlightInfo();
        highlightInfo.painter = highlightPainter;
        highlightInfo.p0 = document.createPosition(n);
        highlightInfo.p1 = document.createPosition(n2);
        this.highlights.addElement(highlightInfo);
        textUI.damageRange(n, n2);
        return highlightInfo;
    }

    public void removeHighlight(Object object) {
        TextUI textUI = this.component.getUI();
        HighlightInfo highlightInfo = (HighlightInfo)object;
        textUI.damageRange(highlightInfo.p0.getOffset(), highlightInfo.p1.getOffset());
        this.highlights.removeElement(object);
    }

    public void removeAllHighlights() {
        int n;
        TextUI textUI = this.component.getUI();
        if (textUI != null && (n = this.highlights.size()) != 0) {
            int n2 = Integer.MAX_VALUE;
            int n3 = 0;
            int n4 = 0;
            while (n4 < n) {
                HighlightInfo highlightInfo = (HighlightInfo)this.highlights.elementAt(n4);
                n2 = Math.min(n2, highlightInfo.p0.getOffset());
                n3 = Math.max(n3, highlightInfo.p1.getOffset());
                ++n4;
            }
            textUI.damageRange(n2, n3);
            this.highlights.removeAllElements();
        }
    }

    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        TextUI textUI = this.component.getUI();
        Document document = this.component.getDocument();
        HighlightInfo highlightInfo = (HighlightInfo)object;
        int n3 = highlightInfo.p0.getOffset();
        int n4 = highlightInfo.p1.getOffset();
        if (n == n3) {
            textUI.damageRange(Math.min(n4, n2), Math.max(n4, n2));
        } else if (n2 == n4) {
            textUI.damageRange(Math.min(n, n3), Math.max(n, n3));
        } else {
            textUI.damageRange(n3, n4);
            textUI.damageRange(n, n2);
        }
        highlightInfo.p0 = document.createPosition(n);
        highlightInfo.p1 = document.createPosition(n2);
    }

    public Highlighter.Highlight[] getHighlights() {
        Object[] objectArray = new Highlighter.Highlight[this.highlights.size()];
        this.highlights.copyInto(objectArray);
        return objectArray;
    }

    public static class DefaultHighlightPainter
    implements Highlighter.HighlightPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = shape.getBounds();
            try {
                TextUI textUI = jTextComponent.getUI();
                Rectangle rectangle2 = textUI.modelToView(n);
                Rectangle rectangle3 = textUI.modelToView(n2);
                graphics.setColor(this.getColor());
                if (rectangle2.y == rectangle3.y) {
                    Rectangle rectangle4 = rectangle2.union(rectangle3);
                    graphics.fillRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    return;
                }
                int n3 = rectangle.x + rectangle.width - rectangle2.x;
                graphics.fillRect(rectangle2.x, rectangle2.y, n3, rectangle2.height);
                if (rectangle2.y + rectangle2.height != rectangle3.y) {
                    graphics.fillRect(rectangle.x, rectangle2.y + rectangle2.height, rectangle.width, rectangle3.y - (rectangle2.y + rectangle2.height));
                }
                graphics.fillRect(rectangle.x, rectangle3.y, rectangle3.x - rectangle.x, rectangle3.height);
                return;
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    class HighlightInfo
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }

        HighlightInfo() {
            DefaultHighlighter.this = DefaultHighlighter.this;
        }
    }
}

