/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.text;

import com.sun.java.swing.text.BoxView;
import com.sun.java.swing.text.Element;
import com.sun.java.swing.text.View;
import com.sun.java.swing.text.ViewFactory;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;

public class TableView
extends BoxView {
    int[] colWidths;

    public TableView(Element element) {
        super(element, 1);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(element);
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(element);
    }

    int getColumnSpan(int n) {
        return this.colWidths[n];
    }

    int getRowSpan(int n) {
        View view = this.getView(n);
        return (int)view.getPreferredSpan(1);
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Element element = this.getElement();
        int n = element.getElementCount();
        if (n > 0) {
            View[] viewArray = new View[n];
            int n2 = 0;
            while (n2 < n) {
                viewArray[n2] = this.createTableRow(element.getElement(n2));
                ++n2;
            }
            this.replace(0, 0, viewArray);
        }
        int n3 = 0;
        while (n3 < n) {
            View view = this.getView(n3);
            int n4 = 0;
            while (n4 < view.getViewCount()) {
                TableCell tableCell;
                View view2 = view.getView(n4);
                if (view2 instanceof TableCell && ((tableCell = (TableCell)view2).getColumnCount() > 1 || tableCell.getRowCount() > 1)) {
                    int n5 = n3;
                    while (n5 < n3 + tableCell.getRowCount()) {
                        int n6 = n4;
                        while (n6 < n4 + tableCell.getColumnCount()) {
                            if (n5 != 0 && n6 != 0) {
                                this.addProxy(n5, n6, tableCell);
                            }
                            ++n6;
                        }
                        ++n3;
                    }
                }
                ++n4;
            }
            ++n3;
        }
        this.calculateGrid();
    }

    void calculateGrid() {
        int n = 0;
        int n2 = this.getViewCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            n = Math.max(n, view.getViewCount());
            ++n3;
        }
        this.colWidths = new int[n];
        int n4 = 0;
        while (n4 < n2) {
            View view = this.getView(n4);
            n = view.getViewCount();
            int n5 = 0;
            while (n5 < n) {
                TableCell tableCell = (TableCell)view.getView(n5);
                this.colWidths[n5] = Math.max(tableCell.getPreferredColumnSpan(), this.colWidths[n5]);
                ++n5;
            }
            view.preferenceChanged(null, true, false);
            ++n4;
        }
    }

    void addProxy(int n, int n2, TableCell tableCell) {
        TableRow tableRow = (TableRow)this.getView(n);
        tableRow.insert(n2, new ProxyCell(tableCell));
    }

    protected void layout(int n, int n2) {
        this.calculateGrid();
        super.layout(n, n2);
    }

    public class TableRow
    extends BoxView {
        public TableRow(Element element) {
            super(element, 0);
            TableView.this = TableView.this;
        }

        protected void loadChildren(ViewFactory viewFactory) {
            Element element = this.getElement();
            int n = element.getElementCount();
            if (n > 0) {
                View[] viewArray = new View[n];
                int n2 = 0;
                while (n2 < n) {
                    viewArray[n2] = TableView.this.createTableCell(element.getElement(n2));
                    ++n2;
                }
                this.replace(0, 0, viewArray);
            }
        }
    }

    public class TableCell
    extends BoxView {
        int row;
        int col;

        public TableCell(Element element) {
            super(element, 1);
            TableView.this = TableView.this;
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n, int n2) {
            this.row = n;
            this.col = n2;
        }

        public int getPreferredColumnSpan() {
            return (int)super.getPreferredSpan(0) / this.getColumnCount();
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            if (n > 1 || n2 > 1) {
                int n3 = 1;
                while (n3 < n2) {
                    rectangle.width += TableView.this.getColumnSpan(this.col + n3);
                    ++n3;
                }
                int n4 = 1;
                while (n4 < n) {
                    rectangle.height += TableView.this.getRowSpan(this.row + n4);
                    ++n4;
                }
            }
        }

        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    return TableView.this.getColumnSpan(this.col);
                }
            }
            return super.getPreferredSpan(n);
        }
    }

    class ProxyCell
    extends TableCell {
        TableCell host;

        ProxyCell(TableCell tableCell) {
            super(tableCell.getElement());
            TableView.this = TableView.this;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        public int getPreferredColumnSpan() {
            return this.host.getPreferredColumnSpan();
        }

        public void paint(Graphics graphics, Shape shape) {
        }
    }
}

