
/*
 * Computer Algebra Kit (c) 1993,98 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: odespolc.h,v 1.2 1999/07/06 19:48:11 stes Exp $
 */

#ifndef __obj_vardnsexpdegsps_polynomial_header__
#define __obj_vardnsexpdegsps_polynomial_header__

#include "despolc.h"

typedef struct obj_vardnsexpdegspsterm
  {
    struct obj_vardnsexpdegspsterm *nlink;
    struct obj_vardnsexpdegspsterm *plink;
    /* stes - mar31, 1997 - for DEC alpha alignment, put scalar in front */
    obj_c scal;			/* can't be variable sized */
    vardnsmonom_c data;		/* variable sized */
  }
 *obj_vardnsexpdegspsterm_t;

typedef struct
  {
    obj_args sargs;
    vardnsmonom_args margs;
  }
obj_vardnsexpdegspsterm_args;

typedef struct obj_vardnsexpdegspsterm *obj_vardnsexpdegspspol_t;
typedef struct obj_vardnsexpdegspsterm obj_vardnsexpdegspspol_c;
typedef obj_vardnsexpdegspsterm_args obj_vardnsexpdegspspol_args;

typedef struct obj_vardnsexpdegspspol_ix
  {
    obj_vardnsexpdegspsterm_t ix;
    obj_vardnsexpdegspsterm_t head;
  }
 *obj_vardnsexpdegspspol_ixt;

#define obj_vardnsexpdegspspol_isvalue	0
#define obj_vardnsexpdegspspol_pervalue	0

@interface obj_vardnsexpdegsps_polynomial : vardnsexpdegsps_polynomial
{
  id scalarZero;
  id termZero;
  id monomialZero;
  id symbols;
  obj_vardnsexpdegspspol_c value;
}

- (obj_vardnsexpdegspspol_t)obj_vardnsexpdegspspol_value;
- obj_vardnsexpdegspspol_value:(obj_vardnsexpdegspspol_t)aValue;
- (obj_vardnsexpdegspspol_t)obj_vardnsexpdegspspol_reference;
- obj_vardnsexpdegspspol_reference:(obj_vardnsexpdegspspol_c *)aReference;

- copy;
- deepCopy;
- (BOOL) isEmpty;
- (BOOL) isOne;
- (BOOL) isMinusOne;
- (unsigned) hash;
- (BOOL) isEqual:b;
- (BOOL) notEqual:b;
- (BOOL) isZero;
- (BOOL) notZero;
- (BOOL) isOpposite:b;
- (BOOL) notOpposite:b;
- negate;
- negateSelf;
- _double:(int)v;
- _doubleSelf:(int)v;
- double;
- doubleSelf;
- _add:(int)v:b:(int)w;
- _addSelf:(int)v:b:(int)w;
- add:b;
- addSelf:b;
- subtract:b;
- subtractSelf:b;
- (int) leadingDegree;
- (int) lastDegree;
- (int) maxDegree;
- (int) minDegree;
- asScalar;
- asSymbol;
- check;
- _setUpScalarZero:aScalar symbols:aCltn;
+ scalarZero:aScalar symbols:aCltn;
- release;
- empty;
- (int) numMonomials;
- eachMonomial;
- elt_obj_vardnsexpdegspspol_ix:(obj_vardnsexpdegspspol_ixt)ix;
- removeMonomial;
- insertMonomial:aMonomial;
- multiplyScalar:s;
- multiplySelfScalar:s;
- divideScalar:s;
- divideSelfScalar:s;
- _add:(int)v:B multiplyScalar:b:(int)w;
- _addSelf:(int)v:B multiplyScalar:b:(int)w;
- _multiplyScalar:a:(int)v add:B:(int)w;
- _multiplySelfScalar:a:(int)v add:B:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyScalar:b:(int)w;
- multiplyMonomial:aMonomial;
- multiplySelfMonomial:aMonomial;
- _multiplyMonomial:aMonomial:(int)v;
- _multiplySelfMonomial:aMonomial:(int)v;
- divideMonomial:aMonomial;
- divideSelfMonomial:aMonomial;
- _add:(int)v:B multiplyMonomial:b:(int)w;
- _addSelf:(int)v:B multiplyMonomial:b:(int)w;
- _multiplyScalar:a:(int)v add:B multiplyMonomial:b:(int)w;
- _multiplySelfScalar:a:(int)v add:B multiplyMonomial:b:(int)w;

- fileOutOn:aFiler;
- fileInFrom:aFiler;
@end

#endif /* __obj_vardnsexpdegsps_polynomial_header__ */
 
