
/*
 * Computer Algebra Kit (c) 1993,99 by Comp.Alg.Objects.  All Rights Reserved.
 * $Id: polycseq.m,v 1.2 1999/07/06 19:48:12 stes Exp $
 */

#include "cakit.h"

@implementation recpolcoef_sequence
- _setUpContent:aPolynomial
{
  assert ([aPolynomial isRecursive] && [aPolynomial isVariableDense]);
  content = aPolynomial;
  eachTerm = [aPolynomial eachTerm];
  return self;
}

+ content:aPolynomial
{
  return [[super new] _setUpContent:aPolynomial];
}

- toFirst
{
  [eachTerm toFirst];
  return self;
}

- toLast
{
  [eachTerm toLast];
  return self;
}

- (unsigned) size
{
  return [eachTerm size];
}

- (BOOL) isEmpty
{
  return [eachTerm isEmpty];
}

- toElementAt:(int)i
{
  [eachTerm toElementAt:i];
  return self;
}

- next
{
  id next = [eachTerm next];
  return (next) ? [next coefficient] : nil;
}
- previous
{
  id previous = [eachTerm previous];
  return (previous) ? [previous coefficient] : nil;
}

@end
 
