
,(use rs.db.rstore)

(define-interactive (save-as-file (doc <open-document>) (file <string>))
  (interactive (open-document) (minibuffer <string> "File: "))
  (let ((ps (create-persistent-store file)))
    (setup-indirects ps)
    (commit ps (underlying-object doc))
    (set-property! doc 'pstore ps)
    (mark-as-clean doc file)
    (values)))

(define-interactive (load-file (file <string>))
  (interactive (minibuffer <string> "File: "))
  (let ((ps (open-persistent-store file)))
    (setup-indirects ps)
    (let ((od (open-document (root-object ps) file)))
      (set-file-name! od file)
      (set-property! od 'pstore ps)
      od)))

(global-set-key '(#\C-x #\C-f) load-file)

(define-interactive (save-file (doc <open-document>))
  (interactive (open-document))
  (if (get-property doc 'pstore #f)
      (begin
	(commit (get-property doc 'pstore))
	(mark-as-clean doc)
	(set-dirty?! doc #f))
      (call-interactive save-as-file)))

(global-set-key '(#\C-x #\C-s) save-file)

;;;

(define (setup-indirects ps)
  ; geometry
  (register-indirect-page ps 100 *geometry-classes*)
  ; application
  (register-indirect-page ps 101 (vector <document>
					 <root-group>
					 <user-group>
					 <page>
					 <view>))
  ; modules
  ;
  ; ...this should be improved to support dynamic modules
  ; and forward evolution.  Doing so would probably involve
  ; some tricks about storing some metadata in the store,
  ; and making sure we can read the metadata without needing
  ; any module objects...
  (register-indirect-page ps 102 (vector <box-graphic>
					 ;
					 <line-graphic>
					 ;
					 <text-graphic>
					 <text-run>
					 <text-font>)))
