(define (make-mailbox)
  (%make <mailbox>
	 (%make <vector> #f #f #f #f #f)
	 0
	 0
	 #t))

(define-safe-glue (send-message/prepend! (mbox <mailbox>) item)
{
  ksend_mailbox_pre( mbox, item );
  RETURN0();
})

(define-safe-glue (send-message! (mbox <mailbox>) item)
{
  ksend_mailbox( mbox, item );
  RETURN0();
})

(define-safe-glue (receive-message! (mbox <mailbox>))
{
  if (truish(gvec_ref(mbox,MAILBOX_HAS_DATA_Q)) && !dequeue_empty(mbox))
    {
      obj item = dequeue_pop_front(mbox);
      if (DEBUG_THREAD_MBOX)
	printf( " [%s] extracted item{%#lx} from mailbox{%#lx}\n",
		thread_name(current_thread), VAL(item), VAL(mbox) );
      REG0 = item;
      RETURN1();
    }
  else
    {
      if (DEBUG_THREAD_MBOX)
	 printf( " [%s] blocking on mailbox{%#lx}\n",
	         thread_name(current_thread), VAL(mbox) );
      gvec_write_non_ptr(mbox,MAILBOX_HAS_DATA_Q,FALSE_OBJ);
      dequeue_push_back(mbox,current_thread);
      REG1 = REG0;
      SAVE_CONT2(rcv_n_go);
      /* note... mbox::=REG0 still has mbox, but in REG1 too for later */
      SWITCH_THREAD(mbox,TSTATE_BLOCKED);
    }
}
("rcv_n_go" {
  /* our continuation's REG0 got filled in with the item */
  RESTORE_CONT2();
  if (DEBUG_THREAD_MBOX)
    printf( " [%s] mailbox{%#lx}: item{%#lx} delivered\n",
	    thread_name(current_thread), VAL(REG1), VAL(REG0) );
  RETURN1();
}))
