#ifndef __RTL_UNISTD_H__
#define __RTL_UNISTD_H__

#include <rtl_posixio.h>

extern int open(const char *pathname, int flags);
extern int close(int fd);
extern ssize_t write(int fd, const void *buf, size_t count);
extern ssize_t read(int fd, void *buf, size_t count);
extern off_t lseek(int fildes, off_t offset, int whence);

extern int ioctl(int fd, int request, ...);

#ifdef __KERNEL__
#include <linux/utsname.h>

#undef CHILD_MAX
#define CHILD_MAX 0

#ifndef SEEK_SET
#define SEEK_SET 0
#endif

extern long sysconf(int name);
static inline int uname(struct new_utsname * name)
{

	*name = system_utsname;
	return 0;
}
 

#endif

#endif
