      SUBROUTINE PBSTRMV( ICONTXT, UPLO, TRANS, DIAG, XDIST, N, NB, NZ,
     $                    A, LDA, X, INCX, IAROW, IACOL, IXPOS, XWORK,
     $                    MULLEN, WORK )
*
*  -- PB-BLAS routine (version 2.1) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory.
*     April 28, 1996
*
*     Jaeyoung Choi, Oak Ridge National Laboratory
*     Jack Dongarra, University of Tennessee and Oak Ridge National Lab.
*     David Walker,  Oak Ridge National Laboratory
*
*     .. Scalar Arguments ..
      CHARACTER*1        DIAG, TRANS, UPLO, XDIST, XWORK
      INTEGER            IACOL, IAROW, ICONTXT, INCX, IXPOS, LDA,
     $                   MULLEN, N, NB, NZ
*     ..
*     .. Array Arguments ..
      REAL               A( LDA, * ), WORK( * ), X( * )
*
*  Purpose
*  =======
*
*  PBSTRMV  is a parallel blocked version of the Level 2 BLAS routine
*  STRMV.
*  PBSTRMV  performs  the matrix-matrix operations
*
*     X := A*X,   or   X := A'*X,
*
*  where X is an N element vector and  A is an N-by-N unit, or non-unit,
*  upper or lower triangular matrix.
*
*  The first elements of the matrices A is located  in the middle of the
*  first block ((NZ+1,NZ+1) position) and the first element of X starts
*  from the (NZ+1)-th position.
*  X is broadcast or transposed if necessary, and the resultant X is
*  collected.
*
*  Parameters
*  ==========
*
*  ICONTXT (input) INTEGER
*          ICONTXT is the BLACS mechanism for partitioning communication
*          space.  A defining property of a context is that a message in
*          a context cannot be sent or received in another context.  The
*          BLACS context includes the definition of a grid, and each
*          process' coordinates in it.
*
*  UPLO    (input) CHARACTER*1
*          UPLO specifies whether the upper or lower triangular part of
*          the  symmetric matrix A is to be referenced as follows:
*
*             UPLO = 'U',  Only the upper triangular part of the
*                          symmetric matrix is to be referenced.
*             UPLO = 'L',  Only the lower triangular part of the
*                          symmetric matrix is to be referenced.
*
*  TRANS   (input) CHARACTER*1
*          TRANS specifies the operation to be performed as follows:
*
*             TRANS = 'N',  X := A * X.
*             TRANS = 'T',  X := A**T * X.
*             TRANS = 'C',  X := A**C * X.
*
*  DIAG    (input) CHARACTER*1
*          DIAG specifies whether or not A is unit triangular as
*          follows:
*
*             DIAG = 'U',  A is assumed to be unit triangular.
*             DIAG = 'N',  A is not assumed to be unit triangular.
*
*  XDIST   (input) CHARACTER*1
*          XDIST specifies the distribution of vector X as follows:
*
*             XDIST = 'C',  X is distributed columnwise
*                           or in a column of processors
*             XDIST = 'R',  X is distributed rowwise
*                           or in a row of processors
*
*  N       (input) INTEGER
*          N specifies the (global) number of row and columns of the
*          matrix A.  N >= 0.
*
*  NB      (input) INTEGER
*          NB specifies the row and column block size of matrix A.
*          It also specifies the block size of the vector X.  NB >= 1.
*
*  NZ      (input) INTEGER
*          NZ is the row and column offset to specify the row and column
*          distance from the beginning of the block to the first
*          element of A.  And it also specifies the offset to the first
*          element of the vector X.  0 <= NZ < NB.
*
*  A       (input) REAL array of DIMENSION ( LDA, Nq ),
*          Before entry with UPLO = 'U', the leading N-by-N upper
*          triangular part of the (global) array A must contain the
*          upper triangular matrix and the strictly lower triangular
*          part of A is not referenced.
*          Before entry with UPLO = 'L', the leading N-by-N lower
*          triangular part of the (global) array A must contain the
*          lower triangular matrix and the strictly upper triangular
*          part of A is not referenced.
*          Note that when  DIAG = 'U', the diagonal elements of A are
*          not referenced either, but are assumed to be unity.
*
*  LDA     (input) INTEGER
*          LDA specifies the leading dimension of (local) A as declared
*          in the calling (sub) program.  LDA >= MAX(1,Np).
*
*  X       (input/output) REAL array of DIMENSION at least
*          ( 1  + ( Np - 1 ) * abs( INCX ) ) if XDIST = 'C', or
*          ( 1  + ( Nq - 1 ) * abs( INCX ) ) if XDIST = 'R'.
*          The incremented array X must contain the vector X.
*          On exit, X is overwritten by the updated vector X.
*
*  INCX    (input) INTEGER
*          INCX specifies the increment for the elements of X.
*          INCX <> 0.
*
*  IAROW   (input) INTEGER
*          IAROW specifies a row of the processor template, which holds
*          the  first  block of  the  matrix A.  0 <= IAROW < NPROW.
*
*  IACOL   (input) INTEGER
*          IACOL specifies  a column of the processor template, which
*          holds the first block of the matrix A.  0 <= IACOL < NPCOL.
*
*  IXPOS   (input) INTEGER
*          If XDIST = 'C', IXPOS specifies a column of the processor
*          template which holds the vector X.  If XDIST = 'R', IXPOS
*          specifies a row of the processor template which holds the
*          vector X.
*
*  XWORK   (input) CHARACTER*1
*          XWORK determines whether X is a workspace or not.
*
*             XWORK = 'Y':  X is workspace in other processors.
*                           It is assumed that processors have
*                           sufficient space to store (local) X.
*             XWORK = 'N':  Data of X in other processors will be
*                           untouched (unchanged).
*
*  MULLEN  (input) INTEGER
*          It specifies  multiplication  length  of the  optimum column
*          number of a block row A for multiplying A with X.  The value
*          depends on machine characteristics.
*
*  WORK    (workspace) REAL array of dimension Size(WORK).
*          It will store copy of x and/or partial A.
*
*  Parameters Details
*  ==================
*
*  Nx      It is a local portion  of N owned by a processor, where x is
*          replaced by  either p (=NPROW) or q (=NPCOL)).  The value is
*          determined by N, NB, NZ, x, and MI, where NB is a block size,
*          NZ is a offset from the beginning of the block,  and MI is a
*          row or column position  in a processor template. Nx is equal
*          to  or less than Nx0 = CEIL( N+NZ, NB*x ) * NB.
*
*  Communication Scheme
*  ====================
*
*  The communication schemes of the routine are fixed as fan-out and
*  fan-in schemes (COMM = '1-tree', for details, see BLACS user's guide)
*
*  Memory Requirement of WORK
*  ==========================
*
*  NN     = N + NZ
*  Npb    = CEIL( NN, NB*NPROW )
*  Nqb    = CEIL( NN, NB*NPCOL )
*  Np0    = NUMROC( NN, NB, 0, 0, NPROW ) ~= Npb * NB
*  Nq0    = NUMROC( NN, NB, 0, 0, NPCOL ) ~= Nqb * NB
*  LCMP   = LCM / NPROW
*  LCMQ   = LCM / NPCOL
*  ISZCMP = CEIL(MULLEN, LCMQ*NB)
*  SZCMP  = ISZCMP * ISZCMP * LCMQ*NB * LCMP*NB
*
*  (1) XDIST = 'Col'
*    Size(WORK) = Nq0
*               + Np0             (if IXPOS != -1 and XWORK <> 'Y')
*               + MAX[ SZCMP,
*                      CEIL(Nqb,LCMQ)*NB         ( if IXPOS <> -1 ),
*                      CEIL(Nqb,LCMQ)*NB*MIN(LCMQ,CEIL(NN,NB))
*                                                ( if IXPOS =  -1 ) ]
*
*  (2) XDIST = 'Row'
*    Size(WORK) = Np0
*               + Nq0             (if IXPOS != -1 and XWORK <> 'Y')
*               + MAX[ SZCMP,
*                      CEIL(Npb,LCMP)*NB         ( if IXPOS <> -1 ),
*                      CEIL(Npb,LCMP)*NB*MIN(LCMP,CEIL(NN,NB))
*                                                ( if IXPOS =  -1 ) ]
*
*  Notes
*  -----
*  More precise space can be computed as
*
*  CEIL(Npb,LCMP)*NB => NUMROC( NUMROC(NN,NB,0,0,NPROW), NB, 0, 0, LCMP)
*                    = NUMROC( Np0, NB, 0, 0, LCMP )
*  CEIL(Nqb,LCMQ)*NB => NUMROC( NUMROC(NN,NB,0,0,NPCOL), NB, 0, 0, LCMQ)
*                    = NUMROC( Nq0, NB, 0, 0, LCMQ )
*
*  =====================================================================
*
*     .. Parameters ..
      REAL               ONE, ZERO
      PARAMETER          ( ONE = 1.0E+0, ZERO = 0.0E+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER*1        FORM
      LOGICAL            COLUMN, NOTRAN, UPPER, XDATA
      INTEGER            INFO, IPBZ, IPW, IPX, IPZ, IQBZ, ISZCMP, IZ,
     $                   JJ, JNPBZ, JNQBZ, JPBZ, JQBZ, JZ, KI, KIZ, KJ,
     $                   KJZ, KZ, LCM, LCMP, LCMQ, LMW, LNW, LPBZ, LQBZ,
     $                   MRCOL, MRROW, MYCOL, MYROW, MZCOL, MZROW, NN,
     $                   NP, NPCOL, NPROW, NQ
      REAL               DUMMY, TBETA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, ILCM, NUMROC
      EXTERNAL           ICEIL, ILCM, LSAME, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, PBSLACP1, PXERBLA, SCOPY,
     $                   SGEBR2D, SGEBS2D, SGEMM, SGSUM2D, SLASET
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible.
*
      IF( N.EQ.0 ) RETURN
*
      CALL BLACS_GRIDINFO( ICONTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      UPPER  = LSAME( UPLO,  'U' )
      NOTRAN = LSAME( TRANS, 'N' )
      COLUMN = LSAME( XDIST, 'C' )
*
*     Test the input parameters.
*
      INFO = 0
      IF( ( .NOT.UPPER ) .AND.
     $    ( .NOT.LSAME( UPLO, 'L' ) )         ) THEN
         INFO = 2
      ELSE IF( .NOT.NOTRAN .AND.
     $         .NOT.LSAME( TRANS, 'T' ).AND.
     $         .NOT.LSAME( TRANS, 'C' )       ) THEN
         INFO = 3
      ELSE IF( .NOT.LSAME( DIAG , 'U' ).AND.
     $         .NOT.LSAME( DIAG , 'N' )       ) THEN
         INFO = 4
      ELSE IF( ( .NOT.COLUMN              ).AND.
     $         ( .NOT.LSAME( XDIST, 'R') )    ) THEN
         INFO = 5
      ELSE IF( N  .LT.0                       ) THEN
         INFO = 6
      ELSE IF( NB .LT.0                       ) THEN
         INFO = 7
      ELSE IF( NZ .LT.0 .OR. NZ.GE.NB         ) THEN
         INFO = 8
      ELSE IF( INCX.EQ.0                      ) THEN
         INFO = 12
      ELSE IF( IAROW.LT.0 .OR. IAROW.GE.NPROW ) THEN
         INFO = 13
      ELSE IF( IACOL.LT.0 .OR. IACOL.GE.NPCOL ) THEN
         INFO = 14
      END IF
*
   10 CONTINUE
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICONTXT, 'PBSTRMV ', INFO )
         RETURN
      END IF
*
*     Start the operations.
*
      NN = N + NZ
      NP = NUMROC( NN, NB, MYROW, IAROW, NPROW )
      IF( MYROW.EQ.IAROW ) NP = NP - NZ
      NQ = NUMROC( NN, NB, MYCOL, IACOL, NPCOL )
      IF( MYCOL.EQ.IACOL ) NQ = NQ - NZ
*
      IZ = 0
      IF( MYROW.EQ.IAROW ) IZ = NZ
      JZ = 0
      IF( MYCOL.EQ.IACOL ) JZ = NZ
      KZ = 0
*
*     LCM : the least common multiple of NPROW and NPCOL
*
      LCM  = ILCM( NPROW, NPCOL )
      LCMP = LCM  / NPROW
      LCMQ = LCM  / NPCOL
      LPBZ = LCMP * NB
      LQBZ = LCMQ * NB
*
      MRROW = MOD( NPROW+MYROW-IAROW, NPROW )
      MRCOL = MOD( NPCOL+MYCOL-IACOL, NPCOL )
      XDATA = .FALSE.
      IF( LDA.LT.MAX(1,NP) ) INFO = 10
*
*     PART 1: Distribute a vector X
*     ====================================
*
*     If X is distributed columnwise
*
      IF( COLUMN ) THEN
*
*       Form  x := A * x
*                    _____________
*         ||        |\_           |      ||
*         ||        |  \_         |      ||
*         ||        |    \_       |      ||
*        (x)   =    |      A_     |  *  (x)
*         ||        |        \_   |      ||
*         ||        |          \_ |      ||
*         ||        |____________\|      ||
*
        IF( IXPOS.LT.0 .OR. IXPOS.GE.NPCOL ) INFO = 15
        IF( INFO.NE.0 ) GO TO 10
*
        IF( NOTRAN ) THEN
*
*         Transpose a column vector X to WORK(IPX)
*
          IPZ = 1
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IPX = 1
            XDATA = .TRUE.
          ELSE
            IPX = NP + 1
          END IF
          IPW = NQ + IPX
*
          CALL PBSTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, X, INCX, ZERO,
     $                  WORK(IPX), 1, IAROW, IXPOS, -1, IACOL,
     $                  WORK(IPW) )
*
          IF( XDATA ) THEN
            CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, ZERO,
     $                      X, INCX )
          ELSE
            CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, ZERO,
     $                      WORK(IPZ), 1 )
          END IF
*
        ELSE
*
*         Broadcast X if necessary
*
          IPZ = 1
          IPX = NQ + IPZ
          IPW = IPX
*
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IF( MYCOL.EQ.IXPOS ) THEN
              CALL SGEBS2D( ICONTXT, 'Row', '1-tree', 1, NP, X, INCX )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Row', '1-tree', 1, NP, X, INCX,
     $                      MYROW, IXPOS )
            END IF
            XDATA = .TRUE.
          ELSE
            IF( MYCOL.EQ.IXPOS ) THEN
              CALL SCOPY( NP, X, INCX, WORK(IPX), 1 )
              CALL SGEBS2D( ICONTXT, 'Row', '1-tree', 1, NP,
     $                      WORK(IPX), 1 )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Row', '1-tree', 1, NP,
     $                      WORK(IPX), 1, MYROW, IXPOS )
            END IF
            IPW = NP + IPX
          END IF
*
          CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, ZERO,
     $                    WORK(IPZ), 1 )
        END IF
*
*     If X is distributed rowwise
*
      ELSE
*
*       Form  x := A * x
*                          _____________
*                         |\_           |
*                         |  \_         |
*                         |    \_       |
*       =====(x)=====  =  |      A_     | * =====(x)=====
*                         |        \_   |
*                         |          \_ |
*                         |____________\|
*
        IF( IXPOS.LT.0 .OR. IXPOS.GE.NPROW ) INFO = 15
        IF( INFO.NE.0 ) GO TO 10
*
        IF( NOTRAN ) THEN
*
*         Broadcast X if necessary
*
          IPZ = 1
          IPX = NP + IPZ
          IPW = IPX
*
          IF( XDATA ) THEN
            IF( MYROW.EQ.IXPOS ) THEN
              CALL SGEBS2D( ICONTXT, 'Col', '1-tree', 1, NQ, X, INCX )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Col', '1-tree', 1, NQ, X, INCX,
     $                      IXPOS, MYCOL )
            END IF
            XDATA = .TRUE.
          ELSE
            IF( MYROW.EQ.IXPOS ) THEN
              CALL SCOPY( NQ, X, INCX, WORK(IPX), 1 )
              CALL SGEBS2D( ICONTXT, 'Col', '1-tree', 1, NQ,
     $                      WORK(IPX), 1 )
            ELSE
              CALL SGEBR2D( ICONTXT, 'Col', '1-tree', 1, NQ,
     $                      WORK(IPX), 1, IXPOS, MYCOL )
            END IF
            IPW = NQ + IPX
          END IF
*
          CALL PBSVECADD( ICONTXT, 'G', NP, ZERO, DUMMY, 1, ZERO,
     $                    WORK(IPZ), 1 )
*
*       Transpose a row vector X to WORK(IPX)
*
        ELSE
*
          IPZ = 1
          IF( LSAME( XWORK, 'Y' ) ) THEN
            IPX = 1
            XDATA = .TRUE.
          ELSE
            IPX = NQ + IPZ
          END IF
          IPW = NP + IPX
*
          CALL PBSTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, X, INCX, ZERO,
     $                  WORK(IPX), 1, IXPOS, IACOL, IAROW, -1,
     $                  WORK(IPW) )
*
          IF( XDATA ) THEN
            CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, ZERO,
     $                      X, INCX )
          ELSE
            CALL PBSVECADD( ICONTXT, 'G', NQ, ZERO, DUMMY, 1, ZERO,
     $                      WORK(IPZ), 1 )
          END IF
        END IF
      END IF
*
*     PART 2: Compute x <= A * x
*     ==========================
*
      IF( NP.EQ.0 .OR. NQ.EQ.0 ) GO TO 100
*
*     If A is an upper triangular matrix,
*
      IF( UPPER ) THEN
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP.LE.0 ) ISZCMP = 1
        IPBZ = ISZCMP * LPBZ
        IQBZ = ISZCMP * LQBZ
        JPBZ = 0
        JQBZ = 0
*
        DO 50 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW   = MIN( IPBZ-IZ, NP-JPBZ )
          LNW   = MIN( IQBZ-JZ, NQ-JQBZ )
          JNPBZ = JPBZ + LMW
          JNQBZ = JQBZ + LNW
*
*         Copy the upper triangular matrix A to WORK(IPW)
*
          MZROW = MRROW
          MZCOL = MRCOL
          KI = 0
          IF( MYCOL.EQ.IACOL ) KZ = JZ
*
          DO 30 KJ = 0, LCMQ-1
   20       CONTINUE
            IF( MZROW.LT.MZCOL ) THEN
              MZROW = MZROW + NPROW
              KI = KI + 1
              GO TO 20
            END IF
            KIZ = MAX( 0, KI*NB-IZ )
            KJZ = MAX( 0, KJ*NB-JZ )
            IF( KJZ.GE.LNW ) GO TO 40
            FORM = 'G'
            IF( MZROW.EQ.MZCOL ) FORM = 'T'
            MZCOL = MZCOL + NPCOL
*
            CALL PBSLACP1( ICONTXT, 'Upper', FORM, DIAG, KIZ, NB, KZ,
     $                    A(JPBZ+1,JQBZ+KJZ+1), LDA, WORK(KJZ*LMW+IPW),
     $                    LMW, LPBZ, LQBZ, LMW, LNW-KJZ )
            KZ = 0
   30     CONTINUE
*
*         Compute X
*
   40     CONTINUE
          IF( COLUMN ) THEN
            IF( NOTRAN ) THEN
              IF( XDATA ) THEN
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), WORK(JQBZ+IPX), 1, ZERO,
     $                      X(JPBZ*INCX+1), INCX )
                CALL SGEMV( 'No', JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      WORK(JQBZ+IPX), 1, ONE,  X, INCX )
              ELSE
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW), MAX(1,LMW),
     $                      WORK(JQBZ+IPX), 1, ZERO, WORK(JPBZ+IPZ), 1 )
                CALL SGEMV( 'No', JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      WORK(JQBZ+IPX), 1, ONE,  WORK(IPZ), 1 )
              END IF
            ELSE
              IF( XDATA ) THEN
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), X(JPBZ*INCX+1), INCX,
     $                      ZERO, WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( TRANS, JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      X, INCX, ONE, WORK(JQBZ+IPZ), 1 )
              ELSE
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),MAX(1,LMW),
     $                      WORK(JPBZ+IPX), 1, ZERO, WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( TRANS, JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      WORK(IPX), 1, ONE, WORK(JQBZ+IPZ), 1 )
              END IF
            END IF
*
          ELSE
            IF( NOTRAN ) THEN
              IF( XDATA ) THEN
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), X(JQBZ*INCX+1), INCX,
     $                      ZERO, WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( 'No', JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      X(JQBZ*INCX+1), INCX, ONE,  WORK(IPZ), 1 )
              ELSE
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW), MAX(1,LMW),
     $                      WORK(JQBZ+IPX), 1, ZERO, WORK(JPBZ+IPZ), 1 )
                CALL SGEMV( 'No', JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      WORK(JQBZ+IPX), 1, ONE,  WORK(IPZ), 1 )
              END IF
            ELSE
              IF( XDATA ) THEN
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), WORK(JPBZ+IPX), 1, ZERO,
     $                      X(JQBZ*INCX+1), INCX )
                CALL SGEMV( TRANS, JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      WORK(IPX), 1, ONE, X(JQBZ*INCX+1), INCX )
              ELSE
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),MAX(1,LMW),
     $                      WORK(JPBZ+IPX), 1, ZERO, WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( TRANS, JPBZ, LNW, ONE, A(1,JQBZ+1), LDA,
     $                      WORK(IPX), 1, ONE, WORK(JQBZ+IPZ), 1 )
              END IF
            END IF
          END IF
*
          JPBZ = JNPBZ
          JQBZ = JNQBZ
          IZ   = 0
          JZ   = 0
   50   CONTINUE
*
*     If A is a lower triangular matrix,
*
      ELSE
        ISZCMP = ICEIL( MULLEN, LQBZ )
        IF( ISZCMP.LE.0 ) ISZCMP = 1
        IPBZ   = ISZCMP * LPBZ
        IQBZ   = ISZCMP * LQBZ
        JPBZ   = 0
        JQBZ   = 0
        TBETA  = ZERO
*
        DO 90 JJ = 1, ICEIL(NQ+JZ, IQBZ)
          LMW   = MIN( IPBZ-IZ, NP-JPBZ )
          LNW   = MIN( IQBZ-JZ, NQ-JQBZ )
          JNPBZ = JPBZ + LMW
          JNQBZ = JQBZ + LNW
*
*         Copy the lower triangular matrix A to WORK(IPW)
*
          MZROW = MRROW
          MZCOL = MRCOL
          KI = 0
          IF( MYCOL.EQ.IACOL ) KZ = JZ
*
          DO 70 KJ = 0, LCMQ-1
   60       CONTINUE
            IF( MZROW.LT.MZCOL ) THEN
              MZROW = MZROW + NPROW
              KI = KI + 1
              GO TO 60
            END IF
            KIZ = MAX( 0, KI*NB-IZ )
            KJZ = MAX( 0, KJ*NB-JZ )
            IF( KJZ.GE.LNW ) GO TO 80
            FORM = 'G'
            IF( MZROW.EQ.MZCOL ) FORM = 'T'
            MZCOL = MZCOL + NPCOL
*
            CALL PBSLACP1( ICONTXT, 'Lower', FORM, DIAG, KIZ, NB, KZ,
     $                     A(JPBZ+1,JQBZ+KJZ+1), LDA, WORK(KJZ*LMW+IPW),
     $                     LMW, LPBZ, LQBZ, LMW, LNW-KJZ )
            KZ = 0
   70     CONTINUE
*
*         Compute X
*
   80     CONTINUE
          IF( COLUMN ) THEN
            IF( NOTRAN ) THEN
              IF( XDATA ) THEN
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), WORK(JQBZ+IPX), 1, TBETA,
     $                      X(JPBZ*INCX+1),INCX )
                CALL SGEMV( 'No', NP-JNPBZ, LNW, ONE,
     $                      A(JNPBZ+1,JQBZ+1), LDA, WORK(JQBZ+IPX), 1,
     $                      TBETA, X(JNPBZ*INCX+1), INCX )
              ELSE
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW), MAX(1,LMW),
     $                      WORK(JQBZ+IPX), 1, TBETA, WORK(JPBZ+IPZ),1 )
                CALL SGEMV( 'No', NP-JNPBZ, LNW, ONE,
     $                      A(JNPBZ+1,JQBZ+1), LDA, WORK(JQBZ+IPX), 1,
     $                      TBETA, WORK(JNPBZ+IPZ), 1 )
              END IF
            ELSE
              IF( XDATA ) THEN
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), X(JPBZ*INCX+1), INCX,
     $                      ZERO, WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( TRANS, NP-JNPBZ, LNW, ONE,
     $                      A(JNPBZ+1,JQBZ+1), LDA, X(JNPBZ*INCX+1),
     $                      INCX, ONE, WORK(JQBZ+IPZ), 1 )
              ELSE
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),MAX(1,LMW),
     $                      WORK(JPBZ+IPX), 1, ZERO, WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( TRANS, NP-JNPBZ, LNW, ONE,
     $                      A(JNPBZ+1,JQBZ+1), LDA, WORK(JNPBZ+IPX), 1,
     $                      ONE, WORK(JQBZ+IPZ), 1 )
*
              END IF
            END IF
*
          ELSE
            IF( NOTRAN ) THEN
              IF( XDATA ) THEN
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), X(JQBZ*INCX+1), INCX,
     $                      TBETA, WORK(JPBZ+IPZ), 1 )
                CALL SGEMV( 'No', NP-JNPBZ, LNW, ONE, A(JNPBZ+1,JQBZ+1),
     $                      LDA, X(JQBZ*INCX+1), INCX, TBETA,
     $                      WORK(JNPBZ+IPZ), 1 )
              ELSE
                CALL SGEMV( 'No', LMW, LNW, ONE, WORK(IPW), MAX(1,LMW),
     $                      WORK(JQBZ+IPX),1, TBETA, WORK(JPBZ+IPZ),1 )
                CALL SGEMV( 'No', NP-JNPBZ, LNW, ONE, A(JNPBZ+1,JQBZ+1),
     $                      LDA, WORK(JQBZ+IPX), 1, TBETA,
     $                      WORK(JNPBZ+IPZ), 1 )
              END IF
            ELSE
              IF( XDATA ) THEN
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), WORK(JPBZ+IPX), 1,
     $                      ZERO, X(JQBZ*INCX+1), INCX )
                CALL SGEMV( TRANS, NP-JNPBZ, LNW, ONE,
     $                      A(JNPBZ+1,JQBZ+1), LDA, WORK(JNPBZ+IPX), 1,
     $                      ONE, X(JQBZ*INCX+1), INCX )
              ELSE
                CALL SGEMV( TRANS, LMW, LNW, ONE, WORK(IPW),
     $                      MAX(1,LMW), WORK(JPBZ+IPX), 1, ZERO,
     $                      WORK(JQBZ+IPZ), 1 )
                CALL SGEMV( TRANS, NP-JNPBZ, LNW, ONE,
     $                      A(JNPBZ+1,JQBZ+1), LDA, WORK(JNPBZ+IPX), 1,
     $                      ONE, WORK(JQBZ+IPZ), 1 )
              END IF
            END IF
          END IF
*
          TBETA = ONE
          JPBZ = JNPBZ
          JQBZ = JNQBZ
          IZ   = 0
          JZ   = 0
   90   CONTINUE
      END IF
*
  100 CONTINUE
*
*     PART 3: Collect X, and transpose it if necessary
*     ================================================
*
      IF( COLUMN ) THEN
*
*       Add WORK(IPZ) rowwise
*
        IF( NOTRAN ) THEN
          IF( XDATA ) THEN
            CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, X, INCX,
     $                    MYROW, IXPOS )
          ELSE
            IF( MYCOL.EQ.IXPOS ) THEN
              CALL SCOPY( NP, WORK(IPZ), 1, X, INCX )
              CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, X, INCX,
     $                      MYROW, IXPOS )
            ELSE
              CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, WORK(IPZ),
     $                      1, MYROW, IXPOS )
            END IF
          END IF
*
*       Add WORK(IPZ) columnwise
*
        ELSE
          CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, WORK(IPZ), 1,
     $                  IAROW, MYCOL)
          CALL PBSTRNV( ICONTXT, 'Row', 'T', N, NB, NZ, WORK(IPZ), 1,
     $                  ZERO, X, INCX, IAROW, IACOL, IAROW, IXPOS,
     $                  WORK(IPX) )
        END IF
*
      ELSE
*
*       Add WORK(IPZ) rowwise
*
        IF( NOTRAN ) THEN
          CALL SGSUM2D( ICONTXT, 'Row', '1-tree', 1, NP, WORK(IPZ), 1,
     $                  MYROW, IACOL)
          CALL PBSTRNV( ICONTXT, 'Col', 'T', N, NB, NZ, WORK(IPZ), 1,
     $                  ZERO, X, INCX, IAROW, IACOL, IXPOS, IACOL,
     $                  WORK(IPX) )
*
*       Add WORK(IPZ) columnwise
*
        ELSE
          IF( XDATA ) THEN
            CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, X, INCX,
     $                    IXPOS, MYCOL )
          ELSE
            IF( MYROW.EQ.IXPOS ) THEN
              CALL SCOPY( NQ, WORK(IPZ), 1, X, INCX )
              CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, X, INCX,
     $                      IXPOS, MYCOL )
            ELSE
              CALL SGSUM2D( ICONTXT, 'Col', '1-tree', 1, NQ, WORK(IPZ),
     $                      1, IXPOS, MYCOL )
            END IF
          END IF
        END IF
      END IF
*
      RETURN
*
*     End of PBSTRMV
*
      END
