--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class PROCEDURE

inherit
   EFFECTIVE_ROUTINE
      rename make_effective_routine as make
      export {ANY} make
      end;

creation make

feature

   result_type: TYPE is
      do
      end;

   to_run_feature(t: TYPE; fn: FEATURE_NAME): RUN_FEATURE_3 is
      do
         !!Result.make(t,fn,Current);
      end;

feature {C_PRETTY_PRINTER}

   stupid_switch(up_rf: RUN_FEATURE; r: ARRAY[RUN_CLASS]): BOOLEAN is
      local
         rf3a, rf3b: RUN_FEATURE_3;
         rf2a, rf2b: RUN_FEATURE_2;
         offseta, offsetb: INTEGER;
         rta, rtb: TYPE;
         rc: RUN_CLASS;
         i: INTEGER;
      do
         rf3a ?= r.first.dynamic(up_rf);
         Result := rf3a.is_empty_or_null_body;
         if Result then
            cpp.put_comment("SSP1");
         end;
         if not Result then
            from
               Result := true;
               i := r.upper;
            until
               not Result or else i = 0
            loop
               rc := r.item(i);
               rf3b ?= rc.dynamic(up_rf);
               rf2b := rf3b.is_attribute_writer;
               if rf2b /= Void then
                  offsetb := rc.offset_of(rf2b);
               end;
               if rf2a = Void then
                  rf3a := rf3b;
                  rf2a := rf2b;
                  offseta := offsetb;
               end;
               if rf2b = Void then
                  Result := false;
               elseif rf2a.name.to_string /= rf2b.name.to_string then
                  Result := false;
               elseif offseta /= offsetb then
                  Result := false;
               else
                  rta := rf2a.result_type;
                  rtb := rf2b.result_type;
                  if rta.is_reference then
                     Result := rtb.is_reference;
                  elseif rta.run_time_mark = rtb.run_time_mark then
                  elseif rta.is_native_array then
                     if rta.generic_list.first.is_reference then
                        Result := rtb.generic_list.first.is_reference;
                     end;
                  else
                     Result := false;
                  end;
               end;
               i := i - 1;
            end;
            if Result then
               cpp.put_comment("SSP2");
            end;
         end;
         if not Result then
            Result := stupid_switch_for_collection(up_rf,r);
            if Result then
               cpp.put_comment("SSP3");
            end;
         end;
      end;

feature {NONE}

   stupid_switch_for_collection(up_rf: RUN_FEATURE; r: ARRAY[RUN_CLASS]): BOOLEAN is
         -- I think it is a little bit dirty to handle these features
         -- specifically.
      local
         fns, bcn: STRING;
         i: INTEGER;
         rf: RUN_FEATURE;
      do
         bcn := up_rf.current_type.base_class.name.to_string;
         if as_array = bcn or else as_fixed_array = bcn then
            fns := up_rf.name.to_string;
            if as_put = fns or else as_add_last = fns then
               from
                  i := r.upper;
                  Result := true;
               until
                  not Result or else i = 0
               loop
                  rf := r.item(i).dynamic(up_rf);
                  if rf.arguments.type(1).is_expanded then
                     Result := false;
                  end;
                  i := i - 1;
               end;
            end;
         end;
      end;

   try_to_undefine_aux(fn: FEATURE_NAME;
                       bc: BASE_CLASS): DEFERRED_ROUTINE is
      do
         !DEFERRED_PROCEDURE!Result.from_effective(fn,arguments,
                                                   require_assertion,
                                                   ensure_assertion,
                                                   bc);
      end;

feature {NONE}

   pretty_print_once_or_do is
      do
         fmt.keyword(fz_do);
      end;

end -- PROCEDURE

