--          This file is part of SmallEiffel The GNU Eiffel Compiler.
--          Copyright (C) 1994-98 LORIA - UHP - CRIN - INRIA - FRANCE
--            Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
--                       http://SmallEiffel.loria.fr
-- SmallEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmallEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmallEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
class RUN_FEATURE_6

inherit RUN_FEATURE redefine base_feature end;

creation make

feature

   base_feature: ONCE_FUNCTION;

   arguments: FORMAL_ARG_LIST;

   result_type: TYPE;

   require_assertion: RUN_REQUIRE;

   local_vars: LOCAL_VAR_LIST;

   routine_body: COMPOUND;

   rescue_compound: COMPOUND;

   ensure_assertion: E_ENSURE;

feature

   is_once_function: BOOLEAN is true;

   is_static: BOOLEAN is false;

   static_value_mem: INTEGER is 0;

feature

   afd_check is
      do
         routine_afd_check;
      end;

   can_be_dropped: BOOLEAN is
      do
         Result := is_pre_computable;
      end;

   mapping_c is
      do
         if is_pre_computable then
            cpp_once_result;
         else
            default_mapping_function;
         end;
      end;

   c_define is
      local
         bfbc: BASE_CLASS;
      do
         bfbc := base_feature.base_class;
         if is_pre_computable then
            if not bfbc.once_flag(once_mark) then
               once_variable;
            end;
            cpp.add_pre_computed_once_function(Current);
         else
            if not bfbc.once_flag(once_mark) then
               once_boolean;
               once_variable;
            end;
            define_prototype;
            cpp.put_string("if(");
            once_flag;
            cpp.put_string("==0){%N");
            c_define_opening;
            once_flag;
            cpp.put_string("=1;%N");
            if routine_body /= Void then
               routine_body.compile_to_c;
            end;
            c_define_closing;
            cpp.put_string("}%N");
            cpp.put_string("return ");
            cpp_once_result;
            cpp.put_string(";}%N");
            c_frame_descriptor;
         end;
      end;

feature {ABSTRACT_RESULT}

   cpp_once_result is
         -- Produce the C name of the once Result.
      do
         c_code.clear;
         once_result_in(c_code);
         cpp.put_string(c_code);
      end;

   once_variable is
      do
         c_code.clear;
         c_code.extend('T');
         if result_type.is_expanded then
            result_type.id.append_in(c_code);
            c_code.extend(' ');
         else
            c_code.extend('0');
            c_code.extend('*');
         end;
         once_result_in(c_code);
         c_code2.clear;
         result_type.c_initialize_in(c_code2);
         cpp.put_extern5(c_code,c_code2);
      end;

feature {CALL_PROC_CALL}

   collect_c_tmp is
      do
      end;

feature {ADDRESS_OF_POOL}

   address_of_c_define(caller: ADDRESS_OF) is
      do
         if run_control.boost then
            if use_current then
            else
               address_of_c_define_wrapper(caller);
            end;
         else
            address_of_c_define_wrapper(caller);
         end;
      end;

feature {ADDRESS_OF}

   address_of_c_mapping is
      do
         if run_control.boost then
            if use_current then
               mapping_name;
            else
               address_of_c_mapping_wrapper;
            end;
         else
            address_of_c_mapping_wrapper;
         end;
      end;

feature {C_PRETTY_PRINTER}

   is_pre_computable: BOOLEAN is
      do
         if frozen_general.fast_has(name.to_string) then
            Result := true;
         elseif arguments = Void and then not use_current then
            if routine_body = Void then
               Result := true;
            elseif not run_control.invariant_check then
               Result := routine_body.is_pre_computable;
            end;
         end;
         if Result then
            if require_assertion /= Void then
               require_assertion.clear_run_feature;
            end;
            if ensure_assertion /= Void then
               ensure_assertion.clear_run_feature;
            end;
         end;
      end;

   c_pre_computing is
      require
         is_pre_computable;
         cpp.on_c;
      local
         bfbc: BASE_CLASS;
      do
         bfbc := base_feature.base_class;
         echo.put_character('%T');
         echo.put_string(bfbc.name.to_string);
         echo.put_character('.');
         echo.put_string(name.to_string);
         echo.put_character('%N');
         if run_control.require_check then
            if require_assertion /= Void then
               require_assertion.compile_to_c;
            end;
         end;
         if result_type.is_expanded then 
            -- *** Is this useful ? ***
            cpp_once_result;
            cpp.put_character('=');
            result_type.c_initialize;
            cpp.put_string(fz_00);
         end;
         if local_vars /= Void then
            cpp.put_character('{');
            local_vars.c_declare;
         end;
         if routine_body /= Void then
            routine_body.compile_to_c;
         end;
         if run_control.ensure_check then
            if ensure_assertion /= Void then
               ensure_assertion.compile_to_c;
            end;
         end;
         if local_vars /= Void then
            cpp.put_character('}');
         end;
         cpp.put_string("/*PCO*/%N");
      end;

   tmp_string: STRING is
      once
         !!Result.make(10);
      end;

feature {RUN_CLASS}

   jvm_field_or_method is
      do
         jvm.add_method(Current);
      end;

feature

   mapping_jvm is
      do
         routine_mapping_jvm;
      end;

feature {JVM}

   jvm_define is
      local
         branch, idx_flag: INTEGER;
         ca: like code_attribute;
      do
         ca := code_attribute;
         idx_flag := once_routine_pool.idx_fieldref_for_flag(Current);
         method_info_start;
         ca.opcode_getstatic(idx_flag,1);
         branch := ca.opcode_ifne;
         ca.opcode_iconst_1;
         ca.opcode_putstatic(idx_flag,-1);
         jvm_define_opening;
         if routine_body /= Void then
            routine_body.compile_to_jvm;
         end;
         jvm_define_closing;
         ca.resolve_u2_branch(branch);
         jvm_result_load;
         result_type.run_type.jvm_return_code;
         method_info.finish;
      end;

feature {ONCE_RESULT}

   c_variable_name: STRING is
      do
         c_code.clear;
         once_result_in(c_code);
         Result := c_code;
      end;

   jvm_result_load is
      local
         result_space, idx_result: INTEGER;
      do
         result_space := result_type.jvm_stack_space;
         idx_result := once_routine_pool.idx_fieldref_for_result(Current);
         code_attribute.opcode_getstatic(idx_result,result_space);
      end;

   jvm_result_store is
      local
         result_space, idx_result: INTEGER;
      do
         result_space := result_type.jvm_stack_space;
         idx_result := once_routine_pool.idx_fieldref_for_result(Current);
         code_attribute.opcode_putstatic(idx_result,- result_space);
      end;

   fe_vffd7 is
      do
         eh.add_position(result_type.start_position);
         fatal_error("Result type of a once function must %
                     %not be anchored (VFFD.7).");
      end;

feature {RUN_FEATURE_6}

   initialize is
      do
         result_type := base_feature.result_type;
         arguments := base_feature.arguments;
         if result_type.is_anchored then
            fe_vffd7;
         elseif result_type.is_formal_generic then
            eh.add_position(result_type.start_position);
            fatal_error("Result type of a once function must %
                        %not be a formal generic argument (VFFD.7).");
         end;
         result_type := result_type.to_runnable(current_type);
         if arguments /= Void then
            if not arguments.is_runnable(current_type) then
               !!arguments.with(arguments,current_type);
            end;
         end;
         local_vars := base_feature.local_vars;
         if local_vars /= Void then
            local_vars := local_vars.to_runnable(current_type);
         end;
         routine_body := base_feature.routine_body;
         if routine_body /= Void then
            routine_body := routine_body.to_runnable(current_type);
         end;
         if run_control.require_check then
            require_assertion := run_require;
         end;
         if run_control.ensure_check then
            ensure_assertion := run_ensure;
         end;
         rescue_compound := base_feature.rescue_compound;
         if rescue_compound /= Void then
            exceptions_handler.set_used;
            rescue_compound := rescue_compound.to_runnable(current_type);
         end;
         once_routine_pool.add_function(Current);
      end;

   frozen_general: ARRAY[STRING] is
      once
         Result := <<as_std_error, as_std_input, as_io, as_std_output>>;
      end;

   compute_use_current is
      do
         std_compute_use_current;
      end;

   update_tmp_jvm_descriptor is
      do
         routine_update_tmp_jvm_descriptor;
      end;

end -- RUN_FEATURE_6
