#
# TCL Library
#

#
# $Id: errors.tcl,v 1.2.6.2 1999/09/23 07:50:26 dorothyr Exp $
#
# Procedures for unimplemented procedures and error messages used by
# TkCVS.
#

proc notyet {} {

  set mess "This is not implemented yet.\nPlease try again in a later version."

  set title {Not Implemented Yet!}
  tk_dialog .notyet $title "$mess" error 0 Dismiss
}

proc cvsok {mess} {
#
# Sometimes cancel is meaningless, we just want
# and acknowlegement
#
  set title {Acknowledge!}
  tk_dialog .confirm $title $mess warning 0 OK
}

proc cvsconfirm {mess} {

  set title {Confirm!}
  tk_dialog .confirm $title $mess warning 0 OK Cancel
}

proc cvsfail {mess} {
  set title {tkCVS Warning!}
  tk_dialog .warn $title $mess warning 0 Dismiss
}

proc cvserror {mess} {
#
# Suggest reserving this for fatal errors that
# warrant an exit from tkcvs -dr
#
  set title {tkCVS Error!}
  tk_dialog .notyet $title $mess error 0 {Bye Bye}
  exit 1
}

