/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: os.c,v 1.11 1999/03/01 17:47:13 tiggr Exp $  */

#include <mach-o/rld.h>
#include <mach/cthreads.h>
#include <stdio.h>  /* XXX For ABORT */

/********** dynamic loading **********/

void
dload_initialize ()
{
}

char *
dload_error (void)
{
  return NULL;
}

void *
dload_load (char *name)
{
  NXStream *str = NXOpenFile (2, NX_WRITEONLY);
  const char * const names[2] = {name, 0};
  int r = rld_load (str, 0, names, 0);

  NXClose (str);
  return r ? name : 0;
}

void *
dload_lookup (void *handle, char *name)
{
  unsigned long value;
  NXStream *str = NXOpenFile (2, NX_WRITEONLY);
  int r = rld_lookup (str, name, &value);

  /* Be prepared for a port to the alpha.  */
  if (sizeof (value) < sizeof (void *))
    abort ();

  NXClose (str);
  return r ? (void *) value : 0;
}

#if 0
struct trtd_module *
dload_get_trt_module_info (void *handle)
{
  char *name = DLOAD_SYMBOL_PREFIX TRT_MODULE_INFO;
  void *r = dload_lookup (handle, name);

  if (r)
    {
      NXStream *str = NXOpenFile (2, NX_WRITEONLY);
      rld_forget_symbol (str, name);
      NXClose (str);
    }

  return r;
}
#endif
