/*
   Written by Miroslav Silovic <silovic@zesoi.fer.hr>

   Copyright (C) 1998,1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: sparc.h,v 1.4 1999/08/21 18:30:10 tiggr Exp $  */

/* XXX Too broad; drop FP regs.  --Tiggr */
#define REG_PROT_START	0
#define REG_PROT_END	(sizeof (jmp_buf) / sizeof (void *))

#define VA_ARG_BYTE(AP)  (va_arg ((AP), tom_int))
#define VA_ARG_CHAR(AP)  (va_arg ((AP), tom_int))

#define BUILTIN_RETURN_TYPE  \
union						\
{						\
  struct { tom_int i; } i;			\
  struct { tom_long l; } l;			\
  struct { void *p; } p;			\
  struct { tom_int a, b; double d; } d;	\
  struct { tom_int a, b; double f; } f;	\
}

#define PTHREADS_WITHOUT__RECURSIVE_LOCKS

#define APPLY_ARGS_REG_SIZE  (13 * sizeof (tom_int))

#define APPLY_ARGS_START(SEL)  \
  do									\
    {									\
      int offset = 0;							\
      int reserved_size = (2 * sizeof (void *)				\
			   + sizeof (tom_double) * (SEL)->out->num	\
			   + sizeof (tom_double) * (SEL)->in->num)

#define APPLY_ARGS_STACK_SIZE(SEL)  \
  reserved_size

#define APPLY_ARGS_CONTINUE() \
  do								\
    {								\
      APPLY_ARGS_EMIT_POINTER(((char*)&args->stack + 8));	\
      APPLY_ARGS_EMIT_INT(0);					\
    } while (0)

/* Macro local to this target file to emit a value of some non-floating type
   to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT_VALUE(TYPE, VALUE)  \
({	       						\
    TYPE *addr;						\
    addr = (TYPE *) ((char *) &args->stack + offset);	\
    offset += sizeof (TYPE);				\
    *addr = (VALUE);					\
    (void *) addr;})

/* Add a byte value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_BYTE(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add a char value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_CHAR(VALUE)  \
  APPLY_ARGS_EMIT_INT ((tom_int) (VALUE))

/* Add an int value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_INT(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_int, VALUE)

/* Add a long value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_LONG(VALUE)  \
    ({							\
      tom_long *addr;					\
      offset = (offset + 7) & ~7;			\
      addr = (tom_long *)((char *) &args->stack + offset); \
      offset += sizeof (tom_long);			\
      *addr = (VALUE);					\
      addr;						\
    });

/* Add a float value to the ARGS being built.    */
#define APPLY_ARGS_EMIT_FLOAT(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (tom_float, VALUE)

/* XXX incorrect... */
/* Add a double value to the ARGS being built.  */
#define APPLY_ARGS_EMIT_DOUBLE(VALUE)  \
  ({						\
    double val = (VALUE);			\
    APPLY_ARGS_EMIT_LONG (*(tom_long *) &val);	\
  })

/* Add a selector to the ARGS being built.  */
#define APPLY_ARGS_EMIT_SELECTOR(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a reference to the ARGS being built.  */
#define APPLY_ARGS_EMIT_REFERENCE(VALUE)  \
  APPLY_ARGS_EMIT_POINTER (VALUE)

/* Add a pointer to the ARGS being built.  */
#define APPLY_ARGS_EMIT_POINTER(VALUE)  \
  APPLY_ARGS_EMIT_INT_VALUE (void *, VALUE)

#define APPLY_ARGS_ACTUAL_SIZE()  \
  ((offset + 7) & ~7)

#define APPLY_ARGS_END()  \
    } while (0)

extern void* pong_builtin_apply (void *, void*, int);

#define APPLY_ARGS_APPLY(FUNC, ARGS, SIZE, RET)	 \
  pong_builtin_apply ((FUNC), (ARGS), (SIZE))
