<copyright> Bag and MutableBag classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: Bag.t,v 1.9 1998/01/05 01:04:52 tiggr Exp $</id>
    </copyright>

<doc> A Bag is a {Keyed} {Collection}.  </doc>

/******************** Bag ********************/

implementation class
Bag: HashTable, Keyed

end;

implementation instance
Bag

<doc> Return the number of times the element {key} is present in the bag.
    </doc>
int
  at All object
{
  [self unimplemented cmd];
}

/********** Keyed **********/

<doc> Return the {object} if present; {nil} otherwise.  </doc>
Any
  at All object
{
  [self unimplemented cmd];
}

/********** Enumerable **********/

Enumerator
  enumerator
{
  [self unimplemented cmd];
}

id
  initWithEnumerator Enumerator e
{
  [self unimplemented cmd];
}

end;

/******************** MutableBag ********************/

implementation class
MutableBag: Bag, MutableKeyed

end;

implementation instance
MutableBag

<doc> Add the {object} {num} times.  </doc>
void
    add All object
  count int num
{
  [self unimplemented cmd];
}

/********** MutableKeyed **********/

<doc> Add the {object}.  </doc>
void
  add All object
{
  [self add object count 1];
}

end;
