<copyright> Doubly linked lists.
    Written by <a href="mailto:silovic@zesoi.fer.hr">Miroslav Silovic</a>

    Copyright &copy; 1999 Pieter J. Schoenmakers

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: DCons.t,v 1.6 1999/09/14 18:47:43 tiggr Exp $</id>
    </copyright>

implementation class
DCons: Cons

instance (id)
  with (All, All, All) (a, d, b)
{
  = [[self alloc] init (a, d, b)];
}

end;

implementation instance
DCons
{
  <doc> The back pointer.  </doc>
  public Any cbr;
}

void
  set_cbr All c
{
  cbr = Any (c);
}

boolean
  dconsp
{
  = YES;
}

protected id (self)
  init (All, All, All) (a, d, b)
{
  [super init (a, d)];
  cbr = Any (b);
}

(All, All, All)
  dedcons
{
  = (car, cdr, cbr);
}

void
  unlink
{
  if (cbr != nil)
    [cbr set_cdr cdr];
  if (cdr != nil)
    [cdr set_cbr cbr];
}

end;

implementation class
ListEnumerator: State, Enumerator

// Discern `with DList' and `with Cons'?
// Mon Sep 13 19:32:18 1999, tiggr@gerbil.org
instance (id)
  with DList l
{
  = [[self alloc] init [l head]];
}

end;

implementation instance
ListEnumerator
{
  <doc> The current cell.  </doc>
  Cons cell;
}

<doc> Designated initializer.  </doc>
id (self)
  init Cons c
{
  cell = c;
}

(boolean, All)
  next
{
  if (cell != nil)
    {
      All obj = [cell car];
      cell = [cell cdr];
      = (TRUE, obj);
    }
}

end;

implementation class
DList: MutableOrdered

instance (id)
  new
{
  return [[self alloc] init];
}

end;

implementation instance
DList
{
  public DCons head, tail;
}

<doc><h4>Enumerable methods.</h4></doc>

Enumerator
  enumerator
{
  = [ListEnumerator with self];
}

<doc><h4>Collection methods.</h4></doc>

int
  length
{
  DCons cell = head;
  int result;

  while (cell != nil)
    {
      result++;
      cell = [cell cdr];
    }

  = result;
}

void
  add All object
{
  [self pushTail object];
}

void
  empty
{
  head = tail = nil;
}

<doc><h4>MutableOrdered methods.</h4>
 
DCons
  cellAtIndex index
{
  if (index < 0)
    return nil;

  DCons cell = head;
  while (cell != nil && index-- != 0)
    cell = [cell cdr];

  return cell;
}

void
  set All object
   at int index
{
  [[self cellAtIndex index] set_car object];
}

void
  swap All object
    at (int, int) (i, j)
{
    DCons cell1 = [self cellAtIndex i], cell2 = [self cellAtIndex j];
    All temp = [cell1 car];

    [cell1 set_car [cell2 car]];
    [cell2 set_car temp];
}

void
  reverse (int, int) (start, len)
{
  (start, len) = [self adjustRange (start, len)];
  DCons cell = [self cellAtIndex start];
  DCons cell2 = [self cellAtIndex start + len - 1];

  while (cell1 != cell2)
    {
      DCons temp1 = [cell1 cdr], temp2 = [cell1 cbr];
      [cell1 set_cdr [cell2 cdr]];
      [cell1 set_cbr [cell2 cbr]];
      [cell2 set_cdr temp1];
      [cell2 set_cbr temp2];
      (cell1, cell2) = ([cell2 cdr], [cell1 cbr]);
    }
}

<doc> Fast and easy method for the simplest case. </doc>
void
  reverse
{
    if (!head)
	return;

    DCons cell = head;
    while (cell != nil)
      {
	DCons next = [cell cdr], prev = [cell cbr];
	[cell set_cbr next];
	[cell set_cdr prev];
	cell = next;
      }

    cell = head;
    head = tail;
    tail = cell;
}

<doc><h4>DList methods.</h4></doc>

<doc> Push the cell to the front of the list.  </doc>
void
  pushHeadCons DCons cell
{
  if (!head)
    head = tail = cell;
  else
    {
      [cell set_cdr head];
      head = cell;
    }
}

<doc> Push the cell to the back of the list.  </doc>
void
  pushTailCons DCons cell
{
  if (!head)
    head = tail = cell;
  else
    {
      [cell set_cbr tail];
      tail = cell;
    }
}

<doc> Push the element to the front of the list.  </doc>
void
  pushHead All object
{
  [self pushHeadCons [DCons with (object, nil, nil)]];
}

<doc> Push the element to the back of the list.  </doc>
void
  pushTail All object
{
  [self pushTailCons [DCons with (object, nil, nil)]];
}

<doc> Remove a cell from the list.  The cell should be a member.  </doc>
void
  removeCons DCons cell
{
  if (head == cell)
    head = [head cdr];
  if (tail == cell)
    tail = [tail cbr];
  [cell unlink];
}

<doc> Pop the element from the head of the list.  </doc>
All
  popHead
pre
  head != nil
{
  DCons temp = head;
  head = [head cdr];
  if (!head)
    tail = nil;
  = [temp car];
}

<doc> Pop the element from the tail of the list.  </doc>
All
  popTail
pre
  head != nil
{
  DCons temp = tail;
  tail = [tail cbr];
  if (head == nil)
    tail = nil;
  = [temp car];
}

<doc> First element of the list.  </doc>
All
  first
pre
  head != nil
{
  = [head car];
}

<doc> Last element of the list.  </doc>
All
  last
pre
  head != nil
{
  = [tail car];
}

<doc> Return TRUE.  </doc>
boolean
  dlistp
{
  = TRUE;
}

end;
