<copyright> StringStream class.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: StringStream.t,v 1.8 1998/01/05 01:07:18 tiggr Exp $</id>
    </copyright>

<doc> A {StringStream} is sort-of an enumerator on a {String}, with a
    {InputStream} interface.  </doc>
implementation class
StringStream: State, InputStream

<doc> Return a new stream on the {string}.  </doc>
instance (id)
  with String string
{
  = [[self alloc] init string];
}

end;

implementation instance
StringStream
{
  <doc> The {String} we're streaming.  </doc>
  String string;

  <doc> The index of the next byte to read.  </doc>
  int next;
}

<doc> Designated initializer.  </doc>
protected id
  init String s
{
  string = s;

  = self;
}

/******************** InputStream ********************/

byte
  read
{
  int length = [string length];

  if (next >= length)
    [[Condition for self class stream-eos message "EOS"] raise];

  = string[next++];
}

int
  read
{
  int length = [string length];

  = next < length ? string[next++] : -1;
}

<doc> Read the range {(start, num)} from the string into the {buffer}.
    </doc>
int
  readRange (int, int) (start, num)
       into MutableByteArray buffer
{
  // If buffer == self, we should not cache this...
  // Wed Sep 18 15:51:16 1996, tiggr@cobra.es.ele.tue.nl
  int length = [string length];
  int first = next, beyond = start + num;

  while (start < beyond && next < length)
    {
      byte b = string[next++];
      buffer[start++] = b;
    }

  = next - first;
}

end;
