<copyright> Unique string classes.
    Written by <a href="mailto:tiggr@ics.ele.tue.nl">Pieter J. Schoenmakers</a>

    Copyright &copy; 1996, 1997 Pieter J. Schoenmakers.

    This file is part of TOM.  TOM is distributed under the terms of the
    TOM License, a copy of which can be found in the TOM distribution; see
    the file LICENSE.

    <id>$Id: unique-strings.t,v 1.15 1998/07/21 14:56:12 tiggr Exp $</id>
    </copyright>

/******************** UniqueString ********************/

implementation class
UniqueString: String
{
  <doc> The {Container} of all unique strings.  The container mechanism
      will ensure only those strings are kept that are still needed.
      </doc>
  static MutableSet strings;
}

<doc> Initialize the {strings} {Container}.  </doc>
void
  load Array arguments
{
  strings = [MutableSet new];
  [strings setIsContainer YES];
}

<doc> Return the {UniqueString} containing the same information as the
    {String} {s}.  This is the only method to be used to create unique
    strings.  </doc>
instance (id)
  with String s
{
  UniqueString u = strings[s];

  if (!u)
    {
      u = [s uniqueString];
      [strings add u];
    }

  = u;
}

<doc> Find the string {us} in the {strings}, comparing them using the
    selector {cmp}.  If the string is found, the old string is returned.
    Otherwise, {us} is added to the {strings} and it is returned.  </doc>
protected instance (id)
  awake instance (id) us
  equal selector cmp
{
  UniqueString s = [strings member us equal cmp];

  if (!s)
    {
      [strings add us];
      = us;
    }
  else
    = s;
}

end;

implementation instance
UniqueString
{
  <doc> The cached hash value of this string.  </doc>
  int hash;
}

<doc> Tell the {other} to compare itself to this {UniqueString}.  </doc>
boolean
  equal String other
{
  = [other equalUniqueString self];
}

<doc> Return {TRUE}.  This is simple pointer comparison.  </doc>
boolean
  equalUniqueString UniqueString other
{
  = self == other;
}

/********** Comparable **********/

<doc> Override compare, to return fast upon equality.  </doc>
int
  compare id other
{
  self == other ? 0 : [super compare other];
}

end;

/******************** UniqueByteString ********************/

implementation class
UniqueByteString: UniqueString, ByteString

end;

implementation instance
UniqueByteString

<doc> This definition is only here because we can not direct the
    implementation of this selector to the right class.  </doc>
// Not yet!
// Fri May 24 13:56:26 1996, tiggr@tom.es.ele.tue.nl
boolean
  equal String other
{
  = [super (UniqueString) equal other];
}

<doc> The same is true for this one.  </doc>
boolean
  equalUniqueString UniqueString other
{
  = [super (UniqueString) equalUniqueString other];
}

<doc> When called for the first time, hash the string, and remember the
    value.  Every next time, return the cached value.  Obviously, this
    loses for strings with a zero hash value (which keep being hashed).
    </doc>
int
  hash
{
  if (!hash)
    hash = [super (ByteString) hash];

  = hash;
}

<doc> Iff a unique string like the receiving one already exists, return
    the already existing one.  Otherwise, add the receiving string to the
    known unique strings.  </doc>
id
  awakeAfterUsingCoder Decoder coder
{
  = [isa awake self equal selector (boolean equalByteString ByteString)];
}

end;

/******************** UniqueCharString ********************/

implementation class
UniqueCharString: UniqueString, CharString

end;

implementation instance
UniqueCharString

<doc> Redefinition since we can not redirect to the right ({UniqueString})
    super.  </doc>
boolean
  equal String other
{
  = [super (UniqueString) equal other];
}

<doc> Redefinition since we can not redirect to the right ({UniqueString})
    super.  </doc>
boolean
  equalUniqueString UniqueString other
{
  = [super (UniqueString) equalUniqueString other];
}

<doc> Cached hashing, just like {UniqueByteString}.  </doc>
int
  hash
{
  /* Obviously, this loses for strings with a zero hash value.  */
  if (!hash)
    hash = [super (CharString) hash];

  = hash;
}

<doc> Iff a unique string like the receiving one already exists, return
    the already existing one.  Otherwise, add the receiving string to the
    known unique strings.  </doc>
id
  awakeAfterUsingCoder Decoder coder
{
  = [isa awake self equal selector (boolean equalCharString CharString)];
}

end;
