/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMConstant.m,v 1.12 1998/01/05 01:12:36 tiggr Exp $  */

#define OTMCONSTANT_DECLARE_PRIVATE_METHODS
#import "OTMConstant.h"
#import "OTMNumberCST.h"
#import "OTMType.h"

@implementation OTMConstant

+(OTMConstant *) constantWithExtension: (OTMExtension *) x
				  name: (id <TLString>) n
				 value: (OTMExpr *) v;
{
  return [[self gcAlloc] initWithExtension: x name: n value: v];
}

-(void) dumpInfo: (id <TLOutputStream>) s
{
  if ([value isKindOf: [CO_OTMNumberCST self]])
    formac (s, @"\n  (%# %#)", name, [(OTMNumberCST *) value outputValue]);
}

-elaborate
{
  return [value elaborate];
}

-(OTMExtension *) extension
{
  return ext;
}

-(void) gcReference
{
  MARK (ext);
  MARK (name);
  MARK (value);

  [super gcReference];
}

-(id) initWithExtension: (OTMExtension *) x
		   name: (id <TLString>) n
		  value: (OTMExpr *) v
{
  if (![super initWithType: nil])
    return nil;

  ext = x;
  name = n;
  value = v;

  return self;
}

-(id) resolveInContext: (OTMMeta *) current
{
  value = [value resolveInContext: current];

  return self;
}

-(TLCons *) resolveWithExpected: (TLCons *) expected
		    convertible: (OTMType *) to
			context: (OTMType *) cxt
			indices: (int *) indices
			  index: (int) index
{
  if (!type)
    {
      value = resolve_expr (value, nil, nil, cxt);
      type = [value type];
    }

  return [super resolveWithExpected: expected convertible: to
		context: cxt indices: indices index: index];
}

-(OTMExpr *) value
{
  return value;
}

@end
