/*
   Written by Pieter J. Schoenmakers <tiggr@ics.ele.tue.nl>

   Copyright (C) 1996 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: OTMModAssign.h,v 1.3 1998/01/05 01:13:27 tiggr Exp $  */

#ifdef OTMMODASSIGN_DECLARE_PRIVATE_METHODS
#define OTMASSIGNMENT_DECLARE_PRIVATE_METHODS
#endif
#import "OTMAssignment.h"
#import "OTMBuiltinMethod.h"
#import "OTMUnvocation.h"

@interface OTMModAssign: OTMAssignment
{
  /* The LHS is the actual LHS.  The RHS is the invocation of the
     modification.  */

  unsigned int post_not_pre;
}

+(OTMModAssign *) assignmentWithLhs: (OTMExpr *) l
				rhs: (OTMExpr *) r
			   operator: (enum builtin_operator) o
			      postp: (BOOL) p;

#ifdef OTMMODASSIGN_DECLARE_PRIVATE_METHODS

-(id) initWithLhs: (OTMExpr *) l
	      rhs: (OTMExpr *) r
	 operator: (enum builtin_operator) o
	    postp: (BOOL) p;

#endif

@end
