/* TOM blocks (for Tesla compiler).
   Written by Pieter J. Schoenmakers <tiggr@gerbil.org>

   Copyright (C) 1999 Pieter J. Schoenmakers.

   This file is part of TOM.  TOM is distributed under the terms of the
   TOM License, a copy of which can be found in the TOM distribution; see
   the file LICENSE.

   $Id: block.c,v 1.9 1999/10/05 19:35:44 tiggr Exp $  */

#include "trt.h"
#include <tom/tom-r.h>
#include <stdarg.h>
#include <stdio.h>

void *
trt_new_block (void (*body) (), selector trigger,
	       void *context, void *variables,
	       struct trtd_block *desc)
{
  tom_object b = TRT_SEND (_PI_, CREF (tom_Block), SEL (r_alloc));
  b = TRT_SEND (_PI_, b, SEL (r_initWithCode_p_trigger_s_context_p_variables__pp_),
		body, trigger, context, variables, desc);
  return b;
}

GENERIC_RETURN_TYPE
i_tom_Block_x_eval_x (tom_object self, selector cmd, ...)
{
  struct _es_i_tom_Block *this = trt_ext_address (self, _ei_i_tom_Block);
  selector formal = this->arguments;
  builtin_return_type result;
  int sel_ok = 1;
  va_list ap;

  if (trt_selectors_equal (formal, cmd))
    /* Equal selectors.  */
    ;
  else
    {
      if (!trt_selector_args_match (formal->in, cmd->in))
	if (formal->in->num == 0
	    && cmd->in->num == 1 && cmd->in->args[0] == TRT_TE_VOID)
	  ;
	else
	  sel_ok = 0;

      if (!trt_selector_args_match (formal->out, cmd->out))
	if (formal->out->num == 1 && cmd->out->num == 0)
	  /* Single return value, which is ignored.  */
	  ;
	else
	  sel_ok = 0;
    }

  if (!sel_ok)
    {
      tom_object c
	= TRT_SEND (_PI_, CREF (tom_SelectorCondition),
		    USEL (tom, r_for_r_class_r_message_r_selector_s),
		    self, c_tom_Conditions_type_condition,
		    byte_string_with_c_string ("eval selector mismatch"),
		    cmd);

      /* XXX We can signal instead of raise when we zero-out all return
	 values.  Sun Sep  5 14:20:31 1999, tiggr@gerbil.org  */
	TRT_SEND (_PI_, c, USEL (tom, v_raise));
    }

  va_start (ap, cmd);
  perform_args (&result, this->code, self, cmd, cmd, 0, &ap);
  va_end (ap);

  APPLY_ARGS_RETURN (&result);
}
