/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 
#ifndef _vdkbevpbar_h
#define _vdkbevpbar_h
#include <vdk/eventbox.h>
#include <vdk/progressbar.h>
#include <vdk/evlisthandle.h>
#include <vdk/vdkprops.h>

class VDKBEvProgressBar: public VDKEventBox
{
protected:
  VDKProgressBar *pbar;
public:
  VDKReadWriteValueProp<VDKProgressBar, double>  Value;
  VDKReadWriteValueProp<VDKProgressBar, int>  BlockCount;
  VDKReadWriteValueProp<VDKProgressBar, int>  BarStyle;
  VDKReadWriteValueProp<VDKProgressBar, int>  BarOrientation;
  VDKReadWriteValueProp<VDKProgressBar, bool> ActivityMode;

  VDKBEvProgressBar(VDKForm* owner, double min = 0.0, double max = 1.0);
  virtual ~VDKBEvProgressBar() {}
  operator VDKProgressBar*() { return pbar; }
  void Update(double val) { pbar->Update(val); }
  void SetBlockCount(int bc) { pbar->BlockCount = bc; }
#ifdef HAVE_VDKDEVEL
  void SetBarStyle(GtkProgressBarStyle style){ pbar->BarStyle = style; }
  void SetBarOrientation(GtkProgressBarOrientation or) { pbar->BarOrientation = or; }
#else
  void SetBarStyle(int style){ pbar->BarStyle = style; }
  void SetBarOrientation(int or) { pbar->BarOrientation = or; }
#endif
  void SetActivityMode(bool flag) { pbar->ActivityMode = flag; } 
};
#endif
