/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */

#include <vdkb/vdkb_evcontain.h>
#include <vdkb/vdkb_labelbutton.h>
#include <vdkb/vdkb_form.h>
#include <vdk/vdk.h>
#include <vdkb/vdkb_utils.h>
#include <vdkb/vdkb_parser.h>
#include <vdkb/vdkb_prjman.h>
#include <vdkb/vdkb_objinspect.h>
#include <vdkb/vdkb_paned.h>
#include <vdkb/vdkb_notebook.h>
#include <vdkb/vdkb_table.h>
#include <vdkb/vdkb_frame.h>
#include <vdkb/vdkb_rbgroup.h>
#include <vdkb/vdkb_radiobutton.h>
#include <vdkb/vdkb_object.h>
#include <vdkb/vdkb_fixed.h>
#include <stdlib.h>
static char buff[128];
char* vdkrbuttongroup_signals[] =
{
"toggled_signal",0
};
char* vdkrbuttongroup_nicknames[] =
{
"Toggled",0
};
///////////////////////////////////////////////////////////////////////
/*
Makes a box thats is owned by a form
 */
VDKBRadioButtonGroup::VDKBRadioButtonGroup(char* name,
			   VDKForm* owner, int mode, int w, int h):
  VDKBEventBox(name,owner)
{
Init();
}
/*
makes a box owned by another box
 */
VDKBRadioButtonGroup::VDKBRadioButtonGroup(char* name,
			   VDKBEventContainer* outer, int mode, int w, int h):
    VDKBEventBox(name,outer)
{
Init();
}
/*
 */
void
VDKBRadioButtonGroup::Init()
{
  int t;
  if(delBox)
    delBox->Caption = "Remove Radio button group";
  for(t=0; vdkrbuttongroup_signals[t]; t++)
    siglist.add(VDKBSignal(vdkrbuttongroup_signals[t],
			   this,
			   vdkrbuttongroup_nicknames[t]));
}
////////////////////////////////////////
/*
 */
void
VDKBRadioButtonGroup::Add(VDKObject* obj, int justify,
		 int expand, int fill , int padding)
{
  AddWidget(obj,justify, expand, fill, padding,true);
 }
/*
 */
void
VDKBRadioButtonGroup::AddWidget(VDKObject* wid, int justify,
			int expand, int fill , int padding,
			bool forceArgs)
{
  VDKBRadioButton* button = NULL;
  VDKBObject* vdkbobj = dynamic_cast<VDKBObject*>(wid);
  if(vdkbobj)
    button = dynamic_cast<VDKBRadioButton*>(vdkbobj);
  if(button)
    VDKBEventBox::AddWidget(wid,justify, expand, fill, padding, forceArgs);
  else
    {
      sprintf(buff,"RadioButton Groups can accomodate only RadioButtons");
      ObjectFromVDK()->Owner()->Application()->MessageBox(APPNAME,buff,
					MB_OK| MB_ICONINFORMATION);
    }
}
/*
 */
void
VDKBRadioButtonGroup::WriteOnFrm(FILE* fp, VDKBObject* parentobj)
{
  VDKBEventBox::WriteOnFrm(fp,parentobj);
}

char*
VDKBRadioButtonGroup::CreateSource(char* buffer,VDKBParser& parser)
{
  char* source;
  char obj_name[128];
  char obj_mode[16];
  char obj_parent[128];
  char temp[256];
  //  char bw[16];
  char arg[16];
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_mode,buffer,"mode:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return NULL;
  else
    source = new char[1024];

  sprintf(temp,"\n%s = new VDKRadioButtonGroup(this,%s);",obj_name,obj_mode);
  strcpy(source,temp);
  // get size
  VDKPoint size = parser.Size(buffer);
  if(size.X() > 0 || size.Y() > 0)
    {
      sprintf(temp,"\n%s->SetSize(%d,%d);",obj_name,size.X(),size.Y());
      strcat(source,temp);
    }
  bool adjArg = true;
  // has parent
  if(strcmp(obj_parent,NIHIL_PROP))
    {
      // bad OOP design here :-(
      // but in seek of semplicity..
      // boxes embedded into notebooks act differently
      char* object = parser.GetWidget(obj_parent);
      char obj_class[32];
      if(object)
	{
	  // parent is a notebook
	  if(parser.GetParam(obj_class,object,PARSER_CLASS)
	     && !strcmp(obj_class,"VDKNotebook"))
	    {
	      char label[128];
	      if(!parser.GetParam(label,buffer, PROP_LABEL))
		 *label = '\0';
	      sprintf(temp,"\n%s->AddPage(%s,\"%s\");",
		      obj_parent,
		      obj_name,
		      *label ? label : obj_name);
	      adjArg = false;
	    }
	  // other
	  else if(parser.GetParam(obj_class,object,PARSER_CLASS) &&
	      !strcmp(obj_class,"VDKTable"))
	    {
	      int row,col;
	      if(parser.GetParam(arg,buffer,PROP_TABLEROW) &&
		 strcmp(arg,NIHIL_PROP))
		row = atoi(arg);
	      else
		row = 0;
	      if(parser.GetParam(arg,buffer,PROP_TABLECOL) &&
		 strcmp(arg,NIHIL_PROP))
		col = atoi(arg);
	      else
		col = 0;
	      sprintf(temp,"\n%s->AddToCell(%s,%d,%d);",
		      obj_parent,obj_name,row,col);
	      adjArg = false;
	    }
	  else
	    sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
	  delete[] object;
	}
      // other parents
      else
	sprintf(temp,"\n%s->Add(%s",obj_parent,obj_name);
    }
  else
    sprintf(temp,"\nAdd(%s",obj_name);

  strcat(source,temp);

  if(adjArg)
    {
      // prepares arguments for add widget to container
      char justify[16],expand[16],fill[16],padding[16];
      if(parser.GetParam(justify,buffer,PROP_JUSTIFY_INTERNAL) &&
	 parser.GetParam(expand,buffer,PROP_EXPAND_INTERNAL) &&
	 parser.GetParam(fill,buffer,PROP_FILL_INTERNAL) &&
	 parser.GetParam(padding,buffer,PROP_PADDING_INTERNAL))
	{
	  sprintf(temp,",%s,%s,%s,%s);",
		  justify,expand,fill,padding);
	  strcat(source,temp);
	}
      else
	{
	  sprintf(temp,");");
	  strcat(source,temp);
	}
    }
  return source;
}
/*
 */
bool
VDKBRadioButtonGroup::CreateWidget(VDKBGuiForm* owner, char* buffer,VDKBParser& parser)
{
  char obj_name[128];
  char obj_mode[16];
  char obj_parent[128];
  VDKBRadioButtonGroup* box;
  int mode;
  // get name, mode and parent
  if ( !parser.GetParam(obj_name,buffer,"this:") ||
       !parser.GetParam(obj_mode,buffer,"mode:") ||
       !parser.GetParam(obj_parent,buffer,"parent:")
       )
    return false;
  // get mode and size
  mode = !strcmp(obj_mode,"h_box") ? h_box : v_box;
  VDKPoint size = parser.Size(buffer);
  // get packing args
  int justification = l_justify;
  int expand=0,fill=0,padding=0;
  int bw; // border width
  char arg[32];
  if(parser.GetParam(arg,buffer,PROP_JUSTIFY_INTERNAL))
    justification = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_EXPAND_INTERNAL))
    expand = atoi(arg);
  if(parser.GetParam(arg,buffer,PROP_FILL_INTERNAL))
    fill= atoi(arg);
  if(parser.GetParam(arg,buffer,"_Padding:"))
    padding= atoi(arg);
  if(parser.GetParam(arg,buffer,"BorderWidth:") &&
     strcmp(arg,NIHIL_PROP))
      bw = atoi(arg);
  else
    bw = -1;
  // no parent, widget will be added to owner form innerbox
  if(!strcmp(obj_parent,NIHIL_PROP))
    {
      box = new VDKBRadioButtonGroup(obj_name,owner->InnerBox(),mode);
      // call ancestor to set common properties
      VDKBObject::CreateWidget(box,buffer,parser);
      owner->AddWidget(box,justification,expand,fill,padding);
      if(size.X() > 0 || size.Y() > 0)
	box->ObjectFromVDK()->SetSize(size.X(),size.Y());
      if(bw >= 0)
	{
	  box->BorderWidth(bw);
	  box->SetPropValue("BorderWidth",arg);
	}

    }
  else
    // has a parent, will be added to parent.
    // Parent should be a container
    {
      // get parent container address
      VDKObject* p = owner->ChildWithName(obj_parent);
      VDKBEventContainer* container = p ?
	dynamic_cast<VDKBEventContainer*>(p) : (VDKBEventContainer*) NULL;
      if(container)
	{
	  box = new VDKBRadioButtonGroup(obj_name,container,mode);
	  // bad OOP design here :-(
	  // but in seek of semplicity..
	  // we use justification for row
	  // and expand for col to add boxes
	  char* object = parser.GetWidget(obj_parent);
	  char obj_class[32];
	  if(object)
	    {
	      // parent is a table
	      if(parser.GetParam(obj_class,object,PARSER_CLASS)
		 && !strcmp(obj_class,"VDKTable"))
		{
		  if(parser.GetParam(arg,buffer,PROP_TABLEROW) &&
		     strcmp(arg,NIHIL_PROP))
		    justification = atoi(arg);
		  else
		    justification = 0;
		  if(parser.GetParam(arg,buffer,PROP_TABLECOL) &&
		     strcmp(arg,NIHIL_PROP))
		    expand = atoi(arg);
		  else
		    expand = 0;
		}
	    }
	  // call ancestor to set common properties
	  VDKBObject::CreateWidget(box,buffer,parser);
	  container->AddWidget(box,justification,expand,fill,padding,true);
	  if(size.X() > 0 || size.Y() > 0)
	    box->ObjectFromVDK()->SetSize(size.X(),size.Y());
	  box->outerbox = container;
	  if(bw >= 0)
	    {
	      box->BorderWidth(bw);
	      box->SetPropValue("BorderWidth",arg);
	    }
	}
      else
	return false; // FIX ME: user warning
    }
return true;
}
/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
VDKBRadioButtonGroup::MakeWidgetV(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable box counter
  // to ensure unicity
  int result = 0;
  VDKBRadioButtonGroup* box = NULL;
  if(owner->Active)
    {
      for(sprintf(buff,"VRadioButtonGroup%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"VRadioButtonGroup%d",VDKBEventBox::Counter);
      box = new VDKBRadioButtonGroup(buff,owner,v_box);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	   if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      box->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      box->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(box,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(box);
	  box->outerbox = container;
	}
      // target isn't a container
      else if(! owner->Active->AddToParent(box,ev))
	result =  2;
    }
  else
    // no active widget
    result =  3;
 // 0 on success
  if(result && box)
    box->Destroy();
 return result;
}

/*
  This method is called by global MakeWidget() in vdkb_design.cc
  MakeWidget() scans a table that maps class id's with each
  static MakeWidget() for each class. Class id's are generated
  during clicks on widget palette.
  On return:
  0 - successfull
  1 - unsupported widget
  2 - target is not a container
  3 - no active widget
*/
int
VDKBRadioButtonGroup::MakeWidgetH(VDKBGuiForm* owner, GdkEvent* ev)
{
  // autogenerate first suitable box counter
  // to ensure unicity
  int result = 0;
  VDKBRadioButtonGroup* box = NULL;
  if(owner->Active)
    {
      for(sprintf(buff,"HRadioButtonGroup%d",VDKBEventBox::Counter);
	  owner->ChildWithName(buff)!= (VDKObject*) NULL;
	  VDKBEventBox::Counter++)
	sprintf(buff,"HRadioButtonGroup%d",VDKBEventBox::Counter);
      box = new VDKBRadioButtonGroup(buff,owner,h_box);
      VDKBEventContainer* container =
	dynamic_cast<VDKBEventContainer*>(owner->Active);
      if(container)
	{
	   if(ev && dynamic_cast<VDKBFixed*>(container))
	    {
	      GdkEventButton* event = (GdkEventButton*) ev;
	      sprintf(buff,"%d",int(event->x));
	      box->SetPropValue(JUSTIFY_INTERNAL,buff);
	      sprintf(buff,"%d",int(event->y));
	      box->SetPropValue( EXPAND_INTERNAL,buff);
	      // others than justify and flag unuseful
	      container->AddWidget(box,int(event->x),
				   int(event->y),
				   true,true,true);
	    }
	  else
	    container->AddWidget(box);
	  box->outerbox = container;
	}
      // target isn't a container
      else if(! owner->Active->AddToParent(box,ev))
	result = 2;
    }
  else
    // no active widget
    result =  3;
 // 0 on success
  if(result && box)
    box->Destroy();
 return result;
}

VDKObjectContainer*
VDKBRadioButtonGroup::ExtraWidget(VDKBObjectInspector* isp)
{
  VDKObjectContainer* box = VDKBEventBox::ExtraWidget(isp);
  border->Enabled = false;
  return box;
}





