(**
    Demo for VisualOberon. Demonstrates the tree object.
**)

MODULE TestTree;

(*
    Demo for VisualOberon. Demonstrates the tree object.
    Copyright (C) 1998  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details. 

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D   := VODisplay,
       G   := VOGUIObject,
       K   := VOKeyHandler,
       T   := VOTree,
       TM  := VOTreeModel,
              VOUsePrefs,
       W   := VOWindow,

              Err;

VAR
  d          : D.Display;
  w          : W.Window;
  keyHandler : K.KeyHandler;

  tree       : T.Tree;
  model      : TM.TreeModel;

  msg2Exit   : D.Msg2Exit;


BEGIN
  NEW(d);
  IF ~d.InitDisplay("TestTree") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(model);
  model.Init;
  model.SetTop(TM.CreateTextItem(model,"one"));
  model.top.AddChild(TM.CreateTextItem(model,"two"));
  model.top.firstChild.AddChild(TM.CreateTextItem(model,"two (a)"));
  model.top.firstChild.AddChild(TM.CreateTextItem(model,"two (b)"));
  model.top.firstChild.ShowChilds;
  model.top.AddChild(TM.CreateTextItem(model,"three"));
  model.top.ShowChilds;
  model.top.InsertAfter(TM.CreateTextItem(model,"four"));
  model.top.next.AddChild(TM.CreateTextItem(model,"five"));
  model.top.next.AddChild(TM.CreateTextItem(model,"six"));
  model.top.next.ShowChilds;
  model.top.next.InsertAfter(TM.CreateTextItem(model,"seven"));
  model.top.next.next.AddChild(TM.CreateTextItem(model,"eight"));
  model.top.next.next.AddChild(TM.CreateTextItem(model,"nine"));
  model.top.next.next.ShowChilds;
  model.top.next.next.InsertAfter(TM.CreateTextItem(model,"ten"));

  NEW(keyHandler);
  keyHandler.Init;

  NEW(tree);
  tree.Init;
  tree.SetFlags({G.horizontalFlex,G.verticalFlex});
  tree.SetWidth(G.sizeFontRel,30);
  tree.SetHeight(G.sizeFontRel,30);
  tree.SetModel(model);
  keyHandler.AddFocusObject(tree);

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(tree);
  w.SetTitle("TestTree");
  w.AddKeyHandler(keyHandler);
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;
  
  d.Handler;

  d.Deinit;
END TestTree.