(**

**)

MODULE VOPatternLegend;

(*
    ???
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VODisplay,
       F := VOFrame,
       G := VOGUIObject;

TYPE
  PatternLegend*     = POINTER TO PatternLegendDesc;
  PatternLegendDesc* = RECORD (G.GroupDesc)
                         frame   : F.Frame;
                         maximum : LONGINT;
                       END;

  PROCEDURE (p : PatternLegend) Init*;

  BEGIN
    p.Init^;

    p.frame:=NIL;
    p.maximum:=-1;
  END Init;

  PROCEDURE (p : PatternLegend) SetMaximum*(maximum : LONGINT);

  BEGIN
    p.maximum:=maximum;
  END SetMaximum;

  PROCEDURE (p : PatternLegend) CalcSize*(display : D.Display);

  VAR
    object : G.Object;

  BEGIN
    p.width:=0;
    p.height:=0;
    p.minWidth:=0;
    p.minHeight:=0;

    NEW(p.frame);
    p.frame.Init;
    p.frame.SetFlags({G.horizontalFlex,G.verticalFlex});
    p.frame.SetInternalFrame(F.single3DOut);
    p.frame.CalcSize(display);

    object:=p.list;
    WHILE object#NIL DO

      object.CalcSize(display);

      p.width:=G.MaxLong(p.width,object.oWidth);
      INC(p.height,G.MaxLong(2*display.spaceHeight+p.frame.topBorder+p.frame.bottomBorder,
                             object.oHeight));

      p.minWidth:=G.MaxLong(p.minWidth,object.oMinWidth);
      INC(p.minHeight,object.oMinHeight);

      object:=object.next;
    END;

    IF p.count>0 THEN
      INC(p.height,(p.count-1)*display.spaceHeight);
      INC(p.minHeight,(p.count-1)*display.spaceHeight);
    END;

    INC(p.width,3*display.spaceWidth+p.frame.leftBorder+p.frame.rightBorder);
    INC(p.minWidth,3*display.spaceWidth+p.frame.leftBorder+p.frame.rightBorder);

    p.CalcSize^(display);
  END CalcSize;

  PROCEDURE (p : PatternLegend) Draw*(x,y : LONGINT; draw : D.DrawInfo);

  VAR
    pos,count : LONGINT;
    object    : G.Object;

  BEGIN
    p.Draw^(x,y,draw);

    pos:=p.y;
    count:=1;
    object:=p.list;
    WHILE object#NIL DO
      draw.PushUniqueFillPattern(count,p.maximum);
      draw.FillRectangle(p.x,pos,2*p.display.spaceWidth,2*p.display.spaceHeight);
      draw.PopUniqueFillPattern(count,p.maximum);
      p.frame.Resize(2*p.display.spaceWidth,2*p.display.spaceHeight);
      p.frame.Draw(p.x,pos,draw);
      object.Resize(p.width,-1);
      object.Draw(p.x+3*p.display.spaceWidth+p.frame.leftBorder+p.frame.rightBorder,pos,draw);
      INC(pos,object.oHeight+p.display.spaceHeight);
      INC(count);
      object:=object.next;
    END;
  END Draw;

  PROCEDURE (p : PatternLegend) Refresh*(x,y,w,h : LONGINT);

  BEGIN
    (*
      We have to store all frames to get a properly working
      smarter refresh.

      Because we don't have, we simply redraw it all again.
    *)
    p.Redraw;
  END Refresh;

  PROCEDURE (p : PatternLegend) Hide*;

  VAR
    help : G.Object;

  BEGIN
    IF p.visible THEN
      p.frame.Hide;
      help:=p.list;
      WHILE help#NIL DO
        help.Hide;
        help:=help.next;
      END;
      p.Hide^;
    END;
  END Hide;

END VOPatternLegend.