/* param.c 
 * 
 * Receive command line parameters at module installation
 */

/* Copyright (C) 1998 by Ori Pomerantz */



/* The necessary header files */

/* Standard in kernel modules */
#include <linux/kernel.h>   /* We're doing kernel work */
#include <linux/module.h>   /* Specifically, a module */

/* Deal with CONFIG_MODVERSIONS */
#if CONFIG_MODVERSIONS==1
#define MODVERSIONS
#include <linux/modversions.h>
#endif        

#include <stdio.h>  /* I need NULL */

char *str1, *str2;


/* Initialize the module - show the parameters */
int init_module()
{
  if (str1 == NULL || str2 == NULL)
    printk("Next time, do insmod param str1=<something> str2=<something>\n");
  else
    printk("Strings:%s and %s\n", str1, str2);

  return 0;
}


/* Cleanup */
void cleanup_module()
{
}  
