/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : DPResample.h
|
| Revision    : 1.0
| Date        : 07/05/96
|
| Object      : None
|
| Description : Prototypes for the DPResample functions
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

#ifndef _DPResample_h
#define _DPResample_h

#include <math.h>
#include <stdlib.h>
#include "DPSample.h"

long resample (
  DPSample *sample,
  DPSample *newSample,
  long     chan,
  long     R,
  long     N,
  long     Nw,
  long     D,
  long     I,
  double   P,
  double   synt);

void makewindows (
  double A [],
  double S [],
  long   Nw,
  long   N,
  long   I);

long shiftin (
  DPSample *sample,
  long     channel,
  double   A [],
  long     N,
  long     D,
  long     initialise);

void fold (
  double I [],
  double W [],
  long   Nw,
  double O [],
  long   N,
  long   n);

long convert (
  double S [],
  double C [],
  long   N2,
  long   D,
  long   R,
  long   initialise,
  long   remove);

long oscbank (
  double C [],
  long   N,
  long   R,
  long   I,
  double O [],
  double P,
  double synt,
  long   initialise,
  long   remove);

long unconvert (
  double C [],
  double S [],
  long   N2,
  long   I,
  long   R,
  long   initialise,
  long   remove);

void overlapadd (
  double I [],
  long   N,
  double W [],
  double O [],
  long   Nw,
  long   n);

void shiftout (
  DPSample *newSample,
  long     channel,
  double   A [],
  long     N,
  long     I,
  long     n,
  long     initialise);

void rfft (
  double x [],
  long   N,
  long   forward);

void cfft (
  double x [],
  long   NC,
  long   forward );

void bitreverse (
  double x [],
  long   N);

#endif // _DPResample_h

/***************************************************************************/
