/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : comb.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitComb
|
| Description : DSPKitComb
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char comb_cc [] = "$Id$";

#include "comb.h"

long DSPKitComb::setInputAndDelayTime (DSPKitProcessor *ip,double dt)
{
  delayTime = dt;   
  feedback.setInput (ip);
  feedback.setFeedbackTime (0.0);
  fbdelay.setInputAndDelayTime (&feedback,delayTime);
  mux.setInput (&fbdelay);
  amp.setInput (&mux);
  feedback.setFeedbackInput (&amp);
  return DSPKitProcessor::setInput (&mux);
}

void DSPKitComb::setReverbTime (double rt)
{
  reverbTime = rt;
  g = pow (0.001,delayTime / reverbTime);
  feedback.setFeedbackTime (reverbTime);
  amp.setGain (g);
}

void DSPKitComb::setG (double newG)
{
  if (newG <= 0.0)
    g = 0.00001;
  else if (newG >= 1.0)
    g = 0.99999;
  else
    g = newG;

  reverbTime = 3.0 * delayTime / log10 (1.0 / g);
  feedback.setFeedbackTime (reverbTime);
  amp.setGain (g);
}

/***************************************************************************/

