/****************************************************************************
|                         Digital Audio Processor
|                         =======================
|
| Filename    : z1lpf.cc
|
| Revision    : 1.1
| Date        : 25/01/96
|
| Object      : DSPKitZ1LowPassFilter
|
| Description : DSPKitZ1LowPassFilter
|
| (c) Richard Kent 1996
|
| $Id$
|
****************************************************************************/

static char z1lpf_cc [] = "$Id$";

#include "z1lpf.h"

DSPKitZ1LowPassFilter::DSPKitZ1LowPassFilter ()
{
  buf = 0.0;
  g   = 0.0;
}

long DSPKitZ1LowPassFilter::setInput (DSPKitProcessor *ip)
{
  DSPKitProcessor::setInput (ip);
  buf = 0.0;
  return 0;
}

long DSPKitZ1LowPassFilter::getSample (double &outputSample)
{
  double inputSample;
  if (!input->getSample (inputSample)) return 0;
  outputSample = inputSample + buf * g;
  buf = inputSample;
  return 1;
}

/***************************************************************************/
