/****************************************************************************
 * menu.c                                                                   *
 *                                                                          *
 * An example form showing a fake menu utilizing tooltips system.           *
 *                                                                          *
 * Copyright (C) 1996  Michael Chu                                          *
 * This file is part of the examples for the tooltips system for XForms.    *
 *                                                                          *
 * This program is free software; you can redistribute it and/or modify     *
 * it under the terms of the GNU General Public License as published by     *
 * the Free Software Foundation; either version 2 of the License, or        *
 * (at your option) any later version.                                      *
 *                                                                          *
 * This program is distributed in the hope that it will be useful,          *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
 * GNU General Public License for more details.                             *
 *                                                                          *
 * You should have received a copy of the GNU General Public License        *
 * along with this program; if not, write to the Free Software              *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                *
 *                                                                          *
 * Contact information:      Michael Chu                                    *
 *                           mmchu@CS.Berkeley.EDU                          *
 ****************************************************************************/

#include <stdio.h>
#include <unistd.h>
#include "forms.h"
#include "menu_forms.h"
#include "tooltips.h"

void main(int argc, char *argv[])
{
  FD_Menu *formPtr = NULL;
  FL_OBJECT *objPtr = NULL;

  /* initialize the XForms system. */
  fl_initialize(&argc, argv, "Menu", 0, 0);

  /* create the form */
  formPtr = create_form_Menu();

  /* initialize the tooltips system. */
  tooltips_initialize();

  /* add the tooltips. */
  tooltips_addtip(formPtr->New, "Create a new document");
  tooltips_addtip(formPtr->Open, "Open an existing document");
  tooltips_addtip(formPtr->Save, "Save a document to disk");
  tooltips_addtip(formPtr->SaveAs, "Save a document as a different name");
  tooltips_addtip(formPtr->Print, "Print a document");
  tooltips_addtip(formPtr->Quit, "Quit now! Pressing on this will quit demo!");

  /* show the form. */
  fl_show_form(formPtr->Menu, FL_PLACE_CENTER, FL_TRANSIENT, "Menu");

  /* handle inputs. */
  for (;;) {
    objPtr = fl_do_forms();

    if (objPtr == formPtr->New) {
      printf("New was pressed\n");
    } else if (objPtr == formPtr->Open) {
      printf("Open was pressed\n");
    } else if (objPtr == formPtr->Save) {
      printf("Save was pressed\n");
    } else if (objPtr == formPtr->SaveAs) {
      printf("Save As was pressed\n");
    } else if (objPtr == formPtr->Print) {
      printf("Print was pressed\n");
    } else if (objPtr == formPtr->Quit) {
      printf("Quit was pressed\n");
      fl_hide_form(formPtr->Menu);
      fl_free_form(formPtr->Menu);
      formPtr = NULL;
      exit(0);
    }
  }
}
