/* $Id: utils.c,v 1.5 2000/02/27 07:51:40 kitame Exp $

  utility functions for DEdit

  Copyright (C) 1999  Takuo KITAME

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License with
  the Debian GNU/Linux distribution in file /usr/doc/copyright/GPL;
  if not, write to the Free Software Foundation, Inc., 59 Temple Place,
  Suite 330, Boston, MA  02111-1307  USA
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <zlib.h>

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/param.h>

#include <gnome.h>

/* Return 0 (not gziped) or gunziped size */
int
isgz(const char *filename)
{
	FILE *fp;
	gzFile *gzfp;
	char *buf;
	int gzsize = 0;
	struct stat st;

	if(stat(filename, &st) != -1) {
		buf = (char *)malloc(2);
		fp = fopen(filename, "r");
		fread(buf, 1, 2, fp);
		fclose(fp);
		if(buf[0] == '\037' && buf[1] == '\213') { /* gz file */
			gzfp = gzopen(filename, "r");
			for(; gzgetc(fp) != EOF; gzsize++);
			gzclose(gzfp);
			free(buf);
			return gzsize;
		}
		free(buf);
	}
    
    return 0;
}

/* 
 * Хѥμ 
 * force_realpath() coded by Fumitoshi UKAI <ukai@debian.org>.
 * Modified for DEdit by Takuro KITAME <kitame@northeye.org>.
 */
char *
force_realpath(char *check_path, char *full_path, char *path){
    char resolved_path[MAXPATHLEN];
    char opath[MAXPATHLEN];
    char *op, *bp;
    char *p;
    
#ifdef TRACE_FUNC
    printf("force_realpath()\n");
#endif
    
    strcpy(opath, check_path);
    bp = strrchr(opath, '/');
    if (bp == NULL) {
        op = ".";
        bp = opath;
    } else {
        *bp++ = '\0';
        op = opath;
    }
    p = realpath(op, resolved_path);
    if(!p)
        return NULL;
    
    g_snprintf(full_path, MAXPATHLEN, "%s/%s", p, bp);
    g_snprintf(path, MAXPATHLEN, "%s", p);
    
    return full_path;
}
