/*
 * LEVEE, or Captain Video;  A vi clone
 *
 * Copyright (c) 1982-1997 David L Parsons
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by David L Parsons (orc@pell.chi.il.us).  My name may not be used
 * to endorse or promote products derived from this software without
 * specific prior written permission.  THIS SOFTWARE IS PROVIDED
 * AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
 * WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE.
 */
/*
 * Unix interface for levee
 */
#include <termios.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <term.h>
#include <curses.h>

#include "levee.h"
#include "extern.h"

int min(int a, int b)
{
    return (a>b) ? b : a;
}

int max(int a, int b)
{
    return (a<b) ? b : a;
}

void strput(char *s)
{
    if (s)
#if TERMCAP && !TERMCAP_EMULATION
	tputs(s, 1, putchar);
#else
	write(1, s, strlen(s));
#endif
}

#ifdef LIBC_HAS_NO_BASENAME
char *basename(char *s)
{
    char *rindex();
    char *p;

    if ((p = strrchr(s,'/')))
	return 1 + p;

    return s;
}
#endif


static int ioset = 0;
static struct termios old;

void initcon()
{
    struct termios new;

    if (!ioset) {
        ioctl(0, TCGETS, &old);	/* get editing keys */

        Erasechar = old.c_cc[VERASE];
        eraseline = old.c_cc[VKILL];

        ioctl(0, TCGETA, &old);	/* get editing keys */
        new = old;

	new.c_iflag &= ~(IXON|IXOFF|IXANY|ICRNL|INLCR);
	new.c_lflag &= ~(ICANON|ISIG|ECHO);
	new.c_oflag = 0;

        ioctl(0, TCSETAF, &new);
        ioset=1;
    }
}

void fixcon()
{
    if (ioset) {
         ioctl(0, TCSETAF, &old);
         ioset = 0;
    }
}

char getKey()
{
    fd_set input;

    FD_ZERO(&input);
    FD_SET(0, &input);

    fflush(stdout);

    /* we're using Unix select() to wait for input, so lets hope that
     * all the Unices out there support select().  If your Unix doesn't,
     * you can make this work by replacing this select loop with:
     *
     *       while (read(0,c,1) != 1)
     *           ;
     *       return c[1];
     *
     * ... and watch your load-average peg.
     */

    for (;;) {
	select(1, &input, 0, 0, 0);
	{
	    char c;
	    if (read(0, &c, 1) == 1)
		return c;
	}
    };
}

