;; Copyright (C) 1992 Free Software Foundation, Inc.
;; This file is part of Mule (MULtilingual Enhancement of GNU Emacs).
;; This file contains Chinese characters from japanese Kanji fonts
;; for use with Hangul document (especially with HLaTeX).

;; Mule is free software distributed in the form of patches to GNU Emacs.
;; You can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 1, or (at your option)
;; any later version.

;; Mule is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;; 93.6.30   Written for Mule Ver.0.9.8.01 by K.H. UN.
;;	 <zraun01@hpserv.zdv.uni-tuebingen.de>
;;	Original table is from quail-py.el.
;; 94.10.7   Modified for Mule Ver.2.1 by K.Handa <handa@etl.go.jp>

;; # KANJI input table for Mule to be used in hangul document.
;; # With "jhtex" an extended KS-to-TeX converter you can use watanabe-jfonts
;; # in HLaTeX documents.(You must use *euc-korea* coding system)

(require 'quail)

(quail-define-package
 "hanja-jis" "2$(C9z=D(BJIS$B4A;z(B" t
 "$B3:aD$(CGO4B(B $B4A;z$(C@G(B $B1$$(C@;(B $(CGQ1[(B2$(C9z$B<0$(C@87N(B $B8F=P$(CGO?)(B $BA*Z$(B"
 '(
   ("," . quail-prev-candidate-block)
   ("<" . quail-prev-candidate-block)
   ("." . quail-next-candidate-block)
   (">" . quail-next-candidate-block)
   (" " . quail-select-current)
   )
 )

(qdv "rk"	"$B1]2>2@2A2B2C2D2E2G2H2K2M2N2Q2T2W2X2`2o3976P$PqQ+RjS'[H[I`]aPcwgWhSkEkhlKlhmF(B")
(qdv "rkr"	"$B3F3J3L3P3Q3S3U5Q5S9oH9RJS>T=WmXBZ([d]W`Bk4l;r((B")
(qdv "rks"	"$B064%4&4)4/43444B4G4H4J4N4V:&:):1?{U!XLYc[8[K[Y[e`CarcCecgek]s*su(B")
(qdv "rkf"	"$B2p3e3i3k3l7GP"[+brcqf;iypbpv(B")
(qdv "rka"	"$B4*4.46484:4;4E4F4U7g848::0QaT,T0VHY"Y~\m]>^@aQbWeHiTm^nGoHs|(B")
(qdv "rkq"	"$B2!389C9gL(R:b5fpo^(B")
(qdv "rkd"	"$B2,3`6/607D9/959>9G9K9P9V9]9_9dFzP6Q,S3U*V>XMY,[:[|aEbee,eZf5i(jvlora(B")
(qdv "ro"	"$B2B2U2p2r2~3'3)3+3,3.313435383;8DP"P$PCQsXAXhYb\4^taNb5k;(B")
(qdv "ror"	"$B5RS=(B")
(qdv "rod"	"$B9#99dkf=f>o3(B")
(qd "ri"	"$B2X(B")
(qd "rir"	"$BnS(B")
(qdv "rj"	"$B5n5o5p5q5r5t5w5x<V?x?~P`PbTRZ!Z)Z*]0_Yc@d(gplwn1nSnj(B")
(qdv "rjs"	"$B4%6R7o7r7z80X4Ykg'iJkim!qZ(B")
(qdv "rjf"	"$B3i7G7f8pC4KqPu[?[\]ccq(B")
(qdv "rja"	"$B4;7p7u8!84Q-QxQyQzQ{\}b[g@sX(B")
(qdv "rjq"	"$B5h619e=&Qg(B")
(qdv "rp"	"$B7F7GPuX\br(B")
(qdv "rur"	"$B2>3J3V3W7b7cPqYH\|g-h#k.ojqnr/rps&(B")
(qdv "rus"	"$B3_3o7x8#8$8(8*8+8/G{KzLzPWVtWz[G`Fa+d*f0l$s$(B")
(qdv "ruf"	"$B5K7@7h7i7k7mLRQSY1YIYMe~r!(B")
(qdv "rua"	"$B3y7s8,XDY:]>d/heni(B")
(qdv "ruq"	"$B3fKKXDnw(B")
(qdv "rud"	"$B5~6%6*6-6@6C797B7D7I7J7P7T7U7Y7Z7[7_9.999<9E9L:"P7Q?QDQHQmR&R'S+WMX]\{_i`{a9a[b~e%e4e;fVfzh3krmKmtpopts](B")
(qdv "rP"	"$B2|3#3&3,5(787<7@7K7L7N7O7Q7R7W7\:fFOU|W@X)[G^da8b#c4d"e;eki)kSl0r!s1(B")
(qdv "rh"	"$B6l8E8G8H8I8K8N8O8S8T8V8Z8[8\8]9F9M9Q9b9i9p;)<J?,C!ONPFQYQjRmZ?ZJZ^[W[][^\I\_]xa`b(bPb\cLd2f*f6fxiVjCk8kFkUlKmcn~pQrurzsi(B")
(qdv "rhr"	"$B6J9p9r9s9tC+H#S-ZO[g\`mXq~(B")
(qdv "rhs"	"$B:$:%:+:-:.TgVBW}[~^xhBjnrArJs.(B")
(qdv "rhf"	"$B3j9|\K]qs3(B")
(qdv "rhd"	"$B6!6&62636u8x8y9&9)95969WPeW0YJ[}\Jd3iOi^i_lop_(B")
(qdv "rhk"	"$B1;2I2J2L2[2]2a8S8X8YFiTFTnTrXyfxhTixjglvpy(B")
(qdv "rhkr"	"$B3G3TZ2Z<[v\Zayb_oWp9(B")
(qdv "rhks"	"$B4'4142474=4>4C4I4P4Q4S4X4[4\6z?{P%QN]Y^ub9eEeGf%k7oQopsA(B")
(qdv "rhkf"	"$B3g3hH&I0Qi[XfZ(B")
(qdv "rhkd"	"$B3H6)688w9-9[9\T]W"Z2[%[&[Z^+bhc~d!e&e-fykToJ(B")
(qdv "rho"	"$B3]757SS%XyYL[Jjh(B")
(qdv "rhl"	"$B2q2t2u2x2z2}3!P*PzTUW_XC\G`skK(B")
(qdv "rhlr"	"$Bg2qE(B")
(qdv "rhld"	"$B9(9I9O9l^3mDo)(B")
(qdv "ry"	"$B3I3P3S3z5j6#6+6,65666:6>8r8s9'9*9;9J9Y9Z;->7R{UHYxZJ\r_$`Db)c#c\fKg1i`m]n[q-qaqb(B")
(qdv "rn"	"$B11192$2%2*3C555V5W5X5_5a5d5e5f5l5q6e6f6g6h6i6j6k6m6n6o6p6q7)8{8}9$949=9B9XC!G#H7KUP}QJR"R?RkSRU=UBUdVOV}V~WaW|XvY+Yl[M[N]?]X]\a.aLbZc`d@gOgQgqhgiUjMjdk2kMkpmsn)n9nlplq'qDq\r-szs}(B")
(qdv "rnr"	"$B5E5F5G6I9m9qSxT"[xdxkqlr(B")
(qdv "rns"	"$B7/727374[ub0b1c[f:je(B")
(qdv "rnf"	"$B6~7!7"KYPcRPVA(B")
(qdv "rnd"	"$B5\5]5gcVm;(B")
(qdv "rnjs"	"$B4+4,5s7q7t7w7}7~8"R%R0RKT!X+[{\^bGe<ipq"(B")
(qdv "rnjf"	"$B7!OOP-RP`Um,om(B")
(qdv "rnp"	"$B4y5"50B|DYQ\R<[z]$]Eb'dOgLkLlnm,q9q?(B")
(qdv "rnl"	"$B5"5.5455S@[z]Eb's}(B")
(qdv "rnlr"	"$BDOVn(B")
(qdv "rb"	"$B0*1.5,5j6+6e7=7>:"DPTwYdYw\\b#bkcad}eYj_lbm|oaqDr-(B")
(qdv "rbs"	"$B556Q6]d0nbsKs}(B")
(qd "rbf"	"$B5L(B")
(qdv "rmr"	"$B2D3W6K7`7a7d9nP4QnUqV![yh{n<(B")
(qdv "rms"	"$B6O6P6R6T6Z6\6`6a:,Xi\]`wbbhAk3ncq<(B")
(qdv "rmf"	"$B7@k?(B")
(qdv "rma"	"$B6S6W6X6Y6^6_6b8i:#SaZ"jPsX(B")
(qdv "rmq"	"$B075Z5^5b5h5i5kV)(B")
(qdv "rmd"	"$B919NOJOKQ>Wqbb(B")
(qdv "rl"	"$B0k4k4l4o4p4q4s4t4v4w4z4{4|4}4~5!5$5%5&5'5*5-5/5253585;5=5@5o778J8k8p:j:k:l<(B6H)IIL'P4PXQCQpSOSZT-TtV?W1YVZ\Zz[.[9[L[w\H]c]f]k^?aCc2cEe:f3f4fMk+k1kxl1leq@qVqgr?sJ(B")
(qd "rlr"	"$B5J(B")
(qd "rls"	"$B6[(B")
(qdv "rlf"	"$B5H5K5MPKYI(B")
(qd "rla"	"$B6b(B")
(qd "Rlr"	"$B5J(B")
(qdv "sk"	"$BF`FaFqQ5U1XoY.Y<Y=[kdy(B")
(qd "skr"	"$BBz(B")
(qdv "sks"	"$BCHFqZ:_kl_(B")
(qdv "skf"	"$BFhYT^:(B")
(qdv "ska"	"$BCKFnFoSGU3n((B")
(qdv "skq"	"$BG<jU(B")
(qdv "skd"	"$BG9L<[((B")
(qdv "so"	"$BBQF`FbFwG5G6G=mr(B")
(qdv "sid"	"$B>nUP(B")
(qdv "su"	"$B=wY<Y=h'(B")
(qdv "sus"	"$BG/G2bzmY(B")
(qdv "suf"	"$BYT^:(B")
(qdv "sua"	"$BG0WwY@\,(B")
(qdv "suq"	"$B@]G1Ypm:oR(B")
(qdv "sud"	"$BG+Sf_?`Xfd(B")
(qdv "sP"	"$BG)Zc(B")
(qdv "sh"	"$BEXE[E\G>RsUWVfW8`obug*gBqN(B")
(qdv "shd"	"$BG;G?G@Q/(B")
(qd "shk"	"$B<6(B")
(qdv "shl"	"$BG:G>X=g*q/(B")
(qdv "sy"	"$BE.G"U>Yz\vo?o_r)(B")
(qd "sn"	"$BfU(B")
(qd "sns"	"$BUD(B")
(qdv "snf"	"$BRefmkD(B")
(qdv "sb"	"$BI3WY`=nf(B")
(qdv "sbr"	"$BWYjHjI(B")
(qd "smd"	"$BG=(B")
(qdv "sl"	"$BE%FtG)G*Wb_>_Pg7(B")
(qdv "slr"	"$BE.F?(B")
(qdv "slf"	"$BFtWbZc(B")
(qdv "sla"	"$BDBWl(B")
(qdv "ek"	"$BB?BgCcTl(B")
(qdv "eks"	"$B1_C"C0C1C4C6C;C<C=C@CACCCDCECGCICJFNFXP9SET%WAXIXUZR\g^Z`NaUeKh[iijXj{j|nBs((B")
(qdv "ekf"	"$BC#RtU'WeZ%_}`\m}orpZpg(B")
(qdv "eka"	"$BC4C8C9C?CLF^S7S8T`XkY?]__,_8abb>g<i!k)k}q5(B")
(qdv "ekq"	"$B7#EkEzF'Quh)(B")
(qdv "ekd"	"$BE^EbEdEvE|F2F5Q8Vq[c\+^oaDbUc'j0j;j}oFs^(B")
(qdv "eo"	"$B10BPBRBSBTBWB^B_BbBcBeBgFXT2UtVhZ,Z-`^gJi7o>p0(B")
(qdv "ejr"	"$BFAW\(B")
(qdv "eh"	"$B0p?^D)D7EHEIEKELEOEQERESETEUEYE]EaEgEhEiEmEnEpEqEsExE~F(F+F3F:F;R[T&V:Y[Y\YqZ.[7[m\*]%]9^9^mbQcKe6eBeCe{h8h9k/lum%mmokpkqC(B")
(qdv "ehr"	"$B<3FBFDFEFFFGFHFI`1`9`We{l&qqsb(B")
(qdv "ehs"	"$B=cFUFWFXFYFZF[F\Z}_wa&n,q+(B")
(qdv "ehf"	"$BFMF\Rt[S(B")
(qdv "ehd"	"$B4R6ME_E`ElEoF!F/F0F1F4F6F7F8F9F<Q*\u_.aVdig^gtr<s)sj(B")
(qdv "en"	"$B1%3u?`EMENEZEwF&F,FIP5Y5ceflh:iQjEjFl&nFr((B")
(qdv "ens"	"$BFVF[F\F_g=n,(B")
(qd "emr"	"$BF@(B")
(qdv "emd"	"$BEPEtEuEyF#F%F*F-VS\t^naVc$d[d\eX(B")
(qdv "fk"	"$B;IMeMfMgSIXqapaziGn6oUozq`(B")
(qdv "fkr"	"$B3J3ZMlMmMnMoS>\[_``8`dqQ(B")
(qdv "fks"	"$BMpMqMsMvP,UO]3_Q_s`%k&oVolsB(B")
(qdv "fkf"	"$BQoSIT?T@dzme(B")
(qdv "fka"	"$BMrMtMuMwQ0U:Z0]4dWeqe|k"k5nN(B")
(qdv "fkq"	"$B@"O9YG[VgDgEoM(B")
(qdv "fkd"	"$BBlBmO-O/O1O2O5O:[-`f`gh>j'lplt(B")
(qdv "fo"	"$BPTWR(B")
(qd "fod"	"$BNd(B")
(qdv "fir"	"$BN+N,Z6a@(B")
(qdv "fid"	"$BL:N+N<N>NBNCNHNINJNLPoQ@QZSJdmdnjllpltmQmRr4(B")
(qdv "fu"	"$B023BEWK{N7N8N9NeNoO$O?Q6R/S:W*[q]-`4`5avbjdze8eFg0gFh-i<iCiZjBoLocqfqk(B")
(qdv "fur"	"$BNONqNrV'[6]+],]._Ma|c*m`mapNr/(B")
(qdv "fus"	"$BNgNmNxNyNzN{N}N~O!O"O#SXXxYcZ;\Bf_gHmSo:rY(B")
(qdv "fuf"	"$BNsNtNuNvQXY`^0(B")
(qdv "fua"	"$B3yNwN|R=T~ZL_2_R(B")
(qdv "fuq"	"$BND`Zr'(B")
(qdv "fud"	"$BNNNaNbNfNgNhNjNkNmNnNpSz]2_:f9fYiYpMryst(B")
(qdv "fP"	"$BK-NcNiNlc9h-nTp1rg(B")
(qdv "fh"	"$B02:mH'IyN:O%O&O'O(O)O*O+O4O7R)S$Y}[E_#_3_I_N`$atb:gbgcgdiCmJmboNoOq!qfrisC(B")
(qdv "fhr"	"$B3Q9w</C+NPO<O=O?[rbqc3m\(B")
(qdv "fhs"	"$BO@^M(B")
(qdv "fhd"	"$BBlBmN5N6O.O6O8S/T;Tb[0\Y`|dFiDp/(B")
(qdv "fhl"	"$B@%MjMkN]O(Q4T^Z']*azb}d]f#fPi2iAkQlO(B")
(qdv "fy"	"$BN;N=N@NANENFNKUlW!Y|["_yegfXhznRoAs>(B")
(qdv "fyd"	"$BN5N6iD(B")
(qdv "fn"	"$B<HN^N_O,O0O3Q$\l`4`5aqdMe_e`j3jzo;o{qp(B")
(qdv "fnl"	"$BN^^%(B")
(qdv "fb"	"$BI5LxN-N.N/N0N1N2N\N]N_N`R-ShT^W!ZX\X^%_H`eaneYe`g{nvo9pEq:(B")
(qdv "fbr"	"$BN&O;R-Y$hz(B")
(qdv "fbs"	"$BNQNXO@PUVFVG\2^MeE(B")
(qdv "fbf"	"$B7*N'N(N*XKdE(B")
(qdv "fbd"	"$BN4VWcc(B")
(qdv "fmr"	"$BO>P>pU(B")
(qdv "fma"	"$BQ[W)XnhR(B")
(qdv "fmd"	"$B0=I)KSN?NGNMVE\AhQi3(B")
(qdv "fl"	"$B3=8qA8C,DsKiMxMyMzM{M|M}M~N!N"N#N$N%NRNoP]P^X&Xm_"`4`5crdaf@h.h=imjBkJl>nZqkr5rEsW(B")
(qdv "fls"	"$BNUNYNZN[RgX'iBm8m9nC(B")
(qdv "fla"	"$BNSNTNVNWaepC(B")
(qdv "flq"	"$B3^N)N3g~(B")
(qdv "ak"	"$BGMGOK`KaKbKcSWU@Vw`uadb{j1j2(B")
(qdv "akr"	"$BGyG|KFKkKlLNUki8(B")
(qdv "aks"	"$B17HTHUHZJZK|K}K~L!L"OQRDRXV]VoW>W?Xp^`_TbVe\h_jGktm*mNo8q=r#(B")
(qdv "akf"	"$BKuKvKwbFcBg}k$p\pi(B")
(qdv "akd"	"$BK4K:K;K>LQLVX1f&f(gjh+hOj<j=nzr3(B")
(qdv "ao"	"$BGMG^G_G`GaGcGdJrK?KdKeKfKgKhL%Ug`pgugvlNn2pJ(B")
(qdv "aor"	"$BG|G~I4L.`Sfwl=lBoyq^sN(B")
(qdv "aod"	"$B0:K(LALTLUQ3]ba0hNsf(B")
(qdv "aur"	"$BQLQQVm]qf2k,(B")
(qdv "aus"	"$BJYL2LHLILJLKLLLMP[QKU_^^b@bTeDsQ(B")
(qdv "auf"	"$BJNLG(B")
(qdv "aud"	"$B;.L=L>L?L@LCLDZy\U^rbTh,j&nIsf(B")
(qd "aP"	"$BjV(B")
(qdv "ah"	"$B18243}G|InJgJhJiJkJlK9K?KAKEKFKHKlL0L6L7LNLOLSLWU(ZV`S`pa(b&bHcjdwfNfnhOkuqxr|(B")
(qdv "ahr"	"$BI$KRKTLZL\Q^[7]teYg|s/(B")
(qdv "ahf"	"$BKWL^]G]s(B")
(qdv "ahd"	"$BL4LXQOTm[$[/](_Bb^ga(B")
(qdv "ay"	"$B1,@&G-I@IAICIDIEJhL/ZbZe^]b?eMg{i8(B")
(qdv "an"	"$B@&I5IoIpIqIsJjJlK4K?KEKGL3L5L6L7L8L9LPU(V`W'XcXlYEZ[\>bHeYhOj]kX(B")
(qdv "anr"	"$BKAKOK|L[`Tfn(B")
(qdv "ans"	"$B2cJ-J8J9JZLHLdLfLgLhPnQfX$XpY_e$(B")
(qdv "anf"	"$BJ*L^(B")
(qdv "al"	"$B3aFfHxHyH}H~JFL#L$LBLoU;VKW9W=_>_Pdve[i/m?sHsSs`(B")
(qdv "als"	"$BIRL1LeV1X>XbZa^#eNf+o\sf(B")
(qdv "alf"	"$BL)L*\ikm(B")
(qdv "qkr"	"$B9}GmGnGoGqGsGtGuGvGwGzG}JmKPKQP8YsYv\w^p`a`yg.p;qPr0rX(B")
(qdv "qks"	"$BH<H>H?H@HBHCHIHJHKHLHRHSHWHXJ1JVJ[YBZ5\Q_/amcme+fvj6k'm*(B")
(qdv "qkf"	"$BH-H.H/H0H1H4KVUVX#Y6Y{^_b"b$cAlmq{r1(B")
(qdv "qkd"	"$BJoJ|J}K'K,K.K5K7K8K<K@KBKCKIR9RMUxVsWEWGZU[D\V^qb|cmg/gVhpiSkno%qwr7(B")
(qdv "qo"	"$BGPGRGSGUGVGXGZG[G\G]GeGfGrKLT/WQX`YA^\_d`jfujj(B")
(qdv "qor"	"$B3|GFGlGoGpGrGuI4PQVg[1`aa)cndjr0(B")
(qdv "qjs"	"$BH(H?HKHMHQHVHYK]ZYZZ\h_/_xc)effLg8j[o@s=(B")
(qdv "qjf"	"$BH2H3H5H6f/(B")
(qdv "qja"	"$BHAHEHFHHHOK^[p^"c{gw(B")
(qdv "qjq"	"$BK!`k(B")
(qdv "qur"	"$BI{I}JHJIJJJKQ|Z&]!`za2i0j~m2mdospH(B")
(qdv "qus"	"$BHPJQJTJUJXJ[MhQ~RFY(Y7ZN]repg&jokfmgn4n5qX(B")
(qdv "quf"	"$BHcJDJLJMP(Z~sh(B")
(qdv "qud"	"$BIBIMISJ:J;J<JAJBL_V"Vu[D\V_[c=cme3m~q6qX(B")
(qdv "qh"	"$BD=F>IVIaIcIhJ]JbJcJdJeJnJsJuTHUoUph^jppfse(B")
(qdv "qhr"	"$BIzI{I|I}I~J!J"J#J$KMKNKPR6Z=Z>\w]M_Ad9h*hyiui}j`m.mUmVqFrX(B")
(qdv "qhs"	"$BK\TqlL(B")
(qdv "qhd"	"$B0)HFIuJpJtJvJwJ{K%K)K*K/K1K@^"_bcsdK(B")
(qdv "qn"	"$B3x4L<C@lG]H]ITIUIVIWIXIYIZI\I^I_I`IbIcIdIeIfIgIiIjIkIlImIoItIzI{I|J#J$JmJsK6P=PZPmP|RuS_T4UUU[Y8YC[T[U[o\T]M^pf)g%gYgxijk>lRlgmUn>n]rjrksOsPse(B")
(qd "qnr"	"$BKL(B")
(qdv "qns"	"$BBNHRH[J,J.J/J0J1J2J3J4J5J6J7K[K_RfW][C]d]p_9`6a'a=cic|gnlL(B")
(qdv "qnf"	"$BITJ&J'J(J)PGWJWgYD[,`Ac1q|sd(B")
(qdv "qnd"	"$BC*J+JxJ~K2TDW:boe^(B")
(qd "qmr"	"$BR6(B")
(qdv "ql"	"$B7%H[H\H]H^H_HaHbHcHeHfHgHjHkHlHnHpHqHsHtHwHzH{H|I!J(JOP#PlR8SgU&U9U{X`[,\R`Aa]acbNbgc0c>dDdcdue#f1fGg#g$g>hKhoitjkl"l@lAlLl]nAp)pBp[pfqorL(B")
(qdv "qls"	"$BIFIKILINIOIPIQLFUMZ/]']R_@eoi@p~r&(B")
(qdv "qld"	"$BI9QRQVQ_U2Xaf[qHqU(B")
(qdv "tk"	"$B278%:3:6:;:=:>:?:@:p;E;G;H;J;K;L;M;N;U;W;[;`;b;d;e;l;r;t;v;w;{<%<-<K<L<M<N<O<P<R<S<U<X<Y?)?ZFcGAL&L,LcP/PXQPRSSNTzU0UmWP[O[h\L]y^/^V_C_S`:`[aBc+c,codAdBdCe/fSfhgRh5iImfnanmqJqKrBr^sM(B")
(qdv "tkr"	"$B:o:s:w?tSVZK\N`#oK(B")
(qdv "tks"	"$B;1;3;5;6;9;:;;;@IGQh[<]haMedlioYo[(B")
(qdv "tkf"	"$B;&;';5hq(B")
(qdv "tka"	"$B;0;2?9?yRTWD^zdsexf.glhujN(B")
(qdv "tkq"	"$B07=BA^Yg]=_'_(p@q%(B")
(qdv "tkd"	"$B7,8~=}=~>&>(>0>2>E>M>X>\>]>^>e>o>uAPASAVA[AjAzA|BlBmErF=FKH"MMRVUCURVyV{XS\k]O`.a3fFjak<ksrh(B")
(qdv "to"	"$B:I<%^/_Sg(lPp{rT(B")
(qdv "tor"	"$B:I:p:w?'T'XG\ecQi,(B")
(qdv "tod"	"$B1y>J@7@8`Ocy(B")
(qd "tid"	"$Bq.(B")
(qdv "tj"	"$B5P:T=k=l=n=o=p=q=r=s=v=x=y=z={?p@3@4@>@@@BAMD)L;P0ScTPTfVYY3ZFZGd.e1fTf]fqsUsk(B")
(qdv "tjr"	"$B3c<.<M<a<b@J@K@N@O@P@YM<^Hb,hnirj.jinYnq(B")
(qdv "tjs"	"$B4T@f@g@h@k@p@q@v@z@{@~A"A#A%A*A-A/A1A5A6A7C1OKQ"SEUIUvX:^/`!a}c8e@fAgUiElqpG(B")
(qdv "tjf"	"$B1L6}7@@^@_@b@c@eC-FQSwYM\8]u^Xe(e2eJi-jxsv(B")
(qdv "tja"	"$BA!A.UQZ{]@]S]Tcxeyezj9k~lXnu(B")
(qdv "tjq"	"$B=&>D@"@]RYSqXRXwYpfcm:oRq#(B")
(qdv "tjd"	"$B>J>k@+@-@.@1@9@;@<@?@CX9Zp`Od-fag)(B")
(qdv "tp"	"$B:P:Y:{@$@*@G@b@vLcWB^/ih(B")
(qdv "th"	"$B037+:i<D=j>$>%>,>.>/><>?>B>C>F>K>P>R>S>dA:AAABAGAIAJALA]A_AcAgA{B}I%R#SbU?XG[`\f][]{^j_O_va4d,dTg[hvi+i?l!lsmvn:n[nyp<ppq[rCrM(B")
(qdv "thr"	"$B0@B+B.B/B0B3V$etkll^(B")
(qdv "ths"	"$B;AB9B;B=C'(B")
(qdv "thf"	"$BN(j+(B")
(qdv "thd"	"$B>>>YAWAwW~[@^DcpgNiOkVo1psr"(B")
(qd "thkf"	"$B:~(B")
(qdv "tho"	"$B:?:U:~;&;/^/_S`tbl(B")
(qdv "thl"	"$B?h?jTj(B")
(qdv "tn"	"$B<i<j<l<m<s<u<w<x<y<z<{<|<}=$=%=(=+=/=2=7=C=I?\?b?c?e?g?k?o?p?q?tA\AiB5C(C/D\JfLyM"N(RWS4SUSVT1ThU?V-X{YSZ@ZK]U]z^,^l^{_|`Yc.cOdXdoe5e7elf7f{g!g;h%h5hki.j-l(l3n.nHnsnxo5p$p+qrr$(B")
(qdv "tnr"	"$B=G=H=I=J=L=M=N=OPhUY`GfihChr(B")
(qdv "tns"	"$B=V=X=Y=[=\=]=^=_=b=c=d=f=gFkWNWv^-d#d$f|h&hsh|kNkYo>s((B")
(qdv "tnf"	"$B=Q=RN(WuX|[2(B")
(qdv "tnd"	"$B?r?shE(B")
(qdv "tnl"	"$BPfPg^C(B")
(qdv "tmf"	"$BI(`niMi|(B")
(qdv "tmq"	"$B<>=&=,=1_<jyp.(B")
(qdv "tmd"	"$B>!>#>5>:>g>h>jANFlGhP+QtR4[Fejj$o~(B")
(qdv "tl"	"$B0;3A:|;&;H;O;S;T;\;k;m;n;x;{;~<(<,<E<F@'DsLpRQSASOS]UyU}W#W6WtYy`JfBg(gShahikkl5l9p{(B")
(qdv "tlr"	"$B6t<0<1>}>~?!?"?#?)?*B)Uf_omHq3(B")
(qdv "tls"	"$B:g?-?.?1?5?7?=?@?B?C?E?H?I?U?V?WC$GjH8RqS"UbXFY;Zo_~iglYpur`(B")
(qdv "tlf"	"$B<:<<<=<BUi\Cj)(B")
(qdv "tla"	"$B;2?3?4?<?D?R?SRTWZ\;]n_)_Dh~o=(B")
(qdv "tlq"	"$B=&=:===BDTRARB_'_(a#cgdb(B")
(qdv "Tkd"	"$BAPRV(B")
(qd "Tl"	"$B;a(B")
(qdv "dk"	"$B0!0"0$2d2e2f2g2j2k2m2n368f;yP3Q;S(U.U4V6[s`Ha^h0jKk(kCn{o<rms!s"(B")
(qdv "dkr"	"$B0!0-0.0/3Y3Z3\DWOLP3RxTAVVVjX(X3\[hUhVh`k`n?s-sys{(B")
(qdv "dks"	"$B0B0D0F0H4_4c4f4g4i8APtZg]Vpzr=rnro(B")
(qdv "dkf"	"$B060D1ZX~Y!]"]1]Fk@mBn!odpK(B")
(qdv "dka"	"$B0C0E0G1^264`4b4dVIV^h?k^pws_sa(B")
(qdv "dkq"	"$B0(052!3{R}TZ`@(B")
(qdv "dkd"	"$B1{6D97Wi]J]vc?pYrs(B")
(qdv "do"	"$B0%0&0'3336373eS1SNS`T<V=[#]7b-bJbYbvc(ghi=oup'pKpOq>(B")
(qdv "dor"	"$B1U3[LkLqY/YUf~mCoup'(B")
(qdv "dod"	"$BSm]/f"rts@(B")
(qdv "di"	"$B<M<P<Y<c<fG8LiLjLkLlLmLnYh\?s,(B")
(qdv "dir"	"$B0s<c<eLsLtLvU>Ynd`h`hji;oPs4s~(B")
(qdv "did"	"$B>\>m>n>w>y>zMHMLMMMNMSM[M\PSTaUPWyZ7ZfZx\k_!_G_laZagaxc:cUjwl*nVqh(B")
(qdv "dj"	"$B1w5y5z5{8f8lS0S}S~^Kq,qGrNsw(B")
(qdv "djr"	"$B2/21225?M^\z(B")
(qdv "djs"	"$B1a8@8AGgI'PpUA_adN(B")
(qdv "djf"	"$B]"]1(B")
(qdv "dja"	"$B1b1f264`4d8387Q7RLSnV^Vx^;f,ofqd(B")
(qd "djq"	"$B6H(B")
(qdv "dp"	"$BWk]P(B")
(qdv "du"	"$BFrG!M=M>M?M@MAMBP.]C^.aBe1gMgPh'i1ikl%q1(B")
(qdv "dur"	"$B0W0h1V1X5U<MKrLrLuXdehinl#o`ogp?qcrH(B")
(qdv "dus"	"$B0v1c1d1h1i1l1m1o1t8&8'<!A3FPFpG3J%RdSkU+U/WzYPYa\=])^'^2^7^=_]d'gCh/icj@l'(B")
(qdv "duf"	"$B0v1Y1\@bG.ReSYsv(B")
(qdv "dua"	"$B1^1j1k1p1v@wL-QG\ygfgroeqyr6rPsEsa(B")
(qdv "duq"	"$B1^MUSq[!pT(B")
(qdv "dud"	"$B1D1E1F1G1I1J1K1M1N1O1P1Q1S7J7^RiS[TJU$U%Zu\3\F^s_J`r`}`~ewj>lWn;pD(B")
(qdv "dP"	"$B0e1C1H1L1T4"7X7];y<IM@MBP)P.PdQ;Q<St[*]u`IbKbOcRfJghi"i#i:iRjcl%l?p?rIsL(B")
(qdv "dh"	"$B0-1(1*1w1x1|2(8^8`8a8b8c8d8g8h8mP~S*SKSSTITTT|U<UhWXX(XeZDZm_4_r_z`3`iiej(n+o2rbsg(B")
(qdv "dhr"	"$B0$206L9vM`(B")
(qdv "dhs"	"$B292:X2aicSi%i>jrr[r\(B")
(qdv "dhf"	"$BQ:\Eg,(B")
(qdv "dhd"	"$B2'MJTYW+a%a1a~c<hcp6s0(B")
(qdv "dhk"	"$B0#122i3?4$7&RwSyc]hbiwkBkw(B")
(qdv "dhks"	"$B08404K4P4X4a4e4hOPOROSU6^1_5iol2op(B")
(qd "dhkf"	"$B[)(B")
(qdv "dhkd"	"$B1}2"2&9DUwWH[>]j(B")
(qdv "dho"	"$B0#3?OARwbdiw(B")
(qdv "dhl"	"$B0Z307(VLV[`Pbvi'r>(B")
(qdv "dy"	"$B1z3Z6F9x>qD8F+LsMEMIMKMRMTMWMXMZQ'TpU-UKULVRVvWTWUY9YjYz\[\v]H_$`"`vcXc_eeh}j4kon-n3qAs8t!t#t$(B")
(qdv "dyr"	"$B?+C+M]M_MaV;^ieUhljs(B")
(qdv "dyd"	"$B23B{M&M/M0MCMFMGMOMPMQMVMYP\XJXY\Wa5f`gNill}o0ps(B")
(qdv "dn"	"$B0r1&1'1)1*1+2$2%5m6h6r6s6v6w6x6y?uKtL`M$M%M'M+M4M9P2P}R^R_VJ\d]?]XaOb3c;c<d~foi9kpsIsz(B")
(qdv "dnr"	"$B000jR(TT_4_z(B")
(qdv "dns"	"$B0w1$1>1?1@Zt]N_pe"fQp(pq(B")
(qdv "dnf"	"$B080S1516]5_q(B")
(qdv "dnd"	"$B7'M:(B")
(qdv "dnjs"	"$B080w1!1`1e1g1n1q1r1s1u3@4j85868;I2QMT$T(U6UcXE^S`)gkiojOkdmWn|ovp((B")
(qdv "dnjf"	"$B1[7nXz[)denh(B")
(qdv "dnl"	"$B010L0N0O0Q0R0S0V0Y0^0_0`0b0c161R4m56OAQ&S@SxT#Vk^O`*a_eOh<ivjLm{pjr2(B")
(qdv "db"	"$B0T0]0d:y<t=@D\FSFjFyF}G(KnL{L|L}L~M!M"M#M(M)M*M-M.M1M2M3M5M6M7MDPRQASHS|U^ViXoYfYiZA\@^a^b`qahdre7g+gLhPi$iXj!j"j@k!k0kglzl|n'nXo+pds[sl(B")
(qdv "dbr"	"$B0i4!FyS|]Zdx(B")
(qdv "dbs"	"$B0t0}1<=aUzlVnJ(B")
(qdv "dbf"	"$Bffrr(B")
(qdv "dbd"	"$B=?M;e0(B")
(qdv "dms"	"$B1#286dRaT-T7X@X[]V`;p,su(B")
(qdv "dmf"	"$B255?(B")
(qdv "dma"	"$B0{0|0~1"2;5?6cR_U5V@];pF(B")
(qdv "dmq"	"$B5cM,M8X%(B")
(qdv "dmd"	"$B1~5?6EBkGhXfg?j$m@mA(B")
(qdv "dml"	"$B0M0U0X0a365#57595<5?5A5B5C5DODPaV=VTVXXt]:_q`Hbcc&ePg_nPq>(B")
(qdv "dl"	"$B0;0J0K0P0W0[0\1B;\<$<)<*<X?)BBBfCPFRFsFvP1U)UuVaW3W4W^^&`ba-aXfggokHlFlHlIm_mnp0(B")
(qdv "dlr"	"$B1WMbMcVXW5[;fDkjs2(B")
(qdv "dls"	"$B0u0v0x0y0z1l?M?N?O?YFRG&G'LbP@PAQ9QcTEUTW.]e^P_]h!h;iNpW(B")
(qdv "dlf"	"$B0l0m0n0oF|P!PETejRn_o-(B")
(qdv "dla"	"$B1A?QDBG$G%L-U,WljSjT(B")
(qdv "dlq"	"$B9~F{F~R]T)rl(B")
(qdv "dld"	"$B>jP;QtUT(B")
(qdv "wk"	"$B040q:4:8:::^:n;F;I;P;Q;R;Z;g;p;q;s;z;|<"<'<+<Q<T@F@QDSI&PwQ}RoR~UZWs^h_Ua*aSbDbEdggsh$hti4i5k9lGlZl`r8s:sn(B")
(qdv "wkr"	"$B:n:r<[<]<^<_<`?]?}SpU"UeZQ[P_Zd+e?ginLs'(B")
(qdv "wks"	"$B;7;DV#X}\"]L_%b7(B")
(qdv "wka"	"$B;=;C@xC9V*_*_+d>dQjDlQo4(B")
(qdv "wkq"	"$B;(AYA^C}SrYgd4p7p8(B")
(qdv "wkd"	"$B>">)>->1>8>@>O>Q>U>_>c>f>l>s>uATAqArAuB!B"D"D%D2D9F5P?TGTVTcTyT}U#UrVQW2\u\~^J^y`-`/`R`xaog6gGgIg`h7hIi,i6jfl[l\o6rc(B")
(qdv "wo"	"$B:F:H:K:M:R:X:[:\:_:`:b<F@FB8^hc7eRexl9lZsn(B")
(qdv "wod"	"$BA9AdAhAyVDVl`'bUd7d8kZo#(B")
(qdv "wj"	"$B093n5O<Q=m=s=t={=|A;A@CtCuCvCwCxCyDcDlDqE!EKGgH$LYPJRrW7Y3[A[R\:]|_L`2aTbicle*f8fTgsiWk:kIl7m0p3sr(B")
(qdv "wjr"	"$B2.<Z<d@Q@R@S@V@W@XB1C`CdD$D_E&E(E)E*E+E,E-LvR*W/_U`?a{c!d{gii4k6mlmqmx(B")
(qdv "wjs"	"$B<2=W@o@r@s@y@}A'A,A0A4B7C.DQE5E6E8E;E>E?EAEBECEDEEG{H*KjMdQ#QrR4RdSsT{UsV\W%X"X}Y%ZBZS]a^!_E`0a/aYaub!c"d%d5d?euf?fHg"lcm7mYm[nonto"oCp4pSp|q4qBs6s7t"(B")
(qdv "wjf"	"$B=`@Z@[@^@`@a@dCbLERERGRzY#ZqZr^6cffOlkmE(B")
(qdv "wja"	"$B0>@jA2E9E@FQG4V3dRpAsVsZ(B")
(qdv "wjq"	"$B@\D3XR\&\7\D]~^XfcrW(B")
(qdv "wjd"	"$B0f;*>=>Z>`>p>t>{@,@/@0@5@:@EBGCzD.D:DbDdDeDgDhDjDmDnDrDuDvDwDxDzD{E"E#E$FTKoLwMdP'RZVlY]ZW[l^F^[a6aKbMcWf^hGj:mwn&nDnKoFp=pP(B")
(qdv "wp"	"$B1-:O:Q:W:]:^=t=|@)@=@F@^BhBiBjDiDkDoDpDsDtD}P_Q1Q}Z+Zq_;bDbEbIgAi5lZm3pIpmpnsn(B")
(qdv "wh"	"$B3v7+:x;4<D=u><>H>[>rA;A<ADAEAFAHAKA`AaAbAeAfAgAlAtAxB$BdC{C|D$D&D+D,D/D4D7D8D;DUD^D_D`FXGBH%POPYS^SdWIXNXTXjY2Y4Zj[j[t\'\*_6`,bic/cGcZc^cud|e6f-fTfrg]iskGkPl!ldm/oXp:qt(B")
(qdv "whr"	"$BB-B2dHhwo7(B")
(qdv "whs"	"$BB:YO(B")
(qdv "whf"	"$B@[B4OHR@`L(B")
(qdv "whd"	"$B<o<p=!=*=>=D>a>bAnI"P:WOXQ\#\$\b^JdpeTj*l{m'm)oG(B")
(qdv "whk"	"$B:4:8:A:B:C(B")
(qd "whl"	"$B:a(B")
(qd "wy"	"$Bn[(B")
(qdv "wn"	"$B3t:n<g<k<n<r<v<~=#='=.=5=;=K?_AUAvB-B2ChCkClCmCpCqCrCsD4D]I*L+P&PMPvQ2QISUW$ZlaFaGcGdVdZe!eBfthwiakOlam4mTn$oIsG(B")
(qdv "wnr"	"$B4!C]dx(B")
(qdv "wns"	"$B1==S=T=W=Y=`=c=eFVH;KpQ.RETSWvX"X6^4_=b/jAm-mu(B")
(qdv "wnd"	"$B=0=ECfCg(B")
(qdv "wmr"	"$BB(B1(B")
(qd "wmf"	"$B6{(B")
(qd "wma"	"$BWc(B")
(qdv "wmq"	"$B=4=AIxM,\7eI(B")
(qdv "wmd"	"$B3(9y>I>Z>xA9A=A>A}A~B#D'YN\t__kz(B")
(qdv "wl"	"$B4t5@;V;X;Y;];^;_;c;f;h;i;j;o;}<1<A<G?%B~CNCOCRCSCXCYDRDlDqEVG7S!T.TMVcW7Yu[L]ma\c-fMfsgSk:lDlSlflym5mIn/owr?s9(B")
(qdv "wlr"	"$B?%?&D>SDcFcM(B")
(qdv "wls"	"$B?0?6?8?:?>???A?G?J?L?P?T?XC$DADCDDDEE6FxKyPVSQZi]I_~`_a+a;b8bCbSeVgKhmjWlcmGo/(B")
(qdv "wlf"	"$B<8<;<@<ACaCbE3IHLEPERzSDT9Ve[_fOg4g5lDlkmE(B")
(qdv "wla"	"$BD?ZPnErq(B")
(qdv "wlq"	"$B<9=4=8=AeI(B")
(qdv "wld"	"$B@!D'D(_-(B")
(qdv "ck"	"$B3n:!:5:7:9:<<V<W<ZOMPNSMV+VMY-Ym[3\Lbxd4gsm"n`(B")
(qdv "ckr"	"$B:q:u:x@NB*ByCeCxY'eSm0oXsqsx(B")
(qdv "cks"	"$B;8;<;>;?;A@qRUZ9`&cbdlesl-lUo4oSoTqB(B")
(qdv "ckf"	"$B;!;";$;%QkY)`\e'(B")
(qdv "cka"	"$B;2;4;BA2Q(Q)RTTOVPVZXNXOXPXrXs\ackk{k|l)l+q](B")
(qdv "ckd"	"$B>'>+>3>4>;>T?zAOARAdAkAsD*D1H+PiQlRRX0XHYoZHZd^E^k^}`KalcYgZm#r.(B")
(qdv "co"	"$B:9:D:L:N:S:V:W:Z<F@UMi\Me=hql8n`pV(B")
(qdv "cor"	"$B:p:t:u:v:}@UA<QFSTY>[Pbyd)dG(B")
(qdv "cj"	"$B:J=h@(A@Q]X.^Ge1hF(B")
(qdv "cjr"	"$B;I<\@I@L@M@TD=QqRhWFZ3^~akinljm$m(m6p"s5(B")
(qdv "cjs"	"$B0+6N6z6|;=@i@n@q@t@u@|A$A&A(A)A+C)E7PBPjQdSCV_Z#[a\9^I^Y_Ea$chh(lMlxoqotph(B")
(qdv "cjf"	"$BDVE/E0E1E2E4FLFmS5V%YZmPnno$oDoEq8(B")
(qdv "cja"	"$B84@mE:E<Q!W[Ww\a\y]~b]dSdUd^d_j9k-k[k~(B")
(qdv "cjq"	"$B>*>9>vC}D!D-D5E=aHaIaJbLjymLmM(B")
(qdv "cjd"	"$B;*;,@2@6@A@DD#D0W,W-fehGiq(B")
(qdv "cp"	"$B@ZBNBXBZBaDVDfDyD|D~FeFmSFSiSjYZ\<^8^|bIbfh\hxjim<m=n*pLqsqv(B")
(qdv "ch"	"$B7-=i>%>6>7>A>G>K>L>S>V>d?]A?ACApD6D8ICQvR#R+V%V9X!X7X^[B\%^W_VcDggkWl:mknLndqzs<ss(B")
(qdv "chr"	"$B<q>|?$?(?tB%B0SvV$ZKb`badHifk=m1o7qq(B")
(qdv "chs"	"$B1%@#B<WVn7(B")
(qdv "chd"	"$B=>=FAQAZAmAoC~DMF4G,N5N6P:PxR2WOWdX;eAeTfb(B")
(qdv "chl"	"$B:E:GVCYt\c^/(B")
(qdv "cn"	"$B0,1/3b<h<q="=%=)=-=6=9=P?[?d?m?n?u?v?wAFC\CjDFDGDHDIDJGkOISBU7U9VdX/YXYY\6\d^Wa,b2cTd6dHeWf\gmhZn@p%p2pcqWqerUsF(B")
(qdv "cnr"	"$B1/<3<4=3=K=LC[C\C^C_C`M.\egXm&(B")
(qdv "cns"	"$B=UDXrV(B")
(qdv "cnf"	"$B=P[2sY(B")
(qdv "cnd"	"$B2-=<=F>WCiCnCoMCQU`>g^j5(B")
(qdv "cnp"	"$BX,X-X8aahDlT(B")
(qdv "cnl"	"$B<h<q="=-?a?f?i?l@HOIS\U8X8Ye\r]^aafCf\g9hDk9nMqe(B")
(qdv "cmr"	"$BB&B'B,D=P<X<Z`(B")
(qd "cms"	"$Bsp(B")
(qd "cma"	"$Boo(B")
(qdv "cmd"	"$BA=A>AX(B")
(qdv "cl"	"$B:7:9;u<#<&>}?"?%CMCQCTCUCVCWCZD'D>FePLRHRNSPTiV5VbVpVz[i_ua7a?awbtcPcze#e>eLfWiPjul8lemOo!p5r5rKrvrwscso(B")
(qdv "clr"	"$BB'B,D<R,RNVzX<ZE(B")
(qdv "cls"	"$B?Fk%sp(B")
(qdv "clf"	"$B<7<?(B")
(qdv "cla"	"$B5N?/?2?;?KC9D@KmUjWZZP\;o*o,ooqT(B")
(qd "clq"	"$Bj/(B")
(qdv "cld"	"$B>NGicJjYqU(B")
(qdv "cho"	"$B2wTo`V(B")
(qdv "xk"	"$B<XB>BBBCBDBEBFBGBHBIBJBKBLBMCSOMPIS#TXU`YYYe[4\s]}g!m>qLrx(B")
(qdv "xkr"	"$BBnBoBqBsBtBuBvBwBxByE'EYPkS6Y>[Q_7ner0(B")
(qdv "xks"	"$BBMC2C3C7C:C>CBCFF]FgW<X_Z:]QjX(B")
(qdv "xkf"	"$BC%C&(B")
(qdv "xka"	"$BC5C?b>lE(B")
(qdv "xkq"	"$BEcEkYr\PpaperW(B")
(qdv "xkd"	"$BEfErE|F"Vfb;j#(B")
(qdv "xo"	"$B@GB@BABUBVBYB[B]BaBfBgG=KXLaQ<\(cze)ihkHq&qM(B")
(qdv "xor"	"$BBpBrBtZ$_7(B")
(qdv "xh"	"$BEFEGEQEZEeF$Q=h9(B")
(qd "xhs"	"$Bjt(B")
(qdv "xhd"	"$B23DKDLE{E}HuWxXV(B")
(qdv "xhl"	"$B?dBOB\B`DHDIDJFXjtpx(B")
(qdv "xn"	"$BEJEjF)F.L{Pye5o+qmr,(B")
(qdv "xmr"	"$BB_FCXW(B")
(qdv "vk"	"$B?|GCGDGEGGGHGIGJGKGLGNHmHvT3WfZ4[1`(``bncvfRg8hJh]jZllox(B")
(qdv "vks"	"$B:d:eH=HDHGHNR!]ra"ng(B")
(qdv "vkf"	"$B;+H,R\[5n\(B")
(qdv "vo"	"$B143-GIGTGWGXG\GbH4HmI#PPUVX#Y6ZT[1]o`cp>(B")
(qdv "vod"	"$BC*K#K5KDW:WEZU_0b|e^(B")
(qd "vir"	"$BX?(B")
(qdv "vus"	"$BJ?JPJRJSJTJWJXJ\Y(fIgyi~jokfqY(B")
(qd "vua"	"$BlJ(B")
(qdv "vud"	"$BDZI>IMJ?Wh^$bogyhLr9(B")
(qdv "vP"	"$B3AGQGYJ>J@JCJDJEKJUJVrW&ZIZMasi0qo(B")
(qdv "vh"	"$B1:3s3wGxGzI[I]IrJ^J_J`JaJqJyJzK"K$K&K+K0K=R1R5R7RvS.T5YF[T_F_\aWb.f}gTgzj\jqmynppRq0q}r:rDsR(B")
(qdv "vhr"	"$BGxGzI}K=_F(B")
(qdv "vy"	"$B<]I6I7I8I:I;I<I=I?QwUEXX]Ke]q(q)q*q_qjqurd(B")
(qd "vns"	"$BJ,(B")
(qdv "vna"	"$BIJcHcI(B")
(qdv "vnd"	"$BIvIwK-afkel4q$qH(B")
(qd "vb"	"$BI7(B")
(qdv "vl"	"$BH`HdHhHiHmHoHrllmdox(B")
(qdv "vlf"	"$B2^HfHgI$I%I+I,I-I.J'J)PGYDdJkvm+s+(B")
(qdv "vlq"	"$BI/I}K3^"(B")
(qdv "gk"	"$B2<2?2F2O2Y2\2b2l3E<6ROR`V|^Q`leKf!kEl.n"o(rQ(B")
(qdv "gkr"	"$B2)3X5TDaT[U\U]^A`Bajkbl;s?(B")
(qdv "gks"	"$B4(4@4A4M4W4Z8B:(UFUGW{Y*YRZ][e_K`Cb*f'n8qSqlsm(B")
(qdv "gkf"	"$B323d3e3mR$bRiys\(B")
(qdv "gka"	"$B4O4Y4^H!MtQbRyS2S?VH]#^>eHh1n8nro|pwq2rRsD(B")
(qdv "gkq"	"$B389^9gH:RnR}^eb4b5b6hdonr{(B")
(qdv "gkd"	"$B7e9+91939:9A9R9T9_9`FzP6PDRbWqe}fjobprr*(B")
(qdv "go"	"$B0g2r3#3$3*3/31323:3<:zPsT6TnTxUXW(Xh\4i&j7k;k_n0nOqO(B")
(qdv "gor"	"$B3/3Kbkk*mJ(B")
(qdv "god"	"$B0I8v9,9Te.jbr}(B")
(qdv "gid"	"$B5}6?6A6B8~9aSlq.(B")
(qdv "gj"	"$B135u5vTR[[]A^w(B")
(qdv "gjs"	"$B7{8%8.YW`[(B")
(qdv "gjf"	"$B]<iyj8(B")
(qdv "gja"	"$B8183VUp*qd(B")
(qdv "gur"	"$B3E3R3W7CTu^)r+(B")
(qdv "gus"	"$B0<7|8)8+8-82898<8=8>8?9`JGPWRl^-aRbAeQidjJnkp}(B")
(qdv "guf"	"$B7j7l>iJGLRUSk#pv(B")
(qd "gua"	"$B7y(B")
(qdv "guq"	"$B0A3p6"6(6.64696<KKOFTsV7XDYQ^5`Ed)d:h2nwo}p!(B")
(qdv "gud"	"$B3>5|7:7;7?7A7U7V7e9UTk_W_X`rfzj%mj(B")
(qdv "gP"	"$B7E7RQBR>TxWBX*b=c4l~nQp^(B")
(qdv "gh"	"$B3O8C8F8L8M8P8Q8R8U8W8[8_8c8j8n8o9%9@9f9h9j9k:c;)<JD[QTTdW`Y&Z_Zn\5]]]l^v^w`7`ha!b(b+hYhfiHiKizn=o.q7(B")
(qdv "ghr"	"$B0?9s9tOGUeZO(B")
(qdv "ghs"	"$B:':*:+:.:2[~\!^U^g_c`m(B")
(qdv "ghf"	"$B3K9z9{]Gcts3(B")
(qd "ghq"	"$B3f(B")
(qdv "ghd"	"$B909?9H9cR|]g]wkAobr*(B")
(qdv "ghk"	"$B2=2P2R2S2V2Z2_2h3q3r7$CtOBOCS;V<aAdqo&(B")
(qdv "ghkr"	"$B3H3M3N3OZ2Z<ayb_j?p9(B")
(qdv "ghks"	"$B4-45494<4?4D4T4]88OKT(TvUaUnXu]D^R^S_eb*bAbbl,l6oBqir%r](B")
(qdv "ghkf"	"$B1[3h3j;#`Qbwi]l/ohoi(B")
(qdv "ghkd"	"$B2+677;92989D9SKZQWQ`WSWrX5Zh^T^f_jd;dPfki{n#p&rS(B")
(qdv "gho"	"$B2h7S`VaA(B")
(qdv "ghl"	"$B2q2s2u2v2y2z2{3"3%=ZI0OEPrQER;TUWKXg[X\G^Neig:h"i'i\kKkRmorf(B")
(qdv "ghlr"	"$B2h3D3MaA(B")
(qdv "ghld"	"$B2#909U9li*mDo)sT(B")
(qdv "gy"	"$B6G8s8z9;9Z:hP{S,SeSoZCZ|[f^B_^`+qaqb(B")
(qdv "gn"	"$B0r5`8e8t8u8|9!9"PHRcSLSR^A_h`Md<kMmp(B")
(qdv "gns"	"$B7.7071FkR._m_nhXnU(B")
(qd "gnd"	"$Bi*(B")
(qdv "gnjs"	"$B3~7vCHX:Zwh@kcl,(B")
(qdv "gnp"	"$BCnRCS<TL_{(B")
(qdv "gnl"	"$B4x5+51WCY&Zv]`ka(B")
(qdv "gb"	"$B5Y7H7MC\Z8_^iLl<(B")
(qd "gbr"	"$BC\(B")
(qdv "gbf"	"$BWukys;(B")
(qdv "gbd"	"$B6$6'6;R3Wo^((B")
(qdv "gmr"	"$B9un^(B")
(qdv "gms"	"$B6U:/WLWWYWnW(B")
(qdv "gmf"	"$B5%5IKxV(k?(B")
(qdv "gma"	"$B6V7g(B")
(qdv "gmq"	"$B5[]@^*b%fE(B")
(qdv "gmd"	"$B6=Fz(B")
(qdv "gml"	"$B4n4r4u5)5:5>I1Q%RzS)S`XAXZY&Zk[']8_f_g_t`!`:c6f<nZrF(B")
(qdv "glf"	"$B5Merk#pvs\(B")
(qdv "unknown"	"$B4#<5DNFJFdFuJ=KsL]QeRIRpS&S9SuS{T*T+T8T:T>TBTCTKTNTQTWT\T_UNU~V&V,V-V.V/V0V2V4V8VNW;WjWnWpY0YKY^Z1Zs[=[b[n\)\-\.\/\0\1\O\S\j\n\o\p\q\x]&]6]B]i^<^L^c_&_1`<a:a<a>b<bBbXbmbpbsc%c5cNcdc}d&d1d=dIdLdYdddfdhdte9eaebemenevf$g3g\h4h6hHhMhWhhiFi[ibj,jQj^jmk\lCmZmhmimzn%n}o'oZo]p#p-pXp]p`q;qIqRr;r@rGrOrZr_rer~s#s%(B")

(quail-setup-current-package)
