/************************************************************************/
/*									*/
/*  Data structures that describe postscript fonts.			*/
/*									*/
/************************************************************************/

#   ifndef	PS_FONT_H
#   define	PS_FONT_H

#   include	<docFont.h>

typedef struct AfmKerningPair
    {
    int		akpPosition;
    int		akpXVec;
    } AfmKerningPair;

typedef struct AfmBBox
    {
    int		abbLeft;
    int		abbBottom;
    int		abbRight;
    int		abbTop;
    } AfmBBox;

typedef struct AfmCharMetric
    {
    int			acmC;
    int			acmWX;
    AfmBBox		acmBBox;
    char *		acmN;
    AfmKerningPair *	acmKernPairs;
    int			acmKernPairCount;
    } AfmCharMetric;

typedef struct AfmFontInfo
    {
    char *		afiFontName;
    char *		afiFullName;
    char *		afiFamilyName;
    char *		afiWeight;
    double		afiItalicAngle;
    double		afiTanItalicAngle;
    unsigned char	afiIsFixedPitch;
    AfmBBox		afiFontBBox;
    double		afiUnderlinePosition;
    double		afiUnderlineThickness;
    char *		afiEncodingScheme;
    int			afiCapHeight;
    int			afiXHeight;
    int			afiAscender;
    int			afiDescender;
    char *		afiCharacterSet;

    int			afiMetricCount;
    AfmCharMetric *	afiMetrics;

    int			afiMapToIso;
    int			afiEncoding;
    int			afiEncodingVector[256];
    } AfmFontInfo;

/************************************************************************/
/*									*/
/*  Know about the character set of a font.				*/
/*									*/
/************************************************************************/

#   define	ENCODINGpsFONTSPECIFIC		0
#   define	ENCODINGpsISO_8859_1		1
#   define	ENCODINGpsISO_8859_2		2
#   define	ENCODINGpsADOBE_SYMBOL		3
#   define	ENCODINGpsADOBE_CYRILLIC	4

/************************************************************************/
/*									*/
/*  Used to map between font attributes and the actual font used when	*/
/*  printing.								*/
/*									*/
/************************************************************************/

typedef struct PostScriptFont
    {
    AfmFontInfo *	psfAfi;
    TextAttribute	psfAttributes;
    char		psfFontId[25];
    } PostScriptFont;

/************************************************************************/
/*									*/
/*  Permissible aliasses for glyph names.				*/
/*									*/
/************************************************************************/

typedef struct AlternateGlyphName
    {
    const char *	agnStandardName;
    const char *	agnAlternateName;
    } AlternateGlyphName;

/************************************************************************/
/*									*/
/*  Declarations.							*/
/*									*/
/************************************************************************/

extern const char *		psIsoLatin1GlyphNames[256];
extern const char *		psIsoLatin2GlyphNames[256];
extern const char *		psSymbolGlyphNames[256];
extern const char *		psCyrillicGlyphNames[256];

extern const unsigned char	docWIN1250_to_ISO2[256];
extern const unsigned char	docISO2_to_WIN1250[256];

extern const AlternateGlyphName	PS_AlternateNames[];

extern int psCalculateStringExtents(	AfmBBox *		abb,
					const unsigned char *	s,
					int			len,
					int			twipsSize,
					int			withKerning,
					const AfmFontInfo *	afi );

extern int psFontCatalog(	const char *		afmDirectory,
				AppFontFamily **	pFamilies,
				int *			pCount );


#   endif
