/************************************************************************/
/*									*/
/*  Font Encodings							*/
/*									*/
/************************************************************************/

#   include	"config.h"

#   include	"psFont.h"
#   include	<charnames.h>

/************************************************************************/
/*									*/
/*  Indirection for variable names.					*/
/*									*/
/************************************************************************/

static const char GLYPH_A[]=			"A";
static const char GLYPH_AE[]=			"AE";
static const char GLYPH_Aacute[]=		"Aacute";
static const char GLYPH_Abreve[]=		"Abreve";
static const char GLYPH_Acircumflex[]=		"Acircumflex";
static const char GLYPH_Adiaeresis[]=		"Adiaeresis";
static const char GLYPH_Adieresis[]=		"Adieresis";
static const char GLYPH_Agrave[]=		"Agrave";
static const char GLYPH_Alpha[]=		"Alpha";
static const char GLYPH_Aogonek[]=		"Aogonek";
static const char GLYPH_Aring[]=		"Aring";
static const char GLYPH_Atilde[]=		"Atilde";
static const char GLYPH_B[]=			"B";
static const char GLYPH_Beta[]=			"Beta";
static const char GLYPH_C[]=			"C";
static const char GLYPH_Cacute[]=		"Cacute";
static const char GLYPH_Ccaron[]=		"Ccaron";
static const char GLYPH_Ccedilla[]=		"Ccedilla";
static const char GLYPH_Chi[]=			"Chi";
static const char GLYPH_D[]=			"D";
static const char GLYPH_Dcaron[]=		"Dcaron";
static const char GLYPH_Dcroat[]=		"Dcroat";
static const char GLYPH_Delta[]=		"Delta";
static const char GLYPH_Dstroke[]=		"Dstroke";
static const char GLYPH_E[]=			"E";
static const char GLYPH_Eacute[]=		"Eacute";
static const char GLYPH_Ecaron[]=		"Ecaron";
static const char GLYPH_Ecircumflex[]=		"Ecircumflex";
static const char GLYPH_Ediaeresis[]=		"Ediaeresis";
static const char GLYPH_Edieresis[]=		"Edieresis";
static const char GLYPH_Egrave[]=		"Egrave";
static const char GLYPH_Eogonek[]=		"Eogonek";
static const char GLYPH_Epsilon[]=		"Epsilon";
static const char GLYPH_Eta[]=			"Eta";
static const char GLYPH_Eth[]=			"Eth";
static const char GLYPH_F[]=			"F";
static const char GLYPH_G[]=			"G";
static const char GLYPH_Gamma[]=		"Gamma";
static const char GLYPH_H[]=			"H";
static const char GLYPH_I[]=			"I";
static const char GLYPH_Iacute[]=		"Iacute";
static const char GLYPH_Icircumflex[]=		"Icircumflex";
static const char GLYPH_Idiaeresis[]=		"Idiaeresis";
static const char GLYPH_Idieresis[]=		"Idieresis";
static const char GLYPH_Ifraktur[]=		"Ifraktur";
static const char GLYPH_Igrave[]=		"Igrave";
static const char GLYPH_Iota[]=			"Iota";
static const char GLYPH_J[]=			"J";
static const char GLYPH_K[]=			"K";
static const char GLYPH_Kappa[]=		"Kappa";
static const char GLYPH_L[]=			"L";
static const char GLYPH_Lacute[]=		"Lacute";
static const char GLYPH_Lambda[]=		"Lambda";
static const char GLYPH_Lcaron[]=		"Lcaron";
static const char GLYPH_Lslash[]=		"Lslash";
static const char GLYPH_Lstroke[]=		"Lstroke";
static const char GLYPH_M[]=			"M";
static const char GLYPH_Mu[]=			"Mu";
static const char GLYPH_N[]=			"N";
static const char GLYPH_Nacute[]=		"Nacute";
static const char GLYPH_Ncaron[]=		"Ncaron";
static const char GLYPH_Ntilde[]=		"Ntilde";
static const char GLYPH_Nu[]=			"Nu";
static const char GLYPH_O[]=			"O";
static const char GLYPH_Oacute[]=		"Oacute";
static const char GLYPH_Ocircumflex[]=		"Ocircumflex";
static const char GLYPH_Odiaeresis[]=		"Odiaeresis";
static const char GLYPH_Odieresis[]=		"Odieresis";
static const char GLYPH_Odoubleacute[]=		"Odoubleacute";
static const char GLYPH_OE[]=			"OE";
static const char GLYPH_Ograve[]=		"Ograve";
static const char GLYPH_Ohungarumlaut[]=	"Ohungarumlaut";
static const char GLYPH_Omega[]=		"Omega";
static const char GLYPH_Omicron[]=		"Omicron";
static const char GLYPH_Oslash[]=		"Oslash";
static const char GLYPH_Otilde[]=		"Otilde";
static const char GLYPH_P[]=			"P";
static const char GLYPH_Phi[]=			"Phi";
static const char GLYPH_Pi[]=			"Pi";
static const char GLYPH_Psi[]=			"Psi";
static const char GLYPH_Q[]=			"Q";
static const char GLYPH_R[]=			"R";
static const char GLYPH_Racute[]=		"Racute";
static const char GLYPH_Rcaron[]=		"Rcaron";
static const char GLYPH_Rfraktur[]=		"Rfraktur";
static const char GLYPH_Rho[]=			"Rho";
static const char GLYPH_S[]=			"S";
static const char GLYPH_Sacute[]=		"Sacute";
static const char GLYPH_Scaron[]=		"Scaron";
static const char GLYPH_Scedilla[]=		"Scedilla";
static const char GLYPH_Sigma[]=		"Sigma";
static const char GLYPH_T[]=			"T";
static const char GLYPH_Tau[]=			"Tau";
static const char GLYPH_Tcaron[]=		"Tcaron";
static const char GLYPH_Tcedilla[]=		"Tcedilla";
static const char GLYPH_Tcommaaccent[]=		"Tcommaaccent";
static const char GLYPH_Theta[]=		"Theta";
static const char GLYPH_Thorn[]=		"Thorn";
static const char GLYPH_U[]=			"U";
static const char GLYPH_Uacute[]=		"Uacute";
static const char GLYPH_Ucircumflex[]=		"Ucircumflex";
static const char GLYPH_Udiaeresis[]=		"Udiaeresis";
static const char GLYPH_Udoubleacute[]=		"Udoubleacute";
static const char GLYPH_Udieresis[]=		"Udieresis";
static const char GLYPH_Ugrave[]=		"Ugrave";
static const char GLYPH_Uhungarumlaut[]=	"Uhungarumlaut";
static const char GLYPH_Upsilon[]=		"Upsilon";
static const char GLYPH_Upsilon1[]=		"Upsilon1";
static const char GLYPH_Uring[]=		"Uring";
static const char GLYPH_V[]=			"V";
static const char GLYPH_W[]=			"W";
static const char GLYPH_X[]=			"X";
static const char GLYPH_Xi[]=			"Xi";
static const char GLYPH_Y[]=			"Y";
static const char GLYPH_Yacute[]=		"Yacute";
static const char GLYPH_Z[]=			"Z";
static const char GLYPH_Zabovedot[]=		"Zabovedot";
static const char GLYPH_Zacute[]=		"Zacute";
static const char GLYPH_Zcaron[]=		"Zcaron";
static const char GLYPH_Zdotaccent[]=		"Zdotaccent";
static const char GLYPH_Zeta[]=			"Zeta";
static const char GLYPH_a[]=			"a";
static const char GLYPH_aacute[]=		"aacute";
static const char GLYPH_abovedot[]=		"abovedot";
static const char GLYPH_abreve[]=		"abreve";
static const char GLYPH_acircumflex[]=		"acircumflex";
static const char GLYPH_acute[]=		"acute";
static const char GLYPH_adiaeresis[]=		"adiaeresis";
static const char GLYPH_adieresis[]=		"adieresis";
static const char GLYPH_ae[]=			"ae";
static const char GLYPH_agrave[]=		"agrave";
static const char GLYPH_aleph[]=		"aleph";
static const char GLYPH_alpha[]=		"alpha";
static const char GLYPH_ampersand[]=		"ampersand";
static const char GLYPH_angle[]=		"angle";
static const char GLYPH_angleleft[]=		"angleleft";
static const char GLYPH_angleright[]=		"angleright";
static const char GLYPH_aogonek[]=		"aogonek";
static const char GLYPH_apostrophe[]=		"apostrophe";
static const char GLYPH_approxequal[]=		"approxequal";
static const char GLYPH_aring[]=		"aring";
static const char GLYPH_arrowboth[]=		"arrowboth";
static const char GLYPH_arrowdblboth[]=		"arrowdblboth";
static const char GLYPH_arrowdbldown[]=		"arrowdbldown";
static const char GLYPH_arrowdblleft[]=		"arrowdblleft";
static const char GLYPH_arrowdblright[]=	"arrowdblright";
static const char GLYPH_arrowdblup[]=		"arrowdblup";
static const char GLYPH_arrowdown[]=		"arrowdown";
static const char GLYPH_arrowhorizex[]=		"arrowhorizex";
static const char GLYPH_arrowleft[]=		"arrowleft";
static const char GLYPH_arrowright[]=		"arrowright";
static const char GLYPH_arrowup[]=		"arrowup";
static const char GLYPH_arrowvertex[]=		"arrowvertex";
static const char GLYPH_asciicircum[]=		"asciicircum";
static const char GLYPH_asciitilde[]=		"asciitilde";
static const char GLYPH_asterisk[]=		"asterisk";
static const char GLYPH_asteriskmath[]=		"asteriskmath";
static const char GLYPH_at[]=			"at";
static const char GLYPH_atilde[]=		"atilde";
static const char GLYPH_b[]=			"b";
static const char GLYPH_backslash[]=		"backslash";
static const char GLYPH_bar[]=			"bar";
static const char GLYPH_beta[]=			"beta";
static const char GLYPH_braceex[]=		"braceex";
static const char GLYPH_braceleft[]=		"braceleft";
static const char GLYPH_braceleftbt[]=		"braceleftbt";
static const char GLYPH_braceleftmid[]=		"braceleftmid";
static const char GLYPH_bracelefttp[]=		"bracelefttp";
static const char GLYPH_braceright[]=		"braceright";
static const char GLYPH_bracerightbt[]=		"bracerightbt";
static const char GLYPH_bracerightmid[]=	"bracerightmid";
static const char GLYPH_bracerighttp[]=		"bracerighttp";
static const char GLYPH_bracketleft[]=		"bracketleft";
static const char GLYPH_bracketleftbt[]=	"bracketleftbt";
static const char GLYPH_bracketleftex[]=	"bracketleftex";
static const char GLYPH_bracketlefttp[]=	"bracketlefttp";
static const char GLYPH_bracketright[]=		"bracketright";
static const char GLYPH_bracketrightbt[]=	"bracketrightbt";
static const char GLYPH_bracketrightex[]=	"bracketrightex";
static const char GLYPH_bracketrighttp[]=	"bracketrighttp";
static const char GLYPH_breve[]=		"breve";
static const char GLYPH_brokenbar[]=		"brokenbar";
static const char GLYPH_bullet[]=		"bullet";
static const char GLYPH_c[]=			"c";
static const char GLYPH_cacute[]=		"cacute";
static const char GLYPH_caron[]=		"caron";
static const char GLYPH_carriagereturn[]=	"carriagereturn";
static const char GLYPH_ccaron[]=		"ccaron";
static const char GLYPH_ccedilla[]=		"ccedilla";
static const char GLYPH_cedilla[]=		"cedilla";
static const char GLYPH_cent[]=			"cent";
static const char GLYPH_chi[]=			"chi";
static const char GLYPH_circlemultiply[]=	"circlemultiply";
static const char GLYPH_circleplus[]=		"circleplus";
static const char GLYPH_circumflex[]=		"circumflex";
static const char GLYPH_club[]=			"club";
static const char GLYPH_colon[]=		"colon";
static const char GLYPH_comma[]=		"comma";
static const char GLYPH_congruent[]=		"congruent";
static const char GLYPH_copyright[]=		"copyright";
static const char GLYPH_copyrightsans[]=	"copyrightsans";
static const char GLYPH_copyrightserif[]=	"copyrightserif";
static const char GLYPH_currency[]=		"currency";
static const char GLYPH_d[]=			"d";
static const char GLYPH_dagger[]=		"dagger";
static const char GLYPH_daggerdbl[]=		"daggerdbl";
static const char GLYPH_dcaron[]=		"dcaron";
static const char GLYPH_dcroat[]=		"dcroat";
static const char GLYPH_dstroke[]=		"dstroke";
static const char GLYPH_degree[]=		"degree";
static const char GLYPH_delta[]=		"delta";
static const char GLYPH_diamond[]=		"diamond";
static const char GLYPH_diaeresis[]=		"diaeresis";
static const char GLYPH_dieresis[]=		"dieresis";
static const char GLYPH_divide[]=		"divide";
static const char GLYPH_division[]=		"division";
static const char GLYPH_dollar[]=		"dollar";
static const char GLYPH_dotaccent[]=		"dotaccent";
static const char GLYPH_dotlessi[]=		"dotlessi";
static const char GLYPH_dotmath[]=		"dotmath";
static const char GLYPH_doubleacute[]=		"doubleacute";
static const char GLYPH_e[]=			"e";
static const char GLYPH_eacute[]=		"eacute";
static const char GLYPH_ecaron[]=		"ecaron";
static const char GLYPH_ecircumflex[]=		"ecircumflex";
static const char GLYPH_ediaeresis[]=		"ediaeresis";
static const char GLYPH_edieresis[]=		"edieresis";
static const char GLYPH_egrave[]=		"egrave";
static const char GLYPH_eight[]=		"eight";
static const char GLYPH_element[]=		"element";
static const char GLYPH_ellipsis[]=		"ellipsis";
static const char GLYPH_emdash[]=		"emdash";
static const char GLYPH_emptyset[]=		"emptyset";
static const char GLYPH_endash[]=		"endash";
static const char GLYPH_eogonek[]=		"eogonek";
static const char GLYPH_epsilon[]=		"epsilon";
static const char GLYPH_equal[]=		"equal";
static const char GLYPH_equivalence[]=		"equivalence";
static const char GLYPH_eta[]=			"eta";
static const char GLYPH_eth[]=			"eth";
static const char GLYPH_exclam[]=		"exclam";
static const char GLYPH_exclamdown[]=		"exclamdown";
static const char GLYPH_existential[]=		"existential";
static const char GLYPH_f[]=			"f";
static const char GLYPH_fi[]=			"fi";
static const char GLYPH_five[]=			"five";
static const char GLYPH_fl[]=			"fl";
static const char GLYPH_florin[]=		"florin";
static const char GLYPH_four[]=			"four";
static const char GLYPH_fraction[]=		"fraction";
static const char GLYPH_fullstop[]=		"fullstop";
static const char GLYPH_g[]=			"g";
static const char GLYPH_gamma[]=		"gamma";
static const char GLYPH_germandbls[]=		"germandbls";
static const char GLYPH_gradient[]=		"gradient";
static const char GLYPH_grave[]=		"grave";
static const char GLYPH_greater[]=		"greater";
static const char GLYPH_greaterequal[]=		"greaterequal";
static const char GLYPH_guillemotleft[]=	"guillemotleft";
static const char GLYPH_guillemotright[]=	"guillemotright";
static const char GLYPH_guillsinglleft[]=	"guillsinglleft";
static const char GLYPH_guillsinglright[]=	"guillsinglright";
static const char GLYPH_guilsinglleft[]=	"guilsinglleft";
static const char GLYPH_guilsinglright[]=	"guilsinglright";
static const char GLYPH_h[]=			"h";
static const char GLYPH_heart[]=		"heart";
static const char GLYPH_hungarumlaut[]=		"hungarumlaut";
static const char GLYPH_hyphen[]=		"hyphen";
static const char GLYPH_i[]=			"i";
static const char GLYPH_iacute[]=		"iacute";
static const char GLYPH_icircumflex[]=		"icircumflex";
static const char GLYPH_idiaeresis[]=		"idiaeresis";
static const char GLYPH_idieresis[]=		"idieresis";
static const char GLYPH_igrave[]=		"igrave";
static const char GLYPH_infinity[]=		"infinity";
static const char GLYPH_integral[]=		"integral";
static const char GLYPH_integralbt[]=		"integralbt";
static const char GLYPH_integralex[]=		"integralex";
static const char GLYPH_integraltp[]=		"integraltp";
static const char GLYPH_intersection[]=		"intersection";
static const char GLYPH_iota[]=			"iota";
static const char GLYPH_j[]=			"j";
static const char GLYPH_k[]=			"k";
static const char GLYPH_kappa[]=		"kappa";
static const char GLYPH_l[]=			"l";
static const char GLYPH_lacute[]=		"lacute";
static const char GLYPH_lambda[]=		"lambda";
static const char GLYPH_lcaron[]=		"lcaron";
static const char GLYPH_less[]=			"less";
static const char GLYPH_lessequal[]=		"lessequal";
static const char GLYPH_logicaland[]=		"logicaland";
static const char GLYPH_logicalnot[]=		"logicalnot";
static const char GLYPH_logicalor[]=		"logicalor";
static const char GLYPH_lozenge[]=		"lozenge";
static const char GLYPH_lowline[]=		"lowline";
static const char GLYPH_lslash[]=		"lslash";
static const char GLYPH_lstroke[]=		"lstroke";
static const char GLYPH_m[]=			"m";
static const char GLYPH_macron[]=		"macron";
static const char GLYPH_minus[]=		"minus";
static const char GLYPH_minute[]=		"minute";
static const char GLYPH_mu[]=			"mu";
static const char GLYPH_multiply[]=		"multiply";
static const char GLYPH_n[]=			"n";
static const char GLYPH_nacute[]=		"nacute";
static const char GLYPH_ncaron[]=		"ncaron";
static const char GLYPH_nine[]=			"nine";
static const char GLYPH_nobreakspace[]=		"nobreakspace";
static const char GLYPH_notelement[]=		"notelement";
static const char GLYPH_notequal[]=		"notequal";
static const char GLYPH_notsubset[]=		"notsubset";
static const char GLYPH_ntilde[]=		"ntilde";
static const char GLYPH_nu[]=			"nu";
static const char GLYPH_numbersign[]=		"numbersign";
static const char GLYPH_o[]=			"o";
static const char GLYPH_oacute[]=		"oacute";
static const char GLYPH_ocircumflex[]=		"ocircumflex";
static const char GLYPH_odiaeresis[]=		"odiaeresis";
static const char GLYPH_odieresis[]=		"odieresis";
static const char GLYPH_odoubleacute[]=		"odoubleacute";
static const char GLYPH_oe[]=			"oe";
static const char GLYPH_ogonek[]=		"ogonek";
static const char GLYPH_ograve[]=		"ograve";
static const char GLYPH_ohungarumlaut[]=	"ohungarumlaut";
static const char GLYPH_omega[]=		"omega";
static const char GLYPH_omega1[]=		"omega1";
static const char GLYPH_omicron[]=		"omicron";
static const char GLYPH_one[]=			"one";
static const char GLYPH_onehalf[]=		"onehalf";
static const char GLYPH_onequarter[]=		"onequarter";
static const char GLYPH_onesuperior[]=		"onesuperior";
static const char GLYPH_ordfeminine[]=		"ordfeminine";
static const char GLYPH_ordmasculine[]=		"ordmasculine";
static const char GLYPH_oslash[]=		"oslash";
static const char GLYPH_otilde[]=		"otilde";
static const char GLYPH_p[]=			"p";
static const char GLYPH_paragraph[]=		"paragraph";
static const char GLYPH_parenleft[]=		"parenleft";
static const char GLYPH_parenleftbt[]=		"parenleftbt";
static const char GLYPH_parenleftex[]=		"parenleftex";
static const char GLYPH_parenlefttp[]=		"parenlefttp";
static const char GLYPH_parenright[]=		"parenright";
static const char GLYPH_parenrightbt[]=		"parenrightbt";
static const char GLYPH_parenrightex[]=		"parenrightex";
static const char GLYPH_parenrighttp[]=		"parenrighttp";
static const char GLYPH_partialdiff[]=		"partialdiff";
static const char GLYPH_percent[]=		"percent";
static const char GLYPH_perthousand[]=		"perthousand";
static const char GLYPH_period[]=		"period";
static const char GLYPH_periodcentered[]=	"periodcentered";
static const char GLYPH_perpendicular[]=	"perpendicular";
static const char GLYPH_phi[]=			"phi";
static const char GLYPH_phi1[]=			"phi1";
static const char GLYPH_pi[]=			"pi";
static const char GLYPH_plus[]=			"plus";
static const char GLYPH_plusminus[]=		"plusminus";
static const char GLYPH_product[]=		"product";
static const char GLYPH_propersubset[]=		"propersubset";
static const char GLYPH_propersuperset[]=	"propersuperset";
static const char GLYPH_proportional[]=		"proportional";
static const char GLYPH_psi[]=			"psi";
static const char GLYPH_q[]=			"q";
static const char GLYPH_question[]=		"question";
static const char GLYPH_questiondown[]=		"questiondown";
static const char GLYPH_quotedbl[]=		"quotedbl";
static const char GLYPH_quotedblbase[]=		"quotedblbase";
static const char GLYPH_quotedblleft[]=		"quotedblleft";
static const char GLYPH_quotedblright[]=	"quotedblright";
static const char GLYPH_quoteleft[]=		"quoteleft";
static const char GLYPH_quoteright[]=		"quoteright";
static const char GLYPH_quotesingle[]=		"quotesingle";
static const char GLYPH_quotesinglbase[]=	"quotesinglbase";
static const char GLYPH_r[]=			"r";
static const char GLYPH_racute[]=		"racute";
static const char GLYPH_radical[]=		"radical";
static const char GLYPH_radicalex[]=		"radicalex";
static const char GLYPH_rcaron[]=		"rcaron";
static const char GLYPH_reflexsubset[]=		"reflexsubset";
static const char GLYPH_reflexsuperset[]=	"reflexsuperset";
static const char GLYPH_registered[]=		"registered";
static const char GLYPH_registersans[]=		"registersans";
static const char GLYPH_registerserif[]=	"registerserif";
static const char GLYPH_rho[]=			"rho";
static const char GLYPH_ring[]=			"ring";
static const char GLYPH_s[]=			"s";
static const char GLYPH_sacute[]=		"sacute";
static const char GLYPH_scaron[]=		"scaron";
static const char GLYPH_scedilla[]=		"scedilla";
static const char GLYPH_second[]=		"second";
static const char GLYPH_section[]=		"section";
static const char GLYPH_semicolon[]=		"semicolon";
static const char GLYPH_seven[]=		"seven";
static const char GLYPH_sigma[]=		"sigma";
static const char GLYPH_sigma1[]=		"sigma1";
static const char GLYPH_similar[]=		"similar";
static const char GLYPH_six[]=			"six";
static const char GLYPH_slash[]=		"slash";
static const char GLYPH_space[]=		"space";
static const char GLYPH_spade[]=		"spade";
static const char GLYPH_ssharp[]=		"ssharp";
static const char GLYPH_sterling[]=		"sterling";
static const char GLYPH_suchthat[]=		"suchthat";
static const char GLYPH_summation[]=		"summation";
static const char GLYPH_t[]=			"t";
static const char GLYPH_tau[]=			"tau";
static const char GLYPH_tcaron[]=		"tcaron";
static const char GLYPH_tcedilla[]=		"tcedilla";
static const char GLYPH_tcommaaccent[]=		"tcommaaccent";
static const char GLYPH_therefore[]=		"therefore";
static const char GLYPH_theta[]=		"theta";
static const char GLYPH_theta1[]=		"theta1";
static const char GLYPH_thorn[]=		"thorn";
static const char GLYPH_three[]=		"three";
static const char GLYPH_threequarters[]=	"threequarters";
static const char GLYPH_threesuperior[]=	"threesuperior";
static const char GLYPH_tilde[]=		"tilde";
static const char GLYPH_trademark[]=		"trademark";
static const char GLYPH_trademarksans[]=	"trademarksans";
static const char GLYPH_trademarkserif[]=	"trademarkserif";
static const char GLYPH_two[]=			"two";
static const char GLYPH_twosuperior[]=		"twosuperior";
static const char GLYPH_u[]=			"u";
static const char GLYPH_uacute[]=		"uacute";
static const char GLYPH_ucircumflex[]=		"ucircumflex";
static const char GLYPH_udiaeresis[]=		"udiaeresis";
static const char GLYPH_udieresis[]=		"udieresis";
static const char GLYPH_udoubleacute[]=		"udoubleacute";
static const char GLYPH_ugrave[]=		"ugrave";
static const char GLYPH_uhungarumlaut[]=	"uhungarumlaut";
static const char GLYPH_underscore[]=		"underscore";
static const char GLYPH_union[]=		"union";
static const char GLYPH_universal[]=		"universal";
static const char GLYPH_upsilon[]=		"upsilon";
static const char GLYPH_uring[]=		"uring";
static const char GLYPH_v[]=			"v";
static const char GLYPH_w[]=			"w";
static const char GLYPH_weierstrass[]=		"weierstrass";
static const char GLYPH_x[]=			"x";
static const char GLYPH_xi[]=			"xi";
static const char GLYPH_y[]=			"y";
static const char GLYPH_yacute[]=		"yacute";
static const char GLYPH_ydiaeresis[]=		"ydiaeresis";
static const char GLYPH_ydieresis[]=		"ydieresis";
static const char GLYPH_yen[]=			"yen";
static const char GLYPH_z[]=			"z";
static const char GLYPH_zabovedot[]=		"zabovedot";
static const char GLYPH_zacute[]=		"zacute";
static const char GLYPH_zcaron[]=		"zcaron";
static const char GLYPH_zdotaccent[]=		"zdotaccent";
static const char GLYPH_zero[]=			"zero";
static const char GLYPH_zeta[]=			"zeta";

static const char GLYPH_afii10017[]=		"afii10017";
static const char GLYPH_afii10018[]=		"afii10018";
static const char GLYPH_afii10019[]=		"afii10019";
static const char GLYPH_afii10020[]=		"afii10020";
static const char GLYPH_afii10021[]=		"afii10021";
static const char GLYPH_afii10022[]=		"afii10022";
static const char GLYPH_afii10023[]=		"afii10023";
static const char GLYPH_afii10024[]=		"afii10024";
static const char GLYPH_afii10025[]=		"afii10025";
static const char GLYPH_afii10026[]=		"afii10026";
static const char GLYPH_afii10027[]=		"afii10027";
static const char GLYPH_afii10028[]=		"afii10028";
static const char GLYPH_afii10029[]=		"afii10029";
static const char GLYPH_afii10030[]=		"afii10030";
static const char GLYPH_afii10031[]=		"afii10031";
static const char GLYPH_afii10032[]=		"afii10032";
static const char GLYPH_afii10033[]=		"afii10033";
static const char GLYPH_afii10034[]=		"afii10034";
static const char GLYPH_afii10035[]=		"afii10035";
static const char GLYPH_afii10036[]=		"afii10036";
static const char GLYPH_afii10037[]=		"afii10037";
static const char GLYPH_afii10038[]=		"afii10038";
static const char GLYPH_afii10039[]=		"afii10039";
static const char GLYPH_afii10040[]=		"afii10040";
static const char GLYPH_afii10041[]=		"afii10041";
static const char GLYPH_afii10042[]=		"afii10042";
static const char GLYPH_afii10043[]=		"afii10043";
static const char GLYPH_afii10044[]=		"afii10044";
static const char GLYPH_afii10045[]=		"afii10045";
static const char GLYPH_afii10046[]=		"afii10046";
static const char GLYPH_afii10047[]=		"afii10047";
static const char GLYPH_afii10048[]=		"afii10048";
static const char GLYPH_afii10049[]=		"afii10049";
static const char GLYPH_afii10050[]=		"afii10050";
static const char GLYPH_afii10051[]=		"afii10051";
static const char GLYPH_afii10052[]=		"afii10052";
static const char GLYPH_afii10053[]=		"afii10053";
static const char GLYPH_afii10054[]=		"afii10054";
static const char GLYPH_afii10055[]=		"afii10055";
static const char GLYPH_afii10056[]=		"afii10056";
static const char GLYPH_afii10057[]=		"afii10057";
static const char GLYPH_afii10058[]=		"afii10058";
static const char GLYPH_afii10059[]=		"afii10059";
static const char GLYPH_afii10060[]=		"afii10060";
static const char GLYPH_afii10061[]=		"afii10061";
static const char GLYPH_afii10062[]=		"afii10062";
static const char GLYPH_afii10065[]=		"afii10065";
static const char GLYPH_afii10066[]=		"afii10066";
static const char GLYPH_afii10067[]=		"afii10067";
static const char GLYPH_afii10068[]=		"afii10068";
static const char GLYPH_afii10069[]=		"afii10069";
static const char GLYPH_afii10070[]=		"afii10070";
static const char GLYPH_afii10071[]=		"afii10071";
static const char GLYPH_afii10072[]=		"afii10072";
static const char GLYPH_afii10073[]=		"afii10073";
static const char GLYPH_afii10074[]=		"afii10074";
static const char GLYPH_afii10075[]=		"afii10075";
static const char GLYPH_afii10076[]=		"afii10076";
static const char GLYPH_afii10077[]=		"afii10077";
static const char GLYPH_afii10078[]=		"afii10078";
static const char GLYPH_afii10079[]=		"afii10079";
static const char GLYPH_afii10080[]=		"afii10080";
static const char GLYPH_afii10081[]=		"afii10081";
static const char GLYPH_afii10082[]=		"afii10082";
static const char GLYPH_afii10083[]=		"afii10083";
static const char GLYPH_afii10084[]=		"afii10084";
static const char GLYPH_afii10085[]=		"afii10085";
static const char GLYPH_afii10086[]=		"afii10086";
static const char GLYPH_afii10087[]=		"afii10087";
static const char GLYPH_afii10088[]=		"afii10088";
static const char GLYPH_afii10089[]=		"afii10089";
static const char GLYPH_afii10090[]=		"afii10090";
static const char GLYPH_afii10091[]=		"afii10091";
static const char GLYPH_afii10092[]=		"afii10092";
static const char GLYPH_afii10093[]=		"afii10093";
static const char GLYPH_afii10094[]=		"afii10094";
static const char GLYPH_afii10095[]=		"afii10095";
static const char GLYPH_afii10096[]=		"afii10096";
static const char GLYPH_afii10097[]=		"afii10097";
static const char GLYPH_afii10098[]=		"afii10098";
static const char GLYPH_afii10099[]=		"afii10099";
static const char GLYPH_afii10100[]=		"afii10100";
static const char GLYPH_afii10101[]=		"afii10101";
static const char GLYPH_afii10102[]=		"afii10102";
static const char GLYPH_afii10103[]=		"afii10103";
static const char GLYPH_afii10104[]=		"afii10104";
static const char GLYPH_afii10105[]=		"afii10105";
static const char GLYPH_afii10106[]=		"afii10106";
static const char GLYPH_afii10107[]=		"afii10107";
static const char GLYPH_afii10108[]=		"afii10108";
static const char GLYPH_afii10109[]=		"afii10109";
static const char GLYPH_afii10110[]=		"afii10110";
static const char GLYPH_afii10145[]=		"afii10145";
static const char GLYPH_afii10193[]=		"afii10193";
static const char GLYPH_afii61352[]=		"afii61352";

/************************************************************************/
/*									*/
/*  ISO Latin1 (ISO 8859-1) to postscript glyph names.			*/
/*									*/
/************************************************************************/

const char *	psIsoLatin1GlyphNames[256]=
    {
    (char *)0,			/*  nul		0	*/
    (char *)0,			/*  soh		1	*/
    (char *)0,			/*  stx		2	*/
    (char *)0,			/*  etx		3	*/
    (char *)0,			/*  eot		4	*/
    (char *)0,			/*  enq		5	*/
    (char *)0,			/*  ack		6	*/
    (char *)0,			/*  bel		7	*/
    (char *)0,			/*  bs		8	*/
    (char *)0,			/*  ht		9	*/
    (char *)0,			/*  nl		10	*/
    (char *)0,			/*  vt		11	*/
    (char *)0,			/*  np		12	*/
    (char *)0,			/*  cr		13	*/
    (char *)0,			/*  so		14	*/
    (char *)0,			/*  si		15	*/
    (char *)0,			/*  dle		16	*/
    (char *)0,			/*  dc1		17	*/
    (char *)0,			/*  dc2		18	*/
    (char *)0,			/*  dc3		19	*/
    (char *)0,			/*  dc4		20	*/
    (char *)0,			/*  nak		21	*/
    (char *)0,			/*  syn		22	*/
    (char *)0,			/*  etb		23	*/
    (char *)0,			/*  can		24	*/
    (char *)0,			/*  em		25	*/
    (char *)0,			/*  sub		26	*/
    (char *)0,			/*  esc		27	*/
    (char *)0,			/*  fs		28	*/
    (char *)0,			/*  gs		29	*/
    (char *)0,			/*  rs		30	*/
    (char *)0,			/*  us		31	*/
    GLYPH_space,		/*  32			*/
    GLYPH_exclam,		/*  33			*/
    GLYPH_quotedbl,		/*  34			*/
    GLYPH_numbersign,		/*  35			*/
    GLYPH_dollar,		/*  36			*/
    GLYPH_percent,		/*  37			*/
    GLYPH_ampersand,		/*  38			*/
    GLYPH_quoteright,		/*  39			*/
    GLYPH_parenleft,		/*  40			*/
    GLYPH_parenright,		/*  41			*/
    GLYPH_asterisk,		/*  42			*/
    GLYPH_plus,			/*  43			*/
    GLYPH_comma,		/*  44			*/
    GLYPH_minus,		/*  45			*/
    GLYPH_period,		/*  46			*/
    GLYPH_slash,		/*  47			*/
    GLYPH_zero,			/*  48			*/
    GLYPH_one,			/*  49			*/
    GLYPH_two,			/*  50			*/
    GLYPH_three,		/*  51			*/
    GLYPH_four,			/*  52			*/
    GLYPH_five,			/*  53			*/
    GLYPH_six,			/*  54			*/
    GLYPH_seven,		/*  55			*/
    GLYPH_eight,		/*  56			*/
    GLYPH_nine,			/*  57			*/
    GLYPH_colon,		/*  58			*/
    GLYPH_semicolon,		/*  59			*/
    GLYPH_less,			/*  60			*/
    GLYPH_equal,		/*  61			*/
    GLYPH_greater,		/*  62			*/
    GLYPH_question,		/*  63			*/
    GLYPH_at,			/*  64			*/
    GLYPH_A,			/*  65			*/
    GLYPH_B,			/*  66			*/
    GLYPH_C,			/*  67			*/
    GLYPH_D,			/*  68			*/
    GLYPH_E,			/*  69			*/
    GLYPH_F,			/*  70			*/
    GLYPH_G,			/*  71			*/
    GLYPH_H,			/*  72			*/
    GLYPH_I,			/*  73			*/
    GLYPH_J,			/*  74			*/
    GLYPH_K,			/*  75			*/
    GLYPH_L,			/*  76			*/
    GLYPH_M,			/*  77			*/
    GLYPH_N,			/*  78			*/
    GLYPH_O,			/*  79			*/
    GLYPH_P,			/*  80			*/
    GLYPH_Q,			/*  81			*/
    GLYPH_R,			/*  82			*/
    GLYPH_S,			/*  83			*/
    GLYPH_T,			/*  84			*/
    GLYPH_U,			/*  85			*/
    GLYPH_V,			/*  86			*/
    GLYPH_W,			/*  87			*/
    GLYPH_X,			/*  88			*/
    GLYPH_Y,			/*  89			*/
    GLYPH_Z,			/*  90			*/
    GLYPH_bracketleft,		/*  91			*/
    GLYPH_backslash,		/*  92			*/
    GLYPH_bracketright,		/*  93			*/
    GLYPH_asciicircum,		/*  94			*/
    GLYPH_underscore,		/*  95			*/
    GLYPH_quoteleft,		/*  96			*/
    GLYPH_a,			/*  97			*/
    GLYPH_b,			/*  98			*/
    GLYPH_c,			/*  99			*/
    GLYPH_d,			/*  100			*/
    GLYPH_e,			/*  101			*/
    GLYPH_f,			/*  102			*/
    GLYPH_g,			/*  103			*/
    GLYPH_h,			/*  104			*/
    GLYPH_i,			/*  105			*/
    GLYPH_j,			/*  106			*/
    GLYPH_k,			/*  107			*/
    GLYPH_l,			/*  108			*/
    GLYPH_m,			/*  109			*/
    GLYPH_n,			/*  110			*/
    GLYPH_o,			/*  111			*/
    GLYPH_p,			/*  112			*/
    GLYPH_q,			/*  113			*/
    GLYPH_r,			/*  114			*/
    GLYPH_s,			/*  115			*/
    GLYPH_t,			/*  116			*/
    GLYPH_u,			/*  117			*/
    GLYPH_v,			/*  118			*/
    GLYPH_w,			/*  119			*/
    GLYPH_x,			/*  120			*/
    GLYPH_y,			/*  121			*/
    GLYPH_z,			/*  122			*/
    GLYPH_braceleft,		/*  123			*/
    GLYPH_bar,			/*  124			*/
    GLYPH_braceright,		/*  125			*/
    GLYPH_asciitilde,		/*  126			*/
    (char *)0,			/*  127			*/
    (char *)0,			/*  128			*/
    (char *)0,			/*  129			*/
    (char *)0,			/*  130			*/
    (char *)0,			/*  131			*/
    (char *)0,			/*  132			*/
    (char *)0,			/*  133			*/
    (char *)0,			/*  134			*/
    (char *)0,			/*  135			*/
    (char *)0,			/*  136			*/
    (char *)0,			/*  137			*/
    (char *)0,			/*  138			*/
    (char *)0,			/*  139			*/
    (char *)0,			/*  140			*/
    (char *)0,			/*  141			*/
    (char *)0,			/*  142			*/
    (char *)0,			/*  143			*/
    GLYPH_dotlessi,		/*  144			*/
    GLYPH_grave,		/*  145			*/
    GLYPH_acute,		/*  146			*/
    GLYPH_circumflex,		/*  147			*/
    GLYPH_tilde,		/*  148			*/
    GLYPH_macron,		/*  149			*/
    GLYPH_breve,		/*  150			*/
    GLYPH_dotaccent,		/*  151			*/
    GLYPH_dieresis,		/*  152			*/
    (char *)0,			/*  153			*/
    GLYPH_ring,			/*  154			*/
    GLYPH_cedilla,		/*  155			*/
    (char *)0,			/*  156			*/
    GLYPH_hungarumlaut,		/*  157			*/
    GLYPH_ogonek,		/*  158			*/
    GLYPH_caron,		/*  159			*/
    GLYPH_nobreakspace,		/*  160			*/
    GLYPH_exclamdown,		/*  161			*/
    GLYPH_cent,			/*  162			*/
    GLYPH_sterling,		/*  163			*/
    GLYPH_currency,		/*  164			*/
    GLYPH_yen,			/*  165			*/
    GLYPH_brokenbar,		/*  166			*/
    GLYPH_section,		/*  167			*/
    GLYPH_dieresis,		/*  168			*/
    GLYPH_copyright,		/*  169			*/
    GLYPH_ordfeminine,		/*  170			*/
    GLYPH_guillemotleft,	/*  171			*/
    GLYPH_logicalnot,		/*  172			*/
    GLYPH_hyphen,		/*  173			*/
    GLYPH_registered,		/*  174			*/
    GLYPH_macron,		/*  175			*/
    GLYPH_degree,		/*  176			*/
    GLYPH_plusminus,		/*  177			*/
    GLYPH_twosuperior,		/*  178			*/
    GLYPH_threesuperior,	/*  179			*/
    GLYPH_acute,		/*  180			*/
    GLYPH_mu,			/*  181			*/
    GLYPH_paragraph,		/*  182			*/
    GLYPH_periodcentered,	/*  183			*/
    GLYPH_cedilla,		/*  184			*/
    GLYPH_onesuperior,		/*  185			*/
    GLYPH_ordmasculine,		/*  186			*/
    GLYPH_guillemotright,	/*  187			*/
    GLYPH_onequarter,		/*  188			*/
    GLYPH_onehalf,		/*  189			*/
    GLYPH_threequarters,	/*  190			*/
    GLYPH_questiondown,		/*  191			*/
    GLYPH_Agrave,		/*  192			*/
    GLYPH_Aacute,		/*  193			*/
    GLYPH_Acircumflex,		/*  194			*/
    GLYPH_Atilde,		/*  195			*/
    GLYPH_Adieresis,		/*  196			*/
    GLYPH_Aring,		/*  197			*/
    GLYPH_AE,			/*  198			*/
    GLYPH_Ccedilla,		/*  199			*/
    GLYPH_Egrave,		/*  200			*/
    GLYPH_Eacute,		/*  201			*/
    GLYPH_Ecircumflex,		/*  202			*/
    GLYPH_Edieresis,		/*  203			*/
    GLYPH_Igrave,		/*  204			*/
    GLYPH_Iacute,		/*  205			*/
    GLYPH_Icircumflex,		/*  206			*/
    GLYPH_Idieresis,		/*  207			*/
    GLYPH_Eth,			/*  208			*/
    GLYPH_Ntilde,		/*  209			*/
    GLYPH_Ograve,		/*  210			*/
    GLYPH_Oacute,		/*  211			*/
    GLYPH_Ocircumflex,		/*  212			*/
    GLYPH_Otilde,		/*  213			*/
    GLYPH_Odieresis,		/*  214			*/
    GLYPH_multiply,		/*  215			*/
    GLYPH_Oslash,		/*  216			*/
    GLYPH_Ugrave,		/*  217			*/
    GLYPH_Uacute,		/*  218			*/
    GLYPH_Ucircumflex,		/*  219			*/
    GLYPH_Udieresis,		/*  220			*/
    GLYPH_Yacute,		/*  221			*/
    GLYPH_Thorn,		/*  222			*/
    GLYPH_germandbls,		/*  223			*/
    GLYPH_agrave,		/*  224			*/
    GLYPH_aacute,		/*  225			*/
    GLYPH_acircumflex,		/*  226			*/
    GLYPH_atilde,		/*  227			*/
    GLYPH_adieresis,		/*  228			*/
    GLYPH_aring,		/*  229			*/
    GLYPH_ae,			/*  230			*/
    GLYPH_ccedilla,		/*  231			*/
    GLYPH_egrave,		/*  232			*/
    GLYPH_eacute,		/*  233			*/
    GLYPH_ecircumflex,		/*  234			*/
    GLYPH_edieresis,		/*  235			*/
    GLYPH_igrave,		/*  236			*/
    GLYPH_iacute,		/*  237			*/
    GLYPH_icircumflex,		/*  238			*/
    GLYPH_idieresis,		/*  239			*/
    GLYPH_eth,			/*  240			*/
    GLYPH_ntilde,		/*  241			*/
    GLYPH_ograve,		/*  242			*/
    GLYPH_oacute,		/*  243			*/
    GLYPH_ocircumflex,		/*  244			*/
    GLYPH_otilde,		/*  245			*/
    GLYPH_odieresis,		/*  246			*/
    GLYPH_divide,		/*  247			*/
    GLYPH_oslash,		/*  248			*/
    GLYPH_ugrave,		/*  249			*/
    GLYPH_uacute,		/*  250			*/
    GLYPH_ucircumflex,		/*  251			*/
    GLYPH_udieresis,		/*  252			*/
    GLYPH_yacute,		/*  253			*/
    GLYPH_thorn,		/*  254			*/
    GLYPH_ydieresis,		/*  255			*/
    };

/************************************************************************/
/*									*/
/*  Adobe standard encoding.						*/
/*									*/
/************************************************************************/

const char *	psStdEncodingGlyphNames[256]=
    {
    (char *)0,			/*  nul		0	*/
    (char *)0,			/*  soh		1	*/
    (char *)0,			/*  stx		2	*/
    (char *)0,			/*  etx		3	*/
    (char *)0,			/*  eot		4	*/
    (char *)0,			/*  enq		5	*/
    (char *)0,			/*  ack		6	*/
    (char *)0,			/*  bel		7	*/
    (char *)0,			/*  bs		8	*/
    (char *)0,			/*  ht		9	*/
    (char *)0,			/*  nl		10	*/
    (char *)0,			/*  vt		11	*/
    (char *)0,			/*  np		12	*/
    (char *)0,			/*  cr		13	*/
    (char *)0,			/*  so		14	*/
    (char *)0,			/*  si		15	*/
    (char *)0,			/*  dle		16	*/
    (char *)0,			/*  dc1		17	*/
    (char *)0,			/*  dc2		18	*/
    (char *)0,			/*  dc3		19	*/
    (char *)0,			/*  dc4		20	*/
    (char *)0,			/*  nak		21	*/
    (char *)0,			/*  syn		22	*/
    (char *)0,			/*  etb		23	*/
    (char *)0,			/*  can		24	*/
    (char *)0,			/*  em		25	*/
    (char *)0,			/*  sub		26	*/
    (char *)0,			/*  esc		27	*/
    (char *)0,			/*  fs		28	*/
    (char *)0,			/*  gs		29	*/
    (char *)0,			/*  rs		30	*/
    (char *)0,			/*  us		31	*/
    GLYPH_space,		/*  32			*/
    GLYPH_exclam,		/*  33			*/
    GLYPH_quotedbl,		/*  34			*/
    GLYPH_numbersign,		/*  35			*/
    GLYPH_dollar,		/*  36			*/
    GLYPH_percent,		/*  37			*/
    GLYPH_ampersand,		/*  38			*/
    GLYPH_quoteright,		/*  39			*/
    GLYPH_parenleft,		/*  40			*/
    GLYPH_parenright,		/*  41			*/
    GLYPH_asterisk,		/*  42			*/
    GLYPH_plus,			/*  43			*/
    GLYPH_comma,		/*  44			*/
    GLYPH_minus,		/*  45			*/
    GLYPH_period,		/*  46			*/
    GLYPH_slash,		/*  47			*/
    GLYPH_zero,			/*  48			*/
    GLYPH_one,			/*  49			*/
    GLYPH_two,			/*  50			*/
    GLYPH_three,		/*  51			*/
    GLYPH_four,			/*  52			*/
    GLYPH_five,			/*  53			*/
    GLYPH_six,			/*  54			*/
    GLYPH_seven,		/*  55			*/
    GLYPH_eight,		/*  56			*/
    GLYPH_nine,			/*  57			*/
    GLYPH_colon,		/*  58			*/
    GLYPH_semicolon,		/*  59			*/
    GLYPH_less,			/*  60			*/
    GLYPH_equal,		/*  61			*/
    GLYPH_greater,		/*  62			*/
    GLYPH_question,		/*  63			*/
    GLYPH_at,			/*  64			*/
    GLYPH_A,			/*  65			*/
    GLYPH_B,			/*  66			*/
    GLYPH_C,			/*  67			*/
    GLYPH_D,			/*  68			*/
    GLYPH_E,			/*  69			*/
    GLYPH_F,			/*  70			*/
    GLYPH_G,			/*  71			*/
    GLYPH_H,			/*  72			*/
    GLYPH_I,			/*  73			*/
    GLYPH_J,			/*  74			*/
    GLYPH_K,			/*  75			*/
    GLYPH_L,			/*  76			*/
    GLYPH_M,			/*  77			*/
    GLYPH_N,			/*  78			*/
    GLYPH_O,			/*  79			*/
    GLYPH_P,			/*  80			*/
    GLYPH_Q,			/*  81			*/
    GLYPH_R,			/*  82			*/
    GLYPH_S,			/*  83			*/
    GLYPH_T,			/*  84			*/
    GLYPH_U,			/*  85			*/
    GLYPH_V,			/*  86			*/
    GLYPH_W,			/*  87			*/
    GLYPH_X,			/*  88			*/
    GLYPH_Y,			/*  89			*/
    GLYPH_Z,			/*  90			*/
    GLYPH_bracketleft,		/*  91			*/
    GLYPH_backslash,		/*  92			*/
    GLYPH_bracketright,		/*  93			*/
    GLYPH_asciicircum,		/*  94			*/
    GLYPH_underscore,		/*  95			*/
    GLYPH_quoteleft,		/*  96			*/
    GLYPH_a,			/*  97			*/
    GLYPH_b,			/*  98			*/
    GLYPH_c,			/*  99			*/
    GLYPH_d,			/*  100			*/
    GLYPH_e,			/*  101			*/
    GLYPH_f,			/*  102			*/
    GLYPH_g,			/*  103			*/
    GLYPH_h,			/*  104			*/
    GLYPH_i,			/*  105			*/
    GLYPH_j,			/*  106			*/
    GLYPH_k,			/*  107			*/
    GLYPH_l,			/*  108			*/
    GLYPH_m,			/*  109			*/
    GLYPH_n,			/*  110			*/
    GLYPH_o,			/*  111			*/
    GLYPH_p,			/*  112			*/
    GLYPH_q,			/*  113			*/
    GLYPH_r,			/*  114			*/
    GLYPH_s,			/*  115			*/
    GLYPH_t,			/*  116			*/
    GLYPH_u,			/*  117			*/
    GLYPH_v,			/*  118			*/
    GLYPH_w,			/*  119			*/
    GLYPH_x,			/*  120			*/
    GLYPH_y,			/*  121			*/
    GLYPH_z,			/*  122			*/
    GLYPH_braceleft,		/*  123			*/
    GLYPH_bar,			/*  124			*/
    GLYPH_braceright,		/*  125			*/
    GLYPH_asciitilde,		/*  126			*/
    (char *)0,			/*  127			*/
    (char *)0,			/*  128			*/
    (char *)0,			/*  129			*/
    (char *)0,			/*  130			*/
    (char *)0,			/*  131			*/
    (char *)0,			/*  132			*/
    (char *)0,			/*  133			*/
    (char *)0,			/*  134			*/
    (char *)0,			/*  135			*/
    (char *)0,			/*  136			*/
    (char *)0,			/*  137			*/
    (char *)0,			/*  138			*/
    (char *)0,			/*  139			*/
    (char *)0,			/*  140			*/
    (char *)0,			/*  141			*/
    (char *)0,			/*  142			*/
    (char *)0,			/*  143			*/
    (char *)0,			/*  144			*/
    (char *)0,			/*  145			*/
    (char *)0,			/*  146			*/
    (char *)0,			/*  147			*/
    (char *)0,			/*  148			*/
    (char *)0,			/*  149			*/
    (char *)0,			/*  150			*/
    (char *)0,			/*  151			*/
    (char *)0,			/*  152			*/
    (char *)0,			/*  153			*/
    (char *)0,			/*  154			*/
    (char *)0,			/*  155			*/
    (char *)0,			/*  156			*/
    (char *)0,			/*  157			*/
    (char *)0,			/*  158			*/
    (char *)0,			/*  159			*/
    (char *)0,			/*  160			*/
    GLYPH_exclamdown,		/*  161			*/
    GLYPH_cent,			/*  162			*/
    GLYPH_sterling,		/*  163			*/
    GLYPH_fraction,		/*  164			*/
    GLYPH_yen,			/*  165			*/
    GLYPH_florin,		/*  166			*/
    GLYPH_section,		/*  167			*/
    GLYPH_currency,		/*  168			*/
    GLYPH_quotesingle,		/*  169			*/
    GLYPH_quotedblleft,		/*  170			*/
    GLYPH_guillemotleft,	/*  171			*/
    GLYPH_guillsinglleft,	/*  172			*/
    GLYPH_guillsinglright,	/*  173			*/
    GLYPH_fi,			/*  174			*/
    GLYPH_fl,			/*  175			*/
    (char *)0,			/*  176			*/
    GLYPH_endash,		/*  177			*/
    GLYPH_dagger,		/*  178			*/
    GLYPH_daggerdbl,		/*  179			*/
    GLYPH_periodcentered,	/*  180			*/
    (char *)0,			/*  181			*/
    GLYPH_paragraph,		/*  182			*/
    GLYPH_bullet,		/*  183			*/
    GLYPH_quotesinglbase,	/*  184			*/
    GLYPH_quotedblbase,		/*  185			*/
    GLYPH_quotedblright,	/*  186			*/
    GLYPH_guillemotright,	/*  187			*/
    GLYPH_ellipsis,		/*  188			*/
    GLYPH_perthousand,		/*  189			*/
    (char *)0,			/*  190			*/
    GLYPH_questiondown,		/*  191			*/
    (char *)0,			/*  192			*/
    GLYPH_grave,		/*  193			*/
    GLYPH_acute,		/*  194			*/
    GLYPH_circumflex,		/*  195			*/
    GLYPH_tilde,		/*  196			*/
    GLYPH_macron,		/*  197			*/
    GLYPH_breve,		/*  198			*/
    GLYPH_dotaccent,		/*  199			*/
    GLYPH_dieresis,		/*  200			*/
    (char *)0,			/*  201			*/
    GLYPH_ring,			/*  202			*/
    GLYPH_cedilla,		/*  203			*/
    (char *)0,			/*  204			*/
    GLYPH_hungarumlaut,		/*  205			*/
    GLYPH_ogonek,		/*  206			*/
    GLYPH_caron,		/*  207			*/
    GLYPH_emdash,		/*  208			*/
    (char *)0,			/*  209			*/
    (char *)0,			/*  210			*/
    (char *)0,			/*  211			*/
    (char *)0,			/*  212			*/
    (char *)0,			/*  213			*/
    (char *)0,			/*  214			*/
    (char *)0,			/*  215			*/
    (char *)0,			/*  216			*/
    (char *)0,			/*  217			*/
    (char *)0,			/*  218			*/
    (char *)0,			/*  219			*/
    (char *)0,			/*  220			*/
    (char *)0,			/*  221			*/
    (char *)0,			/*  222			*/
    (char *)0,			/*  223			*/
    (char *)0,			/*  224			*/
    GLYPH_AE,			/*  225			*/
    (char *)0,			/*  226			*/
    GLYPH_ordfeminine,		/*  227			*/
    (char *)0,			/*  228			*/
    (char *)0,			/*  229			*/
    (char *)0,			/*  230			*/
    (char *)0,			/*  231			*/
    GLYPH_Lslash,		/*  232			*/
    GLYPH_Oslash,		/*  233			*/
    GLYPH_OE,			/*  234			*/
    GLYPH_ordmasculine,		/*  235			*/
    (char *)0,			/*  236			*/
    (char *)0,			/*  237			*/
    (char *)0,			/*  238			*/
    (char *)0,			/*  239			*/
    (char *)0,			/*  240			*/
    GLYPH_ae,			/*  241			*/
    (char *)0,			/*  242			*/
    (char *)0,			/*  243			*/
    (char *)0,			/*  244			*/
    GLYPH_dotlessi,		/*  245			*/
    (char *)0,			/*  246			*/
    (char *)0,			/*  247			*/
    GLYPH_lslash,		/*  248			*/
    GLYPH_oslash,		/*  249			*/
    GLYPH_oe,			/*  250			*/
    GLYPH_germandbls,		/*  251			*/
    (char *)0,			/*  252			*/
    (char *)0,			/*  253			*/
    (char *)0,			/*  254			*/
    (char *)0,			/*  255			*/
    };

/************************************************************************/
/*									*/
/*  Postscript symbol encoding to postscript glyph names.		*/
/*									*/
/************************************************************************/

const char *	psSymbolGlyphNames[256]=
    {
    (char *)0,			/*  0	*/
    (char *)0,			/*  1	*/
    (char *)0,			/*  2	*/
    (char *)0,			/*  3	*/
    (char *)0,			/*  4	*/
    (char *)0,			/*  5	*/
    (char *)0,			/*  6	*/
    (char *)0,			/*  7	*/
    (char *)0,			/*  8	*/
    (char *)0,			/*  9	*/
    (char *)0,			/*  10	*/
    (char *)0,			/*  11	*/
    (char *)0,			/*  12	*/
    (char *)0,			/*  13	*/
    (char *)0,			/*  14	*/
    (char *)0,			/*  15	*/
    (char *)0,			/*  16	*/
    (char *)0,			/*  17	*/
    (char *)0,			/*  18	*/
    (char *)0,			/*  19	*/
    (char *)0,			/*  20	*/
    (char *)0,			/*  21	*/
    (char *)0,			/*  22	*/
    (char *)0,			/*  23	*/
    (char *)0,			/*  24	*/
    (char *)0,			/*  25	*/
    (char *)0,			/*  26	*/
    (char *)0,			/*  27	*/
    (char *)0,			/*  28	*/
    (char *)0,			/*  29	*/
    (char *)0,			/*  30	*/
    (char *)0,			/*  31	*/
    GLYPH_space,		/*  32	*/
    GLYPH_exclam,		/*  33	*/
    GLYPH_universal,		/*  34	*/
    GLYPH_numbersign,		/*  35	*/
    GLYPH_existential,		/*  36	*/
    GLYPH_percent,		/*  37	*/
    GLYPH_ampersand,		/*  38	*/
    GLYPH_suchthat,		/*  39	*/
    GLYPH_parenleft,		/*  40	*/
    GLYPH_parenright,		/*  41	*/
    GLYPH_asteriskmath,		/*  42	*/
    GLYPH_plus,			/*  43	*/
    GLYPH_comma,		/*  44	*/
    GLYPH_minus,		/*  45	*/
    GLYPH_period,		/*  46	*/
    GLYPH_slash,		/*  47	*/
    GLYPH_zero,			/*  48	*/
    GLYPH_one,			/*  49	*/
    GLYPH_two,			/*  50	*/
    GLYPH_three,		/*  51	*/
    GLYPH_four,			/*  52	*/
    GLYPH_five,			/*  53	*/
    GLYPH_six,			/*  54	*/
    GLYPH_seven,		/*  55	*/
    GLYPH_eight,		/*  56	*/
    GLYPH_nine,			/*  57	*/
    GLYPH_colon,		/*  58	*/
    GLYPH_semicolon,		/*  59	*/
    GLYPH_less,			/*  60	*/
    GLYPH_equal,		/*  61	*/
    GLYPH_greater,		/*  62	*/
    GLYPH_question,		/*  63	*/
    GLYPH_congruent,		/*  64	*/
    GLYPH_Alpha,		/*  65	*/
    GLYPH_Beta,			/*  66	*/
    GLYPH_Chi,			/*  67	*/
    GLYPH_Delta,		/*  68	*/
    GLYPH_Epsilon,		/*  69	*/
    GLYPH_Phi,			/*  70	*/
    GLYPH_Gamma,		/*  71	*/
    GLYPH_Eta,			/*  72	*/
    GLYPH_Iota,			/*  73	*/
    GLYPH_theta1,		/*  74	*/
    GLYPH_Kappa,		/*  75	*/
    GLYPH_Lambda,		/*  76	*/
    GLYPH_Mu,			/*  77	*/
    GLYPH_Nu,			/*  78	*/
    GLYPH_Omicron,		/*  79	*/
    GLYPH_Pi,			/*  80	*/
    GLYPH_Theta,		/*  81	*/
    GLYPH_Rho,			/*  82	*/
    GLYPH_Sigma,		/*  83	*/
    GLYPH_Tau,			/*  84	*/
    GLYPH_Upsilon,		/*  85	*/
    GLYPH_sigma1,		/*  86	*/
    GLYPH_Omega,		/*  87	*/
    GLYPH_Xi,			/*  88	*/
    GLYPH_Psi,			/*  89	*/
    GLYPH_Zeta,			/*  90	*/
    GLYPH_bracketleft,		/*  91	*/
    GLYPH_therefore,		/*  92	*/
    GLYPH_bracketright,		/*  93	*/
    GLYPH_perpendicular,	/*  94	*/
    GLYPH_underscore,		/*  95	*/
    GLYPH_radicalex,		/*  96	*/
    GLYPH_alpha,		/*  97	*/
    GLYPH_beta,			/*  98	*/
    GLYPH_chi,			/*  99	*/
    GLYPH_delta,		/*  100	*/
    GLYPH_epsilon,		/*  101	*/
    GLYPH_phi,			/*  102	*/
    GLYPH_gamma,		/*  103	*/
    GLYPH_eta,			/*  104	*/
    GLYPH_iota,			/*  105	*/
    GLYPH_phi1,			/*  106	*/
    GLYPH_kappa,		/*  107	*/
    GLYPH_lambda,		/*  108	*/
    GLYPH_mu,			/*  109	*/
    GLYPH_nu,			/*  110	*/
    GLYPH_omicron,		/*  111	*/
    GLYPH_pi,			/*  112	*/
    GLYPH_theta,		/*  113	*/
    GLYPH_rho,			/*  114	*/
    GLYPH_sigma,		/*  115	*/
    GLYPH_tau,			/*  116	*/
    GLYPH_upsilon,		/*  117	*/
    GLYPH_omega1,		/*  118	*/
    GLYPH_omega,		/*  119	*/
    GLYPH_xi,			/*  120	*/
    GLYPH_psi,			/*  121	*/
    GLYPH_zeta,			/*  122	*/
    GLYPH_braceleft,		/*  123	*/
    GLYPH_bar,			/*  124	*/
    GLYPH_braceright,		/*  125	*/
    GLYPH_similar,		/*  126	*/
    (char *)0,			/*  127	*/
    (char *)0,			/*  128	*/
    (char *)0,			/*  129	*/
    (char *)0,			/*  130	*/
    (char *)0,			/*  131	*/
    (char *)0,			/*  132	*/
    (char *)0,			/*  133	*/
    (char *)0,			/*  134	*/
    (char *)0,			/*  135	*/
    (char *)0,			/*  136	*/
    (char *)0,			/*  137	*/
    (char *)0,			/*  138	*/
    (char *)0,			/*  139	*/
    (char *)0,			/*  140	*/
    (char *)0,			/*  141	*/
    (char *)0,			/*  142	*/
    (char *)0,			/*  143	*/
    (char *)0,			/*  144	*/
    (char *)0,			/*  145	*/
    (char *)0,			/*  146	*/
    (char *)0,			/*  147	*/
    (char *)0,			/*  148	*/
    (char *)0,			/*  149	*/
    (char *)0,			/*  150	*/
    (char *)0,			/*  151	*/
    (char *)0,			/*  152	*/
    (char *)0,			/*  153	*/
    (char *)0,			/*  154	*/
    (char *)0,			/*  155	*/
    (char *)0,			/*  156	*/
    (char *)0,			/*  157	*/
    (char *)0,			/*  158	*/
    (char *)0,			/*  159	*/
    (char *)0,			/*  160	*/
    GLYPH_Upsilon1,		/*  161	*/
    GLYPH_minute,		/*  162	*/
    GLYPH_lessequal,		/*  163	*/
    GLYPH_fraction,		/*  164	*/
    GLYPH_infinity,		/*  165	*/
    GLYPH_florin,		/*  166	*/
    GLYPH_club,			/*  167	*/
    GLYPH_diamond,		/*  168	*/
    GLYPH_heart,		/*  169	*/
    GLYPH_spade,		/*  170	*/
    GLYPH_arrowboth,		/*  171	*/
    GLYPH_arrowleft,		/*  172	*/
    GLYPH_arrowup,		/*  173	*/
    GLYPH_arrowright,		/*  174	*/
    GLYPH_arrowdown,		/*  175	*/
    GLYPH_degree,		/*  176	*/
    GLYPH_plusminus,		/*  177	*/
    GLYPH_second,		/*  178	*/
    GLYPH_greaterequal,		/*  179	*/
    GLYPH_multiply,		/*  180	*/
    GLYPH_proportional,		/*  181	*/
    GLYPH_partialdiff,		/*  182	*/
    GLYPH_bullet,		/*  183	*/
    GLYPH_divide,		/*  184	*/
    GLYPH_notequal,		/*  185	*/
    GLYPH_equivalence,		/*  186	*/
    GLYPH_approxequal,		/*  187	*/
    GLYPH_ellipsis,		/*  188	*/
    GLYPH_arrowvertex,		/*  189	*/
    GLYPH_arrowhorizex,		/*  190	*/
    GLYPH_carriagereturn,	/*  191	*/
    GLYPH_aleph,		/*  192	*/
    GLYPH_Ifraktur,		/*  193	*/
    GLYPH_Rfraktur,		/*  194	*/
    GLYPH_weierstrass,		/*  195	*/
    GLYPH_circlemultiply,	/*  196	*/
    GLYPH_circleplus,		/*  197	*/
    GLYPH_emptyset,		/*  198	*/
    GLYPH_intersection,		/*  199	*/
    GLYPH_union,		/*  200	*/
    GLYPH_propersuperset,	/*  201	*/
    GLYPH_reflexsuperset,	/*  202	*/
    GLYPH_notsubset,		/*  203	*/
    GLYPH_propersubset,		/*  204	*/
    GLYPH_reflexsubset,		/*  205	*/
    GLYPH_element,		/*  206	*/
    GLYPH_notelement,		/*  207	*/
    GLYPH_angle,		/*  208	*/
    GLYPH_gradient,		/*  209	*/
    GLYPH_registerserif,	/*  210	*/
    GLYPH_copyrightserif,	/*  211	*/
    GLYPH_trademarkserif,	/*  212	*/
    GLYPH_product,		/*  213	*/
    GLYPH_radical,		/*  214	*/
    GLYPH_dotmath,		/*  215	*/
    GLYPH_logicalnot,		/*  216	*/
    GLYPH_logicaland,		/*  217	*/
    GLYPH_logicalor,		/*  218	*/
    GLYPH_arrowdblboth,		/*  219	*/
    GLYPH_arrowdblleft,		/*  220	*/
    GLYPH_arrowdblup,		/*  221	*/
    GLYPH_arrowdblright,	/*  222	*/
    GLYPH_arrowdbldown,		/*  223	*/
    GLYPH_lozenge,		/*  224	*/
    GLYPH_angleleft,		/*  225	*/
    GLYPH_registersans,		/*  226	*/
    GLYPH_copyrightsans,	/*  227	*/
    GLYPH_trademarksans,	/*  228	*/
    GLYPH_summation,		/*  229	*/
    GLYPH_parenlefttp,		/*  230	*/
    GLYPH_parenleftex,		/*  231	*/
    GLYPH_parenleftbt,		/*  232	*/
    GLYPH_bracketlefttp,	/*  233	*/
    GLYPH_bracketleftex,	/*  234	*/
    GLYPH_bracketleftbt,	/*  235	*/
    GLYPH_bracelefttp,		/*  236	*/
    GLYPH_braceleftmid,		/*  237	*/
    GLYPH_braceleftbt,		/*  238	*/
    GLYPH_braceex,		/*  239	*/
    (char *)0,			/*  240	*/
    GLYPH_angleright,		/*  241	*/
    GLYPH_integral,		/*  242	*/
    GLYPH_integraltp,		/*  243	*/
    GLYPH_integralex,		/*  244	*/
    GLYPH_integralbt,		/*  245	*/
    GLYPH_parenrighttp,		/*  246	*/
    GLYPH_parenrightex,		/*  247	*/
    GLYPH_parenrightbt,		/*  248	*/
    GLYPH_bracketrighttp,	/*  249	*/
    GLYPH_bracketrightex,	/*  250	*/
    GLYPH_bracketrightbt,	/*  251	*/
    GLYPH_bracerighttp,		/*  252	*/
    GLYPH_bracerightmid,	/*  253	*/
    GLYPH_bracerightbt,		/*  254	*/
    (char *)0,			/*  255	*/
    };

/************************************************************************/
/*									*/
/*  ISO Latin2 (ISO 8859-2) to postscript glyph names.			*/
/*									*/
/************************************************************************/

const char *	psIsoLatin2GlyphNames[256]=
    {
    (char *)0,			/*  nul		0	*/
    (char *)0,			/*  soh		1	*/
    (char *)0,			/*  stx		2	*/
    (char *)0,			/*  etx		3	*/
    (char *)0,			/*  eot		4	*/
    (char *)0,			/*  enq		5	*/
    (char *)0,			/*  ack		6	*/
    (char *)0,			/*  bel		7	*/
    (char *)0,			/*  bs		8	*/
    (char *)0,			/*  ht		9	*/
    (char *)0,			/*  nl		10	*/
    (char *)0,			/*  vt		11	*/
    (char *)0,			/*  np		12	*/
    (char *)0,			/*  cr		13	*/
    (char *)0,			/*  so		14	*/
    (char *)0,			/*  si		15	*/
    (char *)0,			/*  dle		16	*/
    (char *)0,			/*  dc1		17	*/
    (char *)0,			/*  dc2		18	*/
    (char *)0,			/*  dc3		19	*/
    (char *)0,			/*  dc4		20	*/
    (char *)0,			/*  nak		21	*/
    (char *)0,			/*  syn		22	*/
    (char *)0,			/*  etb		23	*/
    (char *)0,			/*  can		24	*/
    (char *)0,			/*  em		25	*/
    (char *)0,			/*  sub		26	*/
    (char *)0,			/*  esc		27	*/
    (char *)0,			/*  fs		28	*/
    (char *)0,			/*  gs		29	*/
    (char *)0,			/*  rs		30	*/
    (char *)0,			/*  us		31	*/
    GLYPH_space,		/*  32			*/
    GLYPH_exclam,		/*  33			*/
    GLYPH_quotedbl,		/*  34			*/
    GLYPH_numbersign,		/*  35			*/
    GLYPH_dollar,		/*  36			*/
    GLYPH_percent,		/*  37			*/
    GLYPH_ampersand,		/*  38			*/
    GLYPH_quoteright,		/*  39			*/
    GLYPH_parenleft,		/*  40			*/
    GLYPH_parenright,		/*  41			*/
    GLYPH_asterisk,		/*  42			*/
    GLYPH_plus,			/*  43			*/
    GLYPH_comma,		/*  44			*/
    GLYPH_minus,		/*  45			*/
    GLYPH_period,		/*  46			*/
    GLYPH_slash,		/*  47			*/
    GLYPH_zero,			/*  48			*/
    GLYPH_one,			/*  49			*/
    GLYPH_two,			/*  50			*/
    GLYPH_three,		/*  51			*/
    GLYPH_four,			/*  52			*/
    GLYPH_five,			/*  53			*/
    GLYPH_six,			/*  54			*/
    GLYPH_seven,		/*  55			*/
    GLYPH_eight,		/*  56			*/
    GLYPH_nine,			/*  57			*/
    GLYPH_colon,		/*  58			*/
    GLYPH_semicolon,		/*  59			*/
    GLYPH_less,			/*  60			*/
    GLYPH_equal,		/*  61			*/
    GLYPH_greater,		/*  62			*/
    GLYPH_question,		/*  63			*/
    GLYPH_at,			/*  64			*/
    GLYPH_A,			/*  65			*/
    GLYPH_B,			/*  66			*/
    GLYPH_C,			/*  67			*/
    GLYPH_D,			/*  68			*/
    GLYPH_E,			/*  69			*/
    GLYPH_F,			/*  70			*/
    GLYPH_G,			/*  71			*/
    GLYPH_H,			/*  72			*/
    GLYPH_I,			/*  73			*/
    GLYPH_J,			/*  74			*/
    GLYPH_K,			/*  75			*/
    GLYPH_L,			/*  76			*/
    GLYPH_M,			/*  77			*/
    GLYPH_N,			/*  78			*/
    GLYPH_O,			/*  79			*/
    GLYPH_P,			/*  80			*/
    GLYPH_Q,			/*  81			*/
    GLYPH_R,			/*  82			*/
    GLYPH_S,			/*  83			*/
    GLYPH_T,			/*  84			*/
    GLYPH_U,			/*  85			*/
    GLYPH_V,			/*  86			*/
    GLYPH_W,			/*  87			*/
    GLYPH_X,			/*  88			*/
    GLYPH_Y,			/*  89			*/
    GLYPH_Z,			/*  90			*/
    GLYPH_bracketleft,		/*  91			*/
    GLYPH_backslash,		/*  92			*/
    GLYPH_bracketright,		/*  93			*/
    GLYPH_asciicircum,		/*  94			*/
    GLYPH_underscore,		/*  95			*/
    GLYPH_quoteleft,		/*  96			*/
    GLYPH_a,			/*  97			*/
    GLYPH_b,			/*  98			*/
    GLYPH_c,			/*  99			*/
    GLYPH_d,			/*  100			*/
    GLYPH_e,			/*  101			*/
    GLYPH_f,			/*  102			*/
    GLYPH_g,			/*  103			*/
    GLYPH_h,			/*  104			*/
    GLYPH_i,			/*  105			*/
    GLYPH_j,			/*  106			*/
    GLYPH_k,			/*  107			*/
    GLYPH_l,			/*  108			*/
    GLYPH_m,			/*  109			*/
    GLYPH_n,			/*  110			*/
    GLYPH_o,			/*  111			*/
    GLYPH_p,			/*  112			*/
    GLYPH_q,			/*  113			*/
    GLYPH_r,			/*  114			*/
    GLYPH_s,			/*  115			*/
    GLYPH_t,			/*  116			*/
    GLYPH_u,			/*  117			*/
    GLYPH_v,			/*  118			*/
    GLYPH_w,			/*  119			*/
    GLYPH_x,			/*  120			*/
    GLYPH_y,			/*  121			*/
    GLYPH_z,			/*  122			*/
    GLYPH_braceleft,		/*  123			*/
    GLYPH_bar,			/*  124			*/
    GLYPH_braceright,		/*  125			*/
    GLYPH_asciitilde,		/*  126			*/
    (char *)0,			/*  127			*/
    (char *)0,			/*  128			*/
    (char *)0,			/*  129			*/
    (char *)0,			/*  130			*/
    (char *)0,			/*  131			*/
    (char *)0,			/*  132			*/
    (char *)0,			/*  133			*/
    (char *)0,			/*  134			*/
    (char *)0,			/*  135			*/
    (char *)0,			/*  136			*/
    (char *)0,			/*  137			*/
    (char *)0,			/*  138			*/
    (char *)0,			/*  139			*/
    (char *)0,			/*  140			*/
    (char *)0,			/*  141			*/
    (char *)0,			/*  142			*/
    (char *)0,			/*  143			*/
    (char *)0,			/*  dotlessi 144	*/
    (char *)0,			/*  grave 145		*/
    (char *)0,			/*  acute 146		*/
    (char *)0,			/*  circumflex 147	*/
    (char *)0,			/*  tilde 148		*/
    (char *)0,			/*  macron 149		*/
    (char *)0,			/*  breve 150		*/
    (char *)0,			/*  dotaccent 151	*/
    (char *)0,			/*  dieresis 152	*/
    (char *)0,			/*  153			*/
    (char *)0,			/*  ring 154		*/
    (char *)0,			/*  cedilla 155		*/
    (char *)0,			/*  156			*/
    (char *)0,			/*  hungarumlaut 157	*/
    (char *)0,			/*  ogonek 158		*/
    (char *)0,			/*  caron 159		*/
    GLYPH_nobreakspace,		/*  nobreakspace 160	*/
    GLYPH_Aogonek,		/*  161= 0xa1		*/
    GLYPH_breve,		/*  162= 0xa2		*/
    GLYPH_Lslash,		/*  163= 0xa3		*/
    (char *)0,			/*  GLYPH_currency  164	*//* often missing */
    GLYPH_Lcaron,		/*  165= 0xa5		*/
    GLYPH_Sacute,		/*  166= 0xa6		*/
    GLYPH_section,		/*  167			*/
    GLYPH_dieresis,		/*  168			*/
    GLYPH_Scaron,		/*  169= 0xa9		*/
    GLYPH_Scedilla,		/*  170= 0xaa		*/
    GLYPH_Tcaron,		/*  171= 0xab		*/
    GLYPH_Zacute,		/*  172= 0xac		*/
    GLYPH_hyphen,		/*  173			*/
    GLYPH_Zcaron,		/*  174= 0xae		*/
    GLYPH_Zdotaccent,		/*  175= 0xaf		*/
    GLYPH_degree,		/*  176			*/
    GLYPH_aogonek,		/*  177= 0xb1		*/
    GLYPH_ogonek,		/*  178= 0xb2		*/
    GLYPH_lslash,		/*  179= 0xb3		*/
    GLYPH_acute,		/*  180			*/
    GLYPH_lcaron,		/*  181= 0xb5		*/
    GLYPH_sacute,		/*  182= 0xb6		*/
    GLYPH_caron,		/*  183= 0xb7		*/
    GLYPH_cedilla,		/*  184			*/
    GLYPH_scaron,		/*  185= 0xb9		*/
    GLYPH_scedilla,		/*  186= 0xba		*/
    GLYPH_tcaron,		/*  187= 0xbb		*/
    GLYPH_zacute,		/*  188= 0xbc		*/
    GLYPH_hungarumlaut,		/*  189= 0xbd		*/
    GLYPH_zcaron,		/*  190= 0xbe		*/
    GLYPH_zdotaccent,		/*  191= 0xbf		*/
    GLYPH_Racute,		/*  192= 0xc0		*/
    GLYPH_Aacute,		/*  193			*/
    GLYPH_Acircumflex,		/*  194			*/
    GLYPH_Abreve,		/*  195= 0xc3		*/
    GLYPH_Adieresis,		/*  196			*/
    GLYPH_Lacute,		/*  197= 0xc5		*/
    GLYPH_Cacute,		/*  198= 0xc6		*/
    GLYPH_Ccedilla,		/*  199			*/
    GLYPH_Ccaron,		/*  200= 0xc8		*/
    GLYPH_Eacute,		/*  201			*/
    GLYPH_Eogonek,		/*  202= 0xca		*/
    GLYPH_Edieresis,		/*  203			*/
    GLYPH_Ecaron,		/*  204= 0xcc		*/
    GLYPH_Iacute,		/*  205			*/
    GLYPH_Icircumflex,		/*  206			*/
    GLYPH_Dcaron,		/*  207= 0xcf		*/
    GLYPH_Dcroat,		/*  208= 0xd0		*/
    GLYPH_Nacute,		/*  209= 0xd1		*/
    GLYPH_Ncaron,		/*  210= 0xd2		*/
    GLYPH_Oacute,		/*  211			*/
    GLYPH_Ocircumflex,		/*  212			*/
    GLYPH_Ohungarumlaut,	/*  213= 0xd5		*/
    GLYPH_Odieresis,		/*  214			*/
    GLYPH_multiply,		/*  215			*/
    GLYPH_Rcaron,		/*  216= 0xd8		*/
    GLYPH_Uring,		/*  217= 0xd9		*/
    GLYPH_Uacute,		/*  218			*/
    GLYPH_Uhungarumlaut,	/*  219= 0xdb		*/
    GLYPH_Udieresis,		/*  220			*/
    GLYPH_Yacute,		/*  221			*/
    GLYPH_Tcedilla,		/*  222= 0xde		*/
    GLYPH_germandbls,		/*  223			*/
    GLYPH_racute,		/*  224= 0xe0		*/
    GLYPH_aacute,		/*  225			*/
    GLYPH_acircumflex,		/*  226			*/
    GLYPH_abreve,		/*  227= 0xe3		*/
    GLYPH_adieresis,		/*  228			*/
    GLYPH_lacute,		/*  229= 0xe5		*/
    GLYPH_cacute,		/*  230= 0xe6		*/
    GLYPH_ccedilla,		/*  231			*/
    GLYPH_ccaron,		/*  232= 0xe8		*/
    GLYPH_eacute,		/*  233			*/
    GLYPH_eogonek,		/*  234= 0xea		*/
    GLYPH_edieresis,		/*  235			*/
    GLYPH_ecaron,		/*  236= 0xec		*/
    GLYPH_iacute,		/*  237			*/
    GLYPH_icircumflex,		/*  238			*/
    GLYPH_dcaron,		/*  239= 0xef		*/
    GLYPH_dcroat,		/*  240= 0xf0		*/
    GLYPH_nacute,		/*  241= 0xf1		*/
    GLYPH_ncaron,		/*  242= 0xf2		*/
    GLYPH_oacute,		/*  243			*/
    GLYPH_ocircumflex,		/*  244			*/
    GLYPH_ohungarumlaut,	/*  245= 0xf5		*/
    GLYPH_odieresis,		/*  246			*/
    (char *)0,			/*  GLYPH_divide  247	*//* often missing */
    GLYPH_rcaron,		/*  248= 0xf8		*/
    GLYPH_uring,		/*  249= 0xf9		*/
    GLYPH_uacute,		/*  250			*/
    GLYPH_uhungarumlaut,	/*  251= 0xfb		*/
    GLYPH_udieresis,		/*  252			*/
    GLYPH_yacute,		/*  253			*/
    GLYPH_tcedilla,		/*  254= 0xfe		*/
    GLYPH_dotaccent,		/*  255= 0xff		*/
    };

/************************************************************************/
/*									*/
/*  Adobe Cyrillic Encoding to postscript glyph names.			*/
/*									*/
/************************************************************************/

const char *	psCyrillicGlyphNames[256]=
    {
    (char *)0,			/*  0x00=   0  */
    (char *)0,			/*  0x01=   1  */
    (char *)0,			/*  0x02=   2  */
    (char *)0,			/*  0x03=   3  */
    (char *)0,			/*  0x04=   4  */
    (char *)0,			/*  0x05=   5  */
    (char *)0,			/*  0x06=   6  */
    (char *)0,			/*  0x07=   7  */
    (char *)0,			/*  0x08=   8  */
    (char *)0,			/*  0x09=   9  */
    (char *)0,			/*  0x0a=  10  */
    (char *)0,			/*  0x0b=  11  */
    (char *)0,			/*  0x0c=  12  */
    (char *)0,			/*  0x0d=  13  */
    (char *)0,			/*  0x0e=  14  */
    (char *)0,			/*  0x0f=  15  */
    (char *)0,			/*  0x10=  16  */
    (char *)0,			/*  0x11=  17  */
    (char *)0,			/*  0x12=  18  */
    (char *)0,			/*  0x13=  19  */
    (char *)0,			/*  0x14=  20  */
    (char *)0,			/*  0x15=  21  */
    (char *)0,			/*  0x16=  22  */
    (char *)0,			/*  0x17=  23  */
    (char *)0,			/*  0x18=  24  */
    (char *)0,			/*  0x19=  25  */
    (char *)0,			/*  0x1a=  26  */
    (char *)0,			/*  0x1b=  27  */
    (char *)0,			/*  0x1c=  28  */
    (char *)0,			/*  0x1d=  29  */
    (char *)0,			/*  0x1e=  30  */
    (char *)0,			/*  0x1f=  31  */
    GLYPH_space,		/*  0x20=  32  */
    GLYPH_exclam,		/*  0x21=  33  */
    GLYPH_quotedbl,		/*  0x22=  34  */
    GLYPH_numbersign,		/*  0x23=  35  */
    GLYPH_dollar,		/*  0x24=  36  */
    GLYPH_percent,		/*  0x25=  37  */
    GLYPH_ampersand,		/*  0x26=  38  */
    GLYPH_quotesingle,		/*  0x27=  39  */
    GLYPH_parenleft,		/*  0x28=  40  */
    GLYPH_parenright,		/*  0x29=  41  */
    GLYPH_asterisk,		/*  0x2a=  42  */
    GLYPH_plus,			/*  0x2b=  43  */
    GLYPH_comma,		/*  0x2c=  44  */
    GLYPH_hyphen,		/*  0x2d=  45  */
    GLYPH_period,		/*  0x2e=  46  */
    GLYPH_slash,		/*  0x2f=  47  */
    GLYPH_zero,			/*  0x30=  48  */
    GLYPH_one,			/*  0x31=  49  */
    GLYPH_two,			/*  0x32=  50  */
    GLYPH_three,		/*  0x33=  51  */
    GLYPH_four,			/*  0x34=  52  */
    GLYPH_five,			/*  0x35=  53  */
    GLYPH_six,			/*  0x36=  54  */
    GLYPH_seven,		/*  0x37=  55  */
    GLYPH_eight,		/*  0x38=  56  */
    GLYPH_nine,			/*  0x39=  57  */
    GLYPH_colon,		/*  0x3a=  58  */
    GLYPH_semicolon,		/*  0x3b=  59  */
    GLYPH_less,			/*  0x3c=  60  */
    GLYPH_equal,		/*  0x3d=  61  */
    GLYPH_greater,		/*  0x3e=  62  */
    GLYPH_question,		/*  0x3f=  63  */
    GLYPH_at,			/*  0x40=  64  */
    GLYPH_A,			/*  0x41=  65  */
    GLYPH_B,			/*  0x42=  66  */
    GLYPH_C,			/*  0x43=  67  */
    GLYPH_D,			/*  0x44=  68  */
    GLYPH_E,			/*  0x45=  69  */
    GLYPH_F,			/*  0x46=  70  */
    GLYPH_G,			/*  0x47=  71  */
    GLYPH_H,			/*  0x48=  72  */
    GLYPH_I,			/*  0x49=  73  */
    GLYPH_J,			/*  0x4a=  74  */
    GLYPH_K,			/*  0x4b=  75  */
    GLYPH_L,			/*  0x4c=  76  */
    GLYPH_M,			/*  0x4d=  77  */
    GLYPH_N,			/*  0x4e=  78  */
    GLYPH_O,			/*  0x4f=  79  */
    GLYPH_P,			/*  0x50=  80  */
    GLYPH_Q,			/*  0x51=  81  */
    GLYPH_R,			/*  0x52=  82  */
    GLYPH_S,			/*  0x53=  83  */
    GLYPH_T,			/*  0x54=  84  */
    GLYPH_U,			/*  0x55=  85  */
    GLYPH_V,			/*  0x56=  86  */
    GLYPH_W,			/*  0x57=  87  */
    GLYPH_X,			/*  0x58=  88  */
    GLYPH_Y,			/*  0x59=  89  */
    GLYPH_Z,			/*  0x5a=  90  */
    GLYPH_bracketleft,		/*  0x5b=  91  */
    GLYPH_backslash,		/*  0x5c=  92  */
    GLYPH_bracketright,		/*  0x5d=  93  */
    GLYPH_asciicircum,		/*  0x5e=  94  */
    GLYPH_underscore,		/*  0x5f=  95  */
    GLYPH_grave,		/*  0x60=  96  */
    GLYPH_a,			/*  0x61=  97  */
    GLYPH_b,			/*  0x62=  98  */
    GLYPH_c,			/*  0x63=  99  */
    GLYPH_d,			/*  0x64= 100  */
    GLYPH_e,			/*  0x65= 101  */
    GLYPH_f,			/*  0x66= 102  */
    GLYPH_g,			/*  0x67= 103  */
    GLYPH_h,			/*  0x68= 104  */
    GLYPH_i,			/*  0x69= 105  */
    GLYPH_j,			/*  0x6a= 106  */
    GLYPH_k,			/*  0x6b= 107  */
    GLYPH_l,			/*  0x6c= 108  */
    GLYPH_m,			/*  0x6d= 109  */
    GLYPH_n,			/*  0x6e= 110  */
    GLYPH_o,			/*  0x6f= 111  */
    GLYPH_p,			/*  0x70= 112  */
    GLYPH_q,			/*  0x71= 113  */
    GLYPH_r,			/*  0x72= 114  */
    GLYPH_s,			/*  0x73= 115  */
    GLYPH_t,			/*  0x74= 116  */
    GLYPH_u,			/*  0x75= 117  */
    GLYPH_v,			/*  0x76= 118  */
    GLYPH_w,			/*  0x77= 119  */
    GLYPH_x,			/*  0x78= 120  */
    GLYPH_y,			/*  0x79= 121  */
    GLYPH_z,			/*  0x7a= 122  */
    GLYPH_braceleft,		/*  0x7b= 123  */
    GLYPH_bar,			/*  0x7c= 124  */
    GLYPH_braceright,		/*  0x7d= 125  */
    GLYPH_asciitilde,		/*  0x7e= 126  */
    (char *)0,			/*  0x7f= 127  */
    GLYPH_afii10051,		/*  0x80= 128  */
    GLYPH_afii10052,		/*  0x81= 129  */
    GLYPH_quotesinglbase,	/*  0x82= 130  */
    GLYPH_afii10100,		/*  0x83= 131  */
    GLYPH_quotedblbase,		/*  0x84= 132  */
    GLYPH_ellipsis,		/*  0x85= 133  */
    GLYPH_dagger,		/*  0x86= 134  */
    GLYPH_daggerdbl,		/*  0x87= 135  */
    (char *)0,			/*  0x88= 136  */
    GLYPH_perthousand,		/*  0x89= 137  */
    GLYPH_afii10058,		/*  0x8a= 138  */
    GLYPH_guilsinglleft,	/*  0x8b= 139  */
    GLYPH_afii10059,		/*  0x8c= 140  */
    GLYPH_afii10061,		/*  0x8d= 141  */
    GLYPH_afii10060,		/*  0x8e= 142  */
    GLYPH_afii10145,		/*  0x8f= 143  */
    GLYPH_afii10099,		/*  0x90= 144  */
    GLYPH_quoteleft,		/*  0x91= 145  */
    GLYPH_quoteright,		/*  0x92= 146  */
    GLYPH_quotedblleft,		/*  0x93= 147  */
    GLYPH_quotedblright,	/*  0x94= 148  */
    GLYPH_bullet,		/*  0x95= 149  */
    GLYPH_endash,		/*  0x96= 150  */
    GLYPH_emdash,		/*  0x97= 151  */
    (char *)0,			/*  0x98= 152  */
    GLYPH_trademark,		/*  0x99= 153  */
    GLYPH_afii10106,		/*  0x9a= 154  */
    GLYPH_guilsinglright,	/*  0x9b= 155  */
    GLYPH_afii10107,		/*  0x9c= 156  */
    GLYPH_afii10109,		/*  0x9d= 157  */
    GLYPH_afii10108,		/*  0x9e= 158  */
    GLYPH_afii10193,		/*  0x9f= 159  */
    GLYPH_space,		/*  0xa0= 160  */
    GLYPH_afii10062,		/*  0xa1= 161  */
    GLYPH_afii10110,		/*  0xa2= 162  */
    GLYPH_afii10057,		/*  0xa3= 163  */
    GLYPH_currency,		/*  0xa4= 164  */
    GLYPH_afii10050,		/*  0xa5= 165  */
    GLYPH_brokenbar,		/*  0xa6= 166  */
    GLYPH_section,		/*  0xa7= 167  */
    GLYPH_afii10023,		/*  0xa8= 168  */
    GLYPH_copyright,		/*  0xa9= 169  */
    GLYPH_afii10053,		/*  0xaa= 170  */
    GLYPH_guillemotleft,	/*  0xab= 171  */
    GLYPH_logicalnot,		/*  0xac= 172  */
    GLYPH_hyphen,		/*  0xad= 173  */
    GLYPH_registered,		/*  0xae= 174  */
    GLYPH_afii10056,		/*  0xaf= 175  */
    GLYPH_degree,		/*  0xb0= 176  */
    GLYPH_plusminus,		/*  0xb1= 177  */
    GLYPH_afii10055,		/*  0xb2= 178  */
    GLYPH_afii10103,		/*  0xb3= 179  */
    GLYPH_afii10098,		/*  0xb4= 180  */
    GLYPH_mu,			/*  0xb5= 181  */
    GLYPH_paragraph,		/*  0xb6= 182  */
    GLYPH_periodcentered,	/*  0xb7= 183  */
    GLYPH_afii10071,		/*  0xb8= 184  */
    GLYPH_afii61352,		/*  0xb9= 185  */
    GLYPH_afii10101,		/*  0xba= 186  */
    GLYPH_guillemotright,	/*  0xbb= 187  */
    GLYPH_afii10105,		/*  0xbc= 188  */
    GLYPH_afii10054,		/*  0xbd= 189  */
    GLYPH_afii10102,		/*  0xbe= 190  */
    GLYPH_afii10104,		/*  0xbf= 191  */
    GLYPH_afii10017,		/*  0xc0= 192  */
    GLYPH_afii10018,		/*  0xc1= 193  */
    GLYPH_afii10019,		/*  0xc2= 194  */
    GLYPH_afii10020,		/*  0xc3= 195  */
    GLYPH_afii10021,		/*  0xc4= 196  */
    GLYPH_afii10022,		/*  0xc5= 197  */
    GLYPH_afii10024,		/*  0xc6= 198  */
    GLYPH_afii10025,		/*  0xc7= 199  */
    GLYPH_afii10026,		/*  0xc8= 200  */
    GLYPH_afii10027,		/*  0xc9= 201  */
    GLYPH_afii10028,		/*  0xca= 202  */
    GLYPH_afii10029,		/*  0xcb= 203  */
    GLYPH_afii10030,		/*  0xcc= 204  */
    GLYPH_afii10031,		/*  0xcd= 205  */
    GLYPH_afii10032,		/*  0xce= 206  */
    GLYPH_afii10033,		/*  0xcf= 207  */
    GLYPH_afii10034,		/*  0xd0= 208  */
    GLYPH_afii10035,		/*  0xd1= 209  */
    GLYPH_afii10036,		/*  0xd2= 210  */
    GLYPH_afii10037,		/*  0xd3= 211  */
    GLYPH_afii10038,		/*  0xd4= 212  */
    GLYPH_afii10039,		/*  0xd5= 213  */
    GLYPH_afii10040,		/*  0xd6= 214  */
    GLYPH_afii10041,		/*  0xd7= 215  */
    GLYPH_afii10042,		/*  0xd8= 216  */
    GLYPH_afii10043,		/*  0xd9= 217  */
    GLYPH_afii10044,		/*  0xda= 218  */
    GLYPH_afii10045,		/*  0xdb= 219  */
    GLYPH_afii10046,		/*  0xdc= 220  */
    GLYPH_afii10047,		/*  0xdd= 221  */
    GLYPH_afii10048,		/*  0xde= 222  */
    GLYPH_afii10049,		/*  0xdf= 223  */
    GLYPH_afii10065,		/*  0xe0= 224  */
    GLYPH_afii10066,		/*  0xe1= 225  */
    GLYPH_afii10067,		/*  0xe2= 226  */
    GLYPH_afii10068,		/*  0xe3= 227  */
    GLYPH_afii10069,		/*  0xe4= 228  */
    GLYPH_afii10070,		/*  0xe5= 229  */
    GLYPH_afii10072,		/*  0xe6= 230  */
    GLYPH_afii10073,		/*  0xe7= 231  */
    GLYPH_afii10074,		/*  0xe8= 232  */
    GLYPH_afii10075,		/*  0xe9= 233  */
    GLYPH_afii10076,		/*  0xea= 234  */
    GLYPH_afii10077,		/*  0xeb= 235  */
    GLYPH_afii10078,		/*  0xec= 236  */
    GLYPH_afii10079,		/*  0xed= 237  */
    GLYPH_afii10080,		/*  0xee= 238  */
    GLYPH_afii10081,		/*  0xef= 239  */
    GLYPH_afii10082,		/*  0xf0= 240  */
    GLYPH_afii10083,		/*  0xf1= 241  */
    GLYPH_afii10084,		/*  0xf2= 242  */
    GLYPH_afii10085,		/*  0xf3= 243  */
    GLYPH_afii10086,		/*  0xf4= 244  */
    GLYPH_afii10087,		/*  0xf5= 245  */
    GLYPH_afii10088,		/*  0xf6= 246  */
    GLYPH_afii10089,		/*  0xf7= 247  */
    GLYPH_afii10090,		/*  0xf8= 248  */
    GLYPH_afii10091,		/*  0xf9= 249  */
    GLYPH_afii10092,		/*  0xfa= 250  */
    GLYPH_afii10093,		/*  0xfb= 251  */
    GLYPH_afii10094,		/*  0xfc= 252  */
    GLYPH_afii10095,		/*  0xfd= 253  */
    GLYPH_afii10096,		/*  0xfe= 254  */
    GLYPH_afii10097,		/*  0xff= 255  */
    };

/************************************************************************/
/*									*/
/*  Alternate glyphs or glyph names as I have encontered them in	*/
/*  actual afm files.							*/
/*									*/
/*  The mapping og "nobreakspace" to "space" is a hack to use this	*/
/*  mechanism to find the match between the latin* encodings and	*/
/*									*/
/************************************************************************/

const AlternateGlyphName PS_AlternateNames[]=
    {
	{ GLYPH_nobreakspace,		GLYPH_space		},

	{ GLYPH_quoteright,		GLYPH_apostrophe	},
	{ GLYPH_minus,			GLYPH_hyphen		},
	{ GLYPH_period,			GLYPH_fullstop		},
	{ GLYPH_underscore,		GLYPH_lowline		},
	{ GLYPH_quoteleft,		GLYPH_grave		},

	{ GLYPH_Lslash,			GLYPH_Lstroke		},
	{ GLYPH_dieresis,		GLYPH_diaeresis		},
	{ GLYPH_Zdotaccent,		GLYPH_Zabovedot		},
	{ GLYPH_lslash,			GLYPH_lstroke		},
	{ GLYPH_hungarumlaut,		GLYPH_doubleacute	},
	{ GLYPH_zdotaccent,		GLYPH_zabovedot		},
	{ GLYPH_Adieresis,		GLYPH_Adiaeresis	},
	{ GLYPH_Edieresis,		GLYPH_Ediaeresis	},
	{ GLYPH_Dcroat,			GLYPH_Dstroke		},
	{ GLYPH_Ohungarumlaut,		GLYPH_Odoubleacute	},
	{ GLYPH_Odieresis,		GLYPH_Odiaeresis	},
	{ GLYPH_Uhungarumlaut,		GLYPH_Udoubleacute	},
	{ GLYPH_Udieresis,		GLYPH_Udiaeresis	},
	{ GLYPH_germandbls,		GLYPH_ssharp		},
	{ GLYPH_adieresis,		GLYPH_adiaeresis	},
	{ GLYPH_edieresis,		GLYPH_ediaeresis	},
	{ GLYPH_dcroat,			GLYPH_dstroke		},
	{ GLYPH_ohungarumlaut,		GLYPH_odoubleacute	},
	{ GLYPH_odieresis,		GLYPH_odiaeresis	},
	{ GLYPH_divide,			GLYPH_division		},
	{ GLYPH_uhungarumlaut,		GLYPH_udoubleacute	},
	{ GLYPH_udieresis,		GLYPH_udiaeresis	},
	{ GLYPH_dotaccent,		GLYPH_abovedot		},

	{ GLYPH_tcedilla,		GLYPH_tcommaaccent	},
	{ GLYPH_Tcedilla,		GLYPH_Tcommaaccent	},

	{ (char *)0,			(char *)0	}
    };

/************************************************************************/
/*									*/
/*  Character set mapping tables.					*/
/*									*/
/************************************************************************/

const unsigned char docWIN1250_to_ISO2[256]=
    {
    ISO2__nul,			/*	WIN1250__nul		0	*/
    ISO2__soh,			/*	WIN1250__soh		1	*/
    ISO2__stx,			/*	WIN1250__stx		2	*/
    ISO2__etx,			/*	WIN1250__etx		3	*/
    ISO2__eot,			/*	WIN1250__eot		4	*/
    ISO2__enq,			/*	WIN1250__enq		5	*/
    ISO2__ack,			/*	WIN1250__ack		6	*/
    ISO2__bel,			/*	WIN1250__bel		7	*/
    ISO2__bs,			/*	WIN1250__bs		8	*/
    ISO2__ht,			/*	WIN1250__ht		9	*/
    ISO2__nl,			/*	WIN1250__nl		10	*/
    ISO2__vt,			/*	WIN1250__vt		11	*/
    ISO2__np,			/*	WIN1250__np		12	*/
    ISO2__cr,			/*	WIN1250__cr		13	*/
    ISO2__so,			/*	WIN1250__so		14	*/
    ISO2__si,			/*	WIN1250__si		15	*/
    ISO2__dle,			/*	WIN1250__dle		16	*/
    ISO2__dc1,			/*	WIN1250__dc1		17	*/
    ISO2__dc2,			/*	WIN1250__dc2		18	*/
    ISO2__dc3,			/*	WIN1250__dc3		19	*/
    ISO2__dc4,			/*	WIN1250__dc4		20	*/
    ISO2__nak,			/*	WIN1250__nak		21	*/
    ISO2__syn,			/*	WIN1250__syn		22	*/
    ISO2__etb,			/*	WIN1250__etb		23	*/
    ISO2__can,			/*	WIN1250__can		24	*/
    ISO2__em,			/*	WIN1250__em		25	*/
    ISO2__sub,			/*	WIN1250__sub		26	*/
    ISO2__esc,			/*	WIN1250__esc		27	*/
    ISO2__fs,			/*	WIN1250__fs		28	*/
    ISO2__gs,			/*	WIN1250__gs		29	*/
    ISO2__rs,			/*	WIN1250__rs		30	*/
    ISO2__us,			/*	WIN1250__us		31	*/

    ISO2_space,			/*	WIN1250_space		32	*/
    ISO2_exclam,		/*	WIN1250_exclam		33	*/
    ISO2_quotedbl,		/*	WIN1250_quotedbl	34	*/
    ISO2_numbersign,		/*	WIN1250_numbersign	35	*/
    ISO2_dollar,		/*	WIN1250_dollar		36	*/
    ISO2_percent,		/*	WIN1250_percent		37	*/
    ISO2_ampersand,		/*	WIN1250_ampersand	38	*/
    ISO2_quoteright,		/*	WIN1250_quoteright	39	*/
    ISO2_parenleft,		/*	WIN1250_parenleft	40	*/
    ISO2_parenright,		/*	WIN1250_parenright	41	*/
    ISO2_asterisk,		/*	WIN1250_asterisk	42	*/
    ISO2_plus,			/*	WIN1250_plus		43	*/
    ISO2_comma,			/*	WIN1250_comma		44	*/
    ISO2_minus,			/*	WIN1250_minus		45	*/
    ISO2_period,		/*	WIN1250_period		46	*/
    ISO2_slash,			/*	WIN1250_slash		47	*/
    ISO2_zero,			/*	WIN1250_zero		48	*/
    ISO2_one,			/*	WIN1250_one		49	*/
    ISO2_two,			/*	WIN1250_two		50	*/
    ISO2_three,			/*	WIN1250_three		51	*/
    ISO2_four,			/*	WIN1250_four		52	*/
    ISO2_five,			/*	WIN1250_five		53	*/
    ISO2_six,			/*	WIN1250_six		54	*/
    ISO2_seven,			/*	WIN1250_seven		55	*/
    ISO2_eight,			/*	WIN1250_eight		56	*/
    ISO2_nine,			/*	WIN1250_nine		57	*/
    ISO2_colon,			/*	WIN1250_colon		58	*/
    ISO2_semicolon,		/*	WIN1250_semicolon	59	*/
    ISO2_less,			/*	WIN1250_less		60	*/
    ISO2_equal,			/*	WIN1250_equal		61	*/
    ISO2_greater,		/*	WIN1250_greater		62	*/
    ISO2_question,		/*	WIN1250_question	63	*/

    ISO2_at,			/*	WIN1250_at		64	*/
    ISO2_A,			/*	WIN1250_A		65	*/
    ISO2_B,			/*	WIN1250_B		66	*/
    ISO2_C,			/*	WIN1250_C		67	*/
    ISO2_D,			/*	WIN1250_D		68	*/
    ISO2_E,			/*	WIN1250_E		69	*/
    ISO2_F,			/*	WIN1250_F		70	*/
    ISO2_G,			/*	WIN1250_G		71	*/
    ISO2_H,			/*	WIN1250_H		72	*/
    ISO2_I,			/*	WIN1250_I		73	*/
    ISO2_J,			/*	WIN1250_J		74	*/
    ISO2_K,			/*	WIN1250_K		75	*/
    ISO2_L,			/*	WIN1250_L		76	*/
    ISO2_M,			/*	WIN1250_M		77	*/
    ISO2_N,			/*	WIN1250_N		78	*/
    ISO2_O,			/*	WIN1250_O		79	*/
    ISO2_P,			/*	WIN1250_P		80	*/
    ISO2_Q,			/*	WIN1250_Q		81	*/
    ISO2_R,			/*	WIN1250_R		82	*/
    ISO2_S,			/*	WIN1250_S		83	*/
    ISO2_T,			/*	WIN1250_T		84	*/
    ISO2_U,			/*	WIN1250_U		85	*/
    ISO2_V,			/*	WIN1250_V		86	*/
    ISO2_W,			/*	WIN1250_W		87	*/
    ISO2_X,			/*	WIN1250_X		88	*/
    ISO2_Y,			/*	WIN1250_Y		89	*/
    ISO2_Z,			/*	WIN1250_Z		90	*/

    ISO2_bracketleft,		/*	WIN1250_bracketleft	91	*/
    ISO2_backslash,		/*	WIN1250_backslash	92	*/
    ISO2_bracketright,		/*	WIN1250_bracketright	93	*/
    ISO2_circumflex,		/*	WIN1250_circumflex	94	*/
    ISO2_underscore,		/*	WIN1250_underscore	95	*/

    ISO2_quoteleft,		/*	WIN1250_quoteleft	96	*/
    ISO2_a,			/*	WIN1250_a		97	*/
    ISO2_b,			/*	WIN1250_b		98	*/
    ISO2_c,			/*	WIN1250_c		99	*/
    ISO2_d,			/*	WIN1250_d		100	*/
    ISO2_e,			/*	WIN1250_e		101	*/
    ISO2_f,			/*	WIN1250_f		102	*/
    ISO2_g,			/*	WIN1250_g		103	*/
    ISO2_h,			/*	WIN1250_h		104	*/
    ISO2_i,			/*	WIN1250_i		105	*/
    ISO2_j,			/*	WIN1250_j		106	*/
    ISO2_k,			/*	WIN1250_k		107	*/
    ISO2_l,			/*	WIN1250_l		108	*/
    ISO2_m,			/*	WIN1250_m		109	*/
    ISO2_n,			/*	WIN1250_n		110	*/
    ISO2_o,			/*	WIN1250_o		111	*/
    ISO2_p,			/*	WIN1250_p		112	*/
    ISO2_q,			/*	WIN1250_q		113	*/
    ISO2_r,			/*	WIN1250_r		114	*/
    ISO2_s,			/*	WIN1250_s		115	*/
    ISO2_t,			/*	WIN1250_t		116	*/
    ISO2_u,			/*	WIN1250_u		117	*/
    ISO2_v,			/*	WIN1250_v		118	*/
    ISO2_w,			/*	WIN1250_w		119	*/
    ISO2_x,			/*	WIN1250_x		120	*/
    ISO2_y,			/*	WIN1250_y		121	*/
    ISO2_z,			/*	WIN1250_z		122	*/
    ISO2_braceleft,		/*	WIN1250_braceleft	123	*/
    ISO2_bar,			/*	WIN1250_bar		124	*/
    ISO2_braceright,		/*	WIN1250_braceright	125	*/
    ISO2_tilde,			/*	WIN1250_tilde		126	*/
    ISO2__del,			/*	WIN1250__del		127	*/

    128,			/*	WIN1250__0x80		128	*//**/
    129,			/*	WIN1250__0x81		129	*//**/
    ISO2_quoteleft,		/*	WIN1250_quotesinglbase	130	*//**/
    ISO2_f,			/*	WIN1250_florin		131	*//**/
    ISO2_quotedbl,		/*	WIN1250_quotedblbase	132	*//**/
    ISO2_hyphen,		/*	WIN1250_ellipsis	133	*//**/
    ISO2_currency,		/*	WIN1250_dagger		134	*//**/
    ISO2_currency,		/*	WIN1250_daggerdbl	135	*//**/
    ISO2_circumflex,		/*	WIN1250__circumflex_136	136	*//**/
    ISO2_currency,		/*	WIN1250_perthousand	137	*//**/
    ISO2_Scaron,		/*	WIN1250_Scaron		138	*/
    ISO2_quoteleft,		/*	WIN1250_guilsinglleft	139	*//**/
    ISO2_Sacute,		/*	WIN1250_Sacute		140	*/
    ISO2_Tcaron,		/*	WIN1250_Tcaron		141	*/
    ISO2_Zcaron,		/*	WIN1250_Zcaron		142	*/
    ISO2_Zacute,		/*	WIN1250_Zacute		143	*/
    144,			/*	WIN1250__0x90		144	*//**/
    ISO2_quoteleft,		/*	WIN1250__quoteleft_145	145	*//**/
    ISO2_quoteright,		/*	WIN1250__quoteright_146	146	*//**/
    ISO2_quotedbl,		/*	WIN1250_quotedblleft	147	*/
    ISO2_quotedbl,		/*	WIN1250_quotedblright	148	*/
    ISO2_currency,		/*	WIN1250_bullet		149	*//**/
    ISO2_hyphen,		/*	WIN1250_endash		150	*//**/
    ISO2_hyphen,		/*	WIN1250_emdash		151	*//**/
    ISO2_tilde,			/*	WIN1250__tilde_152	152	*//**/
    ISO2_currency,		/*	WIN1250_trademark	153	*//**/
    ISO2_scaron,		/*	WIN1250_scaron		154	*/
    ISO2_quoteright,		/*	WIN1250_guilsinglright	155	*//**/
    ISO2_sacute,		/*	WIN1250_sacute		156	*/
    ISO2_tcaron,		/*	WIN1250_tcaron		157	*/
    ISO2_zcaron,		/*	WIN1250_zcaron		158	*/
    ISO2_zacute,		/*	WIN1250_zacute		159	*/
    160,			/*	WIN1250__0xa0		160	*//**/
    ISO2_caron,			/*	WIN1250_caron		161	*/
    ISO2_breve,			/*	WIN1250_breve		162	*/
    ISO2_Lslash,		/*	WIN1250_Lslash		163	*/
    ISO2_currency,		/*	WIN1250_currency	164	*/
    ISO2_Aogonek,		/*	WIN1250_Aogonek		165	*/
    ISO2_bar,			/*	WIN1250_brokenbar	166	*//**/
    ISO2_section,		/*	WIN1250_section		167	*/
    ISO2_dieresis,		/*	WIN1250_dieresis	168	*/
    ISO2_currency,		/*	WIN1250_copyright	169	*//**/
    ISO2_Scedilla,		/*	WIN1250_Scedilla	170	*/
    ISO2_quoteleft,		/*	WIN1250_guillemotleft	171	*//**/
    ISO2_currency,		/*	WIN1250_logicalnot	172	*//**/
    ISO2_hyphen,		/*	WIN1250_hyphen		173	*/
    ISO2_currency,		/*	WIN1250_registered	174	*//**/
    ISO2_Zdotaccent,		/*	WIN1250_Zdotaccent	175	*/
    ISO2_degree,		/*	WIN1250_degree		176	*/
    ISO2_currency,		/*	WIN1250_plusminus	177	*/
    ISO2_ogonek,		/*	WIN1250_ogonek		178	*/
    ISO2_lslash,		/*	WIN1250_lslash		179	*/
    ISO2_acute,			/*	WIN1250_acute		180	*/
    ISO2_currency,		/*	WIN1250_mu		181	*//**/
    ISO2_currency,		/*	WIN1250_paragraph	182	*//**/
    ISO2_currency,		/*	WIN1250_periodcentered	183	*//**/
    ISO2_cedilla,		/*	WIN1250_cedilla		184	*/
    ISO2_aogonek,		/*	WIN1250_aogonek		185	*/
    ISO2_scedilla,		/*	WIN1250_scedilla	186	*/
    ISO2_quoteright,		/*	WIN1250_guillemotright	187	*//**/
    ISO2_Lcaron,		/*	WIN1250_Lcaron		188	*/
    ISO2_hungarumlaut,		/*	WIN1250_hungarumlaut	189	*/
    ISO2_lcaron,		/*	WIN1250_lcaron		190	*/
    ISO2_zdotaccent,		/*	WIN1250_zdotaccent	191	*/
    ISO2_Racute,		/*	WIN1250_Racute		192	*/
    ISO2_Aacute,		/*	WIN1250_Aacute		193	*/
    ISO2_Acircumflex,		/*	WIN1250_Acircumflex	194	*/
    ISO2_Abreve,		/*	WIN1250_Abreve		195	*/
    ISO2_Adieresis,		/*	WIN1250_Adieresis	195	*/
    ISO2_Lacute,		/*	WIN1250_Lacute		197	*/
    ISO2_Cacute,		/*	WIN1250_Cacute		198	*/
    ISO2_Ccedilla,		/*	WIN1250_Ccedilla	199	*/
    ISO2_Ccaron,		/*	WIN1250_Ccaron		200	*/
    ISO2_Eacute,		/*	WIN1250_Eacute		201	*/
    ISO2_Eogonek,		/*	WIN1250_Eogonek		202	*/
    ISO2_Edieresis,		/*	WIN1250_Edieresis	202	*/
    ISO2_Ecaron,		/*	WIN1250_Ecaron		204	*/
    ISO2_Iacute,		/*	WIN1250_Iacute		204	*/
    ISO2_Icircumflex,		/*	WIN1250_Icircumflex	204	*/
    ISO2_Dcaron,		/*	WIN1250_Dcaron		207	*/
    ISO2_Dcroat,		/*	WIN1250_Dcroat		208	*/
    ISO2_Nacute,		/*	WIN1250_Nacute		209	*/
    ISO2_Ncaron,		/*	WIN1250_Ncaron		210	*/
    ISO2_Oacute,		/*	WIN1250_Oacute		211	*/
    ISO2_Ocircumflex,		/*	WIN1250_Ocircumflex	212	*/
    ISO2_Ohungarumlaut,		/*	WIN1250_Ohungarumlaut	213	*/
    ISO2_Odieresis,		/*	WIN1250_Odieresis	214	*/
    ISO2_multiply,		/*	WIN1250_multiply	215	*/
    ISO2_Rcaron,		/*	WIN1250_Rcaron		216	*/
    ISO2_Uring,			/*	WIN1250_Uring		217	*/
    ISO2_Uacute,		/*	WIN1250_Uacute		218	*/
    ISO2_Uhungarumlaut,		/*	WIN1250_Uhungarumlaut	219	*/
    ISO2_Udieresis,		/*	WIN1250_Udieresis	220	*/
    ISO2_Yacute,		/*	WIN1250_Yacute		221	*/
    ISO2_Tcedilla,		/*	WIN1250_Tcedilla	222	*/
    ISO2_germandbls,		/*	WIN1250_germandbls	223	*/
    ISO2_racute,		/*	WIN1250_racute		224	*/
    ISO2_aacute,		/*	WIN1250_aacute		225	*/
    ISO2_acircumflex,		/*	WIN1250_acircumflex	226	*/
    ISO2_abreve,		/*	WIN1250_abreve		227	*/
    ISO2_adieresis,		/*	WIN1250_adieresis	228	*/
    ISO2_lacute,		/*	WIN1250_lacute		229	*/
    ISO2_cacute,		/*	WIN1250_cacute		230	*/
    ISO2_ccedilla,		/*	WIN1250_ccedilla	231	*/
    ISO2_ccaron,		/*	WIN1250_ccaron		232	*/
    ISO2_eacute,		/*	WIN1250_eacute		233	*/
    ISO2_eogonek,		/*	WIN1250_eogonek		234	*/
    ISO2_edieresis,		/*	WIN1250_edieresis	235	*/
    ISO2_ecaron,		/*	WIN1250_ecaron		236	*/
    ISO2_iacute,		/*	WIN1250_iacute		237	*/
    ISO2_icircumflex,		/*	WIN1250_icircumflex	238	*/
    ISO2_dcaron,		/*	WIN1250_dcaron		239	*/
    ISO2_dcroat,		/*	WIN1250_dcroat		240	*/
    ISO2_nacute,		/*	WIN1250_nacute		241	*/
    ISO2_ncaron,		/*	WIN1250_ncaron		242	*/
    ISO2_oacute,		/*	WIN1250_oacute		243	*/
    ISO2_ocircumflex,		/*	WIN1250_ocircumflex	244	*/
    ISO2_ohungarumlaut,		/*	WIN1250_ohungarumlaut	245	*/
    ISO2_odieresis,		/*	WIN1250_odieresis	246	*/
    ISO2_divide,		/*	WIN1250_divide		247	*/
    ISO2_rcaron,		/*	WIN1250_rcaron		248	*/
    ISO2_uring,			/*	WIN1250_uring		249	*/
    ISO2_uacute,		/*	WIN1250_uacute		250	*/
    ISO2_uhungarumlaut,		/*	WIN1250_uhungarumlaut	251	*/
    ISO2_udieresis,		/*	WIN1250_udieresis	252	*/
    ISO2_yacute,		/*	WIN1250_yacute		252	*/
    ISO2_tcedilla,		/*	WIN1250_tcedilla	254	*/
    ISO2_dotaccent,		/*	WIN1250_dotaccent	255	*/
    };

const unsigned char docISO2_to_WIN1250[256]=
    {
    WIN1250__nul,		/*	ISO2__nul		0	*/
    WIN1250__soh,		/*	ISO2__soh		1	*/
    WIN1250__stx,		/*	ISO2__stx		2	*/
    WIN1250__etx,		/*	ISO2__etx		3	*/
    WIN1250__eot,		/*	ISO2__eot		4	*/
    WIN1250__enq,		/*	ISO2__enq		5	*/
    WIN1250__ack,		/*	ISO2__ack		6	*/
    WIN1250__bel,		/*	ISO2__bel		7	*/
    WIN1250__bs,		/*	ISO2__bs		8	*/
    WIN1250__ht,		/*	ISO2__ht		9	*/
    WIN1250__nl,		/*	ISO2__nl		10	*/
    WIN1250__vt,		/*	ISO2__vt		11	*/
    WIN1250__np,		/*	ISO2__np		12	*/
    WIN1250__cr,		/*	ISO2__cr		13	*/
    WIN1250__so,		/*	ISO2__so		14	*/
    WIN1250__si,		/*	ISO2__si		15	*/
    WIN1250__dle,		/*	ISO2__dle		16	*/
    WIN1250__dc1,		/*	ISO2__dc1		17	*/
    WIN1250__dc2,		/*	ISO2__dc2		18	*/
    WIN1250__dc3,		/*	ISO2__dc3		19	*/
    WIN1250__dc4,		/*	ISO2__dc4		20	*/
    WIN1250__nak,		/*	ISO2__nak		21	*/
    WIN1250__syn,		/*	ISO2__syn		22	*/
    WIN1250__etb,		/*	ISO2__etb		23	*/
    WIN1250__can,		/*	ISO2__can		24	*/
    WIN1250__em,		/*	ISO2__em		25	*/
    WIN1250__sub,		/*	ISO2__sub		26	*/
    WIN1250__esc,		/*	ISO2__esc		27	*/
    WIN1250__fs,		/*	ISO2__fs		28	*/
    WIN1250__gs,		/*	ISO2__gs		29	*/
    WIN1250__rs,		/*	ISO2__rs		30	*/
    WIN1250__us,		/*	ISO2__us		31	*/

    WIN1250_space,		/*	ISO2_space		32	*/
    WIN1250_exclam,		/*	ISO2_exclam		33	*/
    WIN1250_quotedbl,		/*	ISO2_quotedbl		34	*/
    WIN1250_numbersign,		/*	ISO2_numbersign		35	*/
    WIN1250_dollar,		/*	ISO2_dollar		36	*/
    WIN1250_percent,		/*	ISO2_percent		37	*/
    WIN1250_ampersand,		/*	ISO2_ampersand		38	*/
    WIN1250_quoteright,		/*	ISO2_quoteright		39	*/
    WIN1250_parenleft,		/*	ISO2_parenleft		40	*/
    WIN1250_parenright,		/*	ISO2_parenright		41	*/
    WIN1250_asterisk,		/*	ISO2_asterisk		42	*/
    WIN1250_plus,		/*	ISO2_plus		43	*/
    WIN1250_comma,		/*	ISO2_comma		44	*/
    WIN1250_minus,		/*	ISO2_minus		45	*/
    WIN1250_period,		/*	ISO2_period		46	*/
    WIN1250_slash,		/*	ISO2_slash		47	*/
    WIN1250_zero,		/*	ISO2_zero		48	*/
    WIN1250_one,		/*	ISO2_one		49	*/
    WIN1250_two,		/*	ISO2_two		50	*/
    WIN1250_three,		/*	ISO2_three		51	*/
    WIN1250_four,		/*	ISO2_four		52	*/
    WIN1250_five,		/*	ISO2_five		53	*/
    WIN1250_six,		/*	ISO2_six		54	*/
    WIN1250_seven,		/*	ISO2_seven		55	*/
    WIN1250_eight,		/*	ISO2_eight		56	*/
    WIN1250_nine,		/*	ISO2_nine		57	*/
    WIN1250_colon,		/*	ISO2_colon		58	*/
    WIN1250_semicolon,		/*	ISO2_semicolon		59	*/
    WIN1250_less,		/*	ISO2_less		60	*/
    WIN1250_equal,		/*	ISO2_equal		61	*/
    WIN1250_greater,		/*	ISO2_greater		62	*/
    WIN1250_question,		/*	ISO2_question		63	*/

    WIN1250_at,			/*	ISO2_at			64	*/
    WIN1250_A,			/*	ISO2_A			65	*/
    WIN1250_B,			/*	ISO2_B			66	*/
    WIN1250_C,			/*	ISO2_C			67	*/
    WIN1250_D,			/*	ISO2_D			68	*/
    WIN1250_E,			/*	ISO2_E			69	*/
    WIN1250_F,			/*	ISO2_F			70	*/
    WIN1250_G,			/*	ISO2_G			71	*/
    WIN1250_H,			/*	ISO2_H			72	*/
    WIN1250_I,			/*	ISO2_I			73	*/
    WIN1250_J,			/*	ISO2_J			74	*/
    WIN1250_K,			/*	ISO2_K			75	*/
    WIN1250_L,			/*	ISO2_L			76	*/
    WIN1250_M,			/*	ISO2_M			77	*/
    WIN1250_N,			/*	ISO2_N			78	*/
    WIN1250_O,			/*	ISO2_O			79	*/
    WIN1250_P,			/*	ISO2_P			80	*/
    WIN1250_Q,			/*	ISO2_Q			81	*/
    WIN1250_R,			/*	ISO2_R			82	*/
    WIN1250_S,			/*	ISO2_S			83	*/
    WIN1250_T,			/*	ISO2_T			84	*/
    WIN1250_U,			/*	ISO2_U			85	*/
    WIN1250_V,			/*	ISO2_V			86	*/
    WIN1250_W,			/*	ISO2_W			87	*/
    WIN1250_X,			/*	ISO2_X			88	*/
    WIN1250_Y,			/*	ISO2_Y			89	*/
    WIN1250_Z,			/*	ISO2_Z			90	*/
    WIN1250_bracketleft,	/*	ISO2_bracketleft	91	*/
    WIN1250_backslash,		/*	ISO2_backslash		92	*/
    WIN1250_bracketright,	/*	ISO2_bracketright	93	*/
    WIN1250_circumflex,		/*	ISO2_circumflex		94	*/
    WIN1250_underscore,		/*	ISO2_underscore		95	*/

    WIN1250_quoteleft,		/*	ISO2_quoteleft		96	*/
    WIN1250_a,			/*	ISO2_a			97	*/
    WIN1250_b,			/*	ISO2_b			98	*/
    WIN1250_c,			/*	ISO2_c			99	*/
    WIN1250_d,			/*	ISO2_d			100	*/
    WIN1250_e,			/*	ISO2_e			101	*/
    WIN1250_f,			/*	ISO2_f			102	*/
    WIN1250_g,			/*	ISO2_g			103	*/
    WIN1250_h,			/*	ISO2_h			104	*/
    WIN1250_i,			/*	ISO2_i			105	*/
    WIN1250_j,			/*	ISO2_j			106	*/
    WIN1250_k,			/*	ISO2_k			107	*/
    WIN1250_l,			/*	ISO2_l			108	*/
    WIN1250_m,			/*	ISO2_m			109	*/
    WIN1250_n,			/*	ISO2_n			110	*/
    WIN1250_o,			/*	ISO2_o			111	*/
    WIN1250_p,			/*	ISO2_p			112	*/
    WIN1250_q,			/*	ISO2_q			113	*/
    WIN1250_r,			/*	ISO2_r			114	*/
    WIN1250_s,			/*	ISO2_s			115	*/
    WIN1250_t,			/*	ISO2_t			116	*/
    WIN1250_u,			/*	ISO2_u			117	*/
    WIN1250_v,			/*	ISO2_v			118	*/
    WIN1250_w,			/*	ISO2_w			119	*/
    WIN1250_x,			/*	ISO2_x			120	*/
    WIN1250_y,			/*	ISO2_y			121	*/
    WIN1250_z,			/*	ISO2_z			122	*/
    WIN1250_braceleft,		/*	ISO2_braceleft		123	*/
    WIN1250_bar,		/*	ISO2_bar		124	*/
    WIN1250_braceright,		/*	ISO2_braceright		125	*/
    WIN1250_tilde,		/*	ISO2_tilde		126	*/
    WIN1250__del,		/*	ISO2__del		127	*/

    WIN1250_currency,		/*	.NOTDEF_128		128	*//**/
    WIN1250_currency,		/*	.NOTDEF_129		129	*//**/
    WIN1250_currency,		/*	.NOTDEF_130		130	*//**/
    WIN1250_currency,		/*	.NOTDEF_131		131	*//**/
    WIN1250_currency,		/*	.NOTDEF_132		132	*//**/
    WIN1250_currency,		/*	.NOTDEF_133		133	*//**/
    WIN1250_currency,		/*	.NOTDEF_134		134	*//**/
    WIN1250_currency,		/*	.NOTDEF_135		135	*//**/

    WIN1250_currency,		/*	.NOTDEF_136		136	*//**/
    WIN1250_currency,		/*	.NOTDEF_137		137	*//**/
    WIN1250_currency,		/*	.NOTDEF_138		138	*//**/
    WIN1250_currency,		/*	.NOTDEF_139		139	*//**/
    WIN1250_currency,		/*	.NOTDEF_140		140	*//**/
    WIN1250_currency,		/*	.NOTDEF_141		141	*//**/
    WIN1250_currency,		/*	.NOTDEF_142		142	*//**/
    WIN1250_currency,		/*	.NOTDEF_143		143	*//**/

    WIN1250_currency,		/*	ISO2_dotlessi		144	*//**/
    WIN1250_currency,		/*	ISO2_grave		145	*//**/
    WIN1250_acute,		/*	ISO2__acute_146		146	*/
    WIN1250_circumflex,		/*	ISO2__circumflex	147	*/
    WIN1250_tilde,		/*	ISO2__tilde_148		148	*/
    WIN1250_currency,		/*	ISO2__macron		149	*//**/
    WIN1250_breve,		/*	ISO2__breve_150		150	*/
    WIN1250_dotaccent,		/*	ISO2__dotaccent		151	*/

    WIN1250_dieresis,		/*	ISO2__dieresis		152	*/
    WIN1250_currency,		/*	._NOTDEF_153		153	*/
    WIN1250_degree,		/*	ISO2_ring		154	*//**/
    WIN1250_cedilla,		/*	ISO2__cedilla		155	*/
    WIN1250_currency,		/*	._NOTDEF_156		156	*/
    WIN1250_hungarumlaut,	/*	ISO2__hungarumlaut	157	*/
    WIN1250_ogonek,		/*	ISO2__ogonek		158	*/
    WIN1250_caron,		/*	ISO2__caron_159		159	*/

    WIN1250_space,		/*	ISO2_nobreakspace	160	*//**/
    WIN1250_Aogonek,		/*	ISO2_Aogonek		161	*/
    WIN1250_breve,		/*	ISO2_breve		162	*/
    WIN1250_Lslash,		/*	ISO2_Lslash		163	*/
    WIN1250_currency,		/*	ISO2_currency		164	*/
    WIN1250_Lcaron,		/*	ISO2_Lcaron		165	*/
    WIN1250_Sacute,		/*	ISO2_Sacute		166	*/
    WIN1250_section,		/*	ISO2_section		167	*/

    WIN1250_dieresis,		/*	ISO2_dieresis		168	*/
    WIN1250_Scaron,		/*	ISO2_Scaron		169	*/
    WIN1250_Scedilla,		/*	ISO2_Scedilla		170	*/
    WIN1250_Tcaron,		/*	ISO2_Tcaron		171	*/
    WIN1250_Zacute,		/*	ISO2_Zacute		172	*/
    WIN1250_hyphen,		/*	ISO2_hyphen		173	*/
    WIN1250_Zcaron,		/*	ISO2_Zcaron		174	*/
    WIN1250_Zdotaccent,		/*	ISO2_Zdotaccent		175	*/

    WIN1250_degree,		/*	ISO2_degree		176	*/
    WIN1250_aogonek,		/*	ISO2_aogonek		177	*/
    WIN1250_ogonek,		/*	ISO2_ogonek		178	*/
    WIN1250_lslash,		/*	ISO2_lslash		179	*/
    WIN1250_acute,		/*	ISO2_acute		180	*/
    WIN1250_lcaron,		/*	ISO2_lcaron		181	*/
    WIN1250_sacute,		/*	ISO2_sacute		182	*/
    WIN1250_caron,		/*	ISO2_caron		183	*/

    WIN1250_cedilla,		/*	ISO2_cedilla		184	*/
    WIN1250_scaron,		/*	ISO2_scaron		185	*/
    WIN1250_scedilla,		/*	ISO2_scedilla		186	*/
    WIN1250_tcaron,		/*	ISO2_tcaron		187	*/
    WIN1250_zacute,		/*	ISO2_zacute		188	*/
    WIN1250_hungarumlaut,	/*	ISO2_hungarumlaut	189	*/
    WIN1250_zcaron,		/*	ISO2_zcaron		190	*/
    WIN1250_zdotaccent,		/*	ISO2_zdotaccent		191	*/

    WIN1250_Racute,		/*	ISO2_Racute		192	*/
    WIN1250_Aacute,		/*	ISO2_Aacute		193	*/
    WIN1250_Acircumflex,	/*	ISO2_Acircumflex	194	*/
    WIN1250_Abreve,		/*	ISO2_Abreve		195	*/
    WIN1250_Adieresis,		/*	ISO2_Adieresis		196	*/
    WIN1250_Lacute,		/*	ISO2_Lacute		197	*/
    WIN1250_Cacute,		/*	ISO2_Cacute		198	*/
    WIN1250_Ccedilla,		/*	ISO2_Ccedilla		199	*/

    WIN1250_Ccaron,		/*	ISO2_Ccaron		200	*/
    WIN1250_Eacute,		/*	ISO2_Eacute		201	*/
    WIN1250_Eogonek,		/*	ISO2_Eogonek		202	*/
    WIN1250_Edieresis,		/*	ISO2_Edieresis		203	*/
    WIN1250_Ecaron,		/*	ISO2_Ecaron		204	*/
    WIN1250_Iacute,		/*	ISO2_Iacute		205	*/
    WIN1250_Icircumflex,	/*	ISO2_Icircumflex	206	*/
    WIN1250_Dcaron,		/*	ISO2_Dcaron		207	*/

    WIN1250_Dcroat,		/*	ISO2_Dcroat		208	*/
    WIN1250_Nacute,		/*	ISO2_Nacute		209	*/
    WIN1250_Ncaron,		/*	ISO2_Ncaron		210	*/
    WIN1250_Oacute,		/*	ISO2_Oacute		211	*/
    WIN1250_Ocircumflex,	/*	ISO2_Ocircumflex	212	*/
    WIN1250_Ohungarumlaut,	/*	ISO2_Ohungarumlaut	213	*/
    WIN1250_Odieresis,		/*	ISO2_Odieresis		214	*/
    WIN1250_multiply,		/*	ISO2_multiply		215	*/

    WIN1250_Rcaron,		/*	ISO2_Rcaron		216	*/
    WIN1250_Uring,		/*	ISO2_Uring		217	*/
    WIN1250_Uacute,		/*	ISO2_Uacute		218	*/
    WIN1250_Uhungarumlaut,	/*	ISO2_Uhungarumlaut	219	*/
    WIN1250_Udieresis,		/*	ISO2_Udieresis		220	*/
    WIN1250_Yacute,		/*	ISO2_Yacute		221	*/
    WIN1250_Tcedilla,		/*	ISO2_Tcedilla		222	*/
    WIN1250_germandbls,		/*	ISO2_germandbls		223	*/

    WIN1250_racute,		/*	ISO2_racute		224	*/
    WIN1250_aacute,		/*	ISO2_aacute		225	*/
    WIN1250_acircumflex,	/*	ISO2_acircumflex	226	*/
    WIN1250_abreve,		/*	ISO2_abreve		227	*/
    WIN1250_adieresis,		/*	ISO2_adieresis		228	*/
    WIN1250_lacute,		/*	ISO2_lacute		229	*/
    WIN1250_cacute,		/*	ISO2_cacute		230	*/
    WIN1250_ccedilla,		/*	ISO2_ccedilla		231	*/

    WIN1250_ccaron,		/*	ISO2_ccaron		232	*/
    WIN1250_eacute,		/*	ISO2_eacute		233	*/
    WIN1250_eogonek,		/*	ISO2_eogonek		234	*/
    WIN1250_edieresis,		/*	ISO2_edieresis		235	*/
    WIN1250_ecaron,		/*	ISO2_ecaron		236	*/
    WIN1250_iacute,		/*	ISO2_iacute		237	*/
    WIN1250_icircumflex,	/*	ISO2_icircumflex	238	*/
    WIN1250_dcaron,		/*	ISO2_dcaron		239	*/

    WIN1250_dcroat,		/*	ISO2_dcroat		240	*/
    WIN1250_nacute,		/*	ISO2_nacute		241	*/
    WIN1250_ncaron,		/*	ISO2_ncaron		242	*/
    WIN1250_oacute,		/*	ISO2_oacute		243	*/
    WIN1250_ocircumflex,	/*	ISO2_ocircumflex	244	*/
    WIN1250_ohungarumlaut,	/*	ISO2_ohungarumlaut	245	*/
    WIN1250_odieresis,		/*	ISO2_odieresis		246	*/
    WIN1250_divide,		/*	ISO2_divide		247	*/

    WIN1250_rcaron,		/*	ISO2_rcaron		248	*/
    WIN1250_uring,		/*	ISO2_uring		249	*/
    WIN1250_uacute,		/*	ISO2_uacute		250	*/
    WIN1250_uhungarumlaut,	/*	ISO2_uhungarumlaut	251	*/
    WIN1250_udieresis,		/*	ISO2_udieresis		252	*/
    WIN1250_yacute,		/*	ISO2_yacute		253	*/
    WIN1250_tcedilla,		/*	ISO2_tcedilla		254	*/
    WIN1250_dotaccent,		/*	ISO2_dotaccent		255	*/
    };
