#   include	"config.h"

#   include	<stdlib.h>
#   include	<stdio.h>
#   include	<string.h>

#   define	y0	math_y0
#   define	y1	math_y1
#   include	<math.h>
#   undef	y0
#   undef	y1

#   include	"bmintern.h"
#   include	<debugon.h>

#   include	"gif.h"

#   include	<gif_lib.h>

/************************************************************************/
/*  Read a GIF file.							*/
/************************************************************************/
int bmReadGifFile(	const char *		filename,
			unsigned char **	pBuffer,
			BitmapDescription *	bd,
			int *			pPrivateFormat,
			double *		pCompressionFactor	)
    {
    GifFileType *	gft;
    int			privateFormat= 87;
    int			transparent= -1;

    unsigned char *	buffer= (unsigned char *)0;

    gft= DGifOpenFileName( filename );
    if  ( ! gft )
	{ SXDEB(filename,gft); return -1;	}

    for (;;)
	{
	GifRecordType		grt;
	unsigned int		row;
	int			bpr;
	int			wide;
	ColorMapObject *	cmap;

	if  ( DGifGetRecordType( gft, &grt ) != GIF_OK )
	    { LDEB(1); DGifCloseFile( gft ); return -1;	}

	switch( grt )
	    {
	    case UNDEFINED_RECORD_TYPE:
		LDEB(grt); continue;
	    case SCREEN_DESC_RECORD_TYPE:
		LDEB(grt); continue;
	    case IMAGE_DESC_RECORD_TYPE:
		if  ( DGifGetImageDesc( gft ) != GIF_OK )
		    { LDEB(1); DGifCloseFile( gft ); return -1; }
		bd->bdPixelsWide= gft->Image.Width;
		bd->bdPixelsHigh= gft->Image.Height;
		if  ( transparent >= 0 )
		    { bd->bdHasAlpha= 1;	}
		else{ bd->bdHasAlpha= 0;	}
		bd->bdUnit= BMunINCH;
		bd->bdXResolution= 72;
		bd->bdYResolution= 72;

		bd->bdBitsPerSample= 8;
		bd->bdSamplesPerPixel= 3;
		bd->bdBitsPerPixel= 8;
		bd->bdColorEncoding= BMcoRGB8PALETTE;
		bd->bdColorCount= 256;
		bd->bdRGB8Palette= (RGB8Color *)0;
		bd->bdBytesPerRow= bd->bdPixelsWide;
		bd->bdBufferLength= bd->bdPixelsHigh* bd->bdBytesPerRow;

		if  ( bd->bdHasAlpha )
		    { bd->bdBytesPerRow *= 2; bd->bdBufferLength *= 2; }

		buffer= (unsigned char *)malloc( bd->bdBufferLength );
		if  ( ! buffer )
		    {
		    LLDEB(bd->bdBufferLength,buffer);
		    DGifCloseFile( gft ); return -1;
		    }

		bd->bdRGB8Palette= (RGB8Color *)
					malloc( 256* sizeof( RGB8Color ) );
		if  ( ! bd->bdRGB8Palette )
		    {
		    LLDEB(256,bd->bdRGB8Palette);
		    free( buffer ); DGifCloseFile( gft ); return -1;
		    }

		wide= bd->bdPixelsWide;
		bpr= bd->bdBytesPerRow;
		if  ( gft->Image.Interlace )
		    {
		    for ( row= 0; row < bd->bdPixelsHigh; row += 8 )
			{
			if  ( DGifGetLine( gft, buffer+ row* bpr, wide ) !=
								    GIF_OK )
			    { LDEB(row); DGifCloseFile( gft ); return -1; }
			}
		    for ( row= 4; row < bd->bdPixelsHigh; row += 8 )
			{
			if  ( DGifGetLine( gft, buffer+ row* bpr, wide ) !=
								    GIF_OK )
			    { LDEB(row); DGifCloseFile( gft ); return -1; }
			}
		    for ( row= 2; row < bd->bdPixelsHigh; row += 4 )
			{
			if  ( DGifGetLine( gft, buffer+ row* bpr, wide ) !=
								    GIF_OK )
			    { LDEB(row); DGifCloseFile( gft ); return -1; }
			}
		    for ( row= 1; row < bd->bdPixelsHigh; row += 2 )
			{
			if  ( DGifGetLine( gft, buffer+ row* bpr, wide ) !=
								    GIF_OK )
			    { LDEB(row); DGifCloseFile( gft ); return -1; }
			}
		    }
		else{
		    for ( row= 0; row < bd->bdPixelsHigh; row++ )
			{
			if  ( DGifGetLine( gft, buffer+ row* bpr, wide ) !=
								    GIF_OK )
			    { LDEB(row); DGifCloseFile( gft ); return -1; }
			}
		    }

		if  ( gft->Image.ColorMap )
		    { cmap= gft->Image.ColorMap;	}
		else{ cmap= gft->SColorMap;		}

		bd->bdColorCount= cmap->ColorCount;
		for ( row= 0; row < bd->bdColorCount; row++ )
		    {
		    bd->bdRGB8Palette[row].rgb8Red=   cmap->Colors[row].Red;
		    bd->bdRGB8Palette[row].rgb8Green= cmap->Colors[row].Green;
		    bd->bdRGB8Palette[row].rgb8Blue=  cmap->Colors[row].Blue;
		    }

		if  ( bd->bdHasAlpha )
		    {
		    for ( row= 0; row < bd->bdPixelsHigh; row++ )
			{
			unsigned char *	to=   buffer+ row* bpr+  bpr-  1;
			unsigned char *	from= buffer+ row* wide+ wide- 1;

			for ( row= 0; row < bd->bdPixelsHigh; row++ )
			    {
			    if  ( *from == transparent )
				{ *(to--)= 0x00; }
			    else{ *(to--)= 0xff; }

			    *(to--)= *(from--);
			    }
			}
		    }

		continue;
	    case EXTENSION_RECORD_TYPE:
		{
		int		extensionType;
		unsigned char *	extension;

		if  ( DGifGetExtension( gft, &extensionType, &extension )
								!= GIF_OK )
		    { LDEB(1); DGifCloseFile( gft ); return -1; }

		switch( extensionType )
		    {
		    case GRAPHICS_EXT_FUNC_CODE:
			if  ( extension[1] & 0x1 )
			    { transparent= extension[2];	}
			break;
		    case COMMENT_EXT_FUNC_CODE:
		    case PLAINTEXT_EXT_FUNC_CODE:
		    case APPLICATION_EXT_FUNC_CODE:
		    default:
			LDEB(extensionType); break;
		    }

		while( extension )
		    {
		    if  ( DGifGetExtensionNext( gft, &extension ) != GIF_OK )
			{ LDEB(1); DGifCloseFile( gft ); return -1; }
		    }
		}
		continue;
	    case TERMINATE_RECORD_TYPE:
		break;
	    }

	break;
	}

    DGifCloseFile( gft );

    *pPrivateFormat= privateFormat;
    *pBuffer= buffer;

    return 0;
    }

/************************************************************************/
/*									*/
/*  Write a GIF file.							*/
/*									*/
/************************************************************************/
int bmWriteGifFile(	const char *			filename,
			const unsigned char *		buffer,
			const BitmapDescription *	bd,
			int				privateFormat,
			double				compressionFactor )
    {
    GifFileType *		gft;

    RGB8Color			palette[256];
    GifColorType		gct[256];
    ColorMapObject		cmap;

    int				left= 0;
    int				top= 0;
    int				interlace= 0;

    unsigned int		row;
    const unsigned char *	from;

    /*  1  */
    switch( bd->bdColorEncoding )
	{
	case BMcoWHITEBLACK:
	case BMcoBLACKWHITE:
	    if  ( bmMakeGrayPalette( bd, &(cmap.ColorCount), palette ) )
		{ LDEB(bd->bdBitsPerPixel); return -1;	}

	    cmap.BitsPerPixel= bd->bdBitsPerPixel;
	    cmap.Colors= gct;

	    for ( row= 0; row < (unsigned)cmap.ColorCount; row++ )
		{
		gct[row].Red= palette[row].rgb8Red;
		gct[row].Green= palette[row].rgb8Green;
		gct[row].Blue= palette[row].rgb8Blue;
		}

	    break;

	case BMcoRGB8PALETTE:
	    switch( bd->bdBitsPerPixel )
		{
		case 1: case 2: case 4: case 8:
		    cmap.BitsPerPixel= bd->bdBitsPerPixel;
		    cmap.ColorCount= 1 << cmap.BitsPerPixel;
		    cmap.Colors= gct;

		    for ( row= 0; row < bd->bdColorCount; row++ )
			{
			gct[row].Red=   bd->bdRGB8Palette[row].rgb8Red;
			gct[row].Green= bd->bdRGB8Palette[row].rgb8Green;
			gct[row].Blue=  bd->bdRGB8Palette[row].rgb8Blue;
			}

		    break;
		default:
		    LLDEB(bd->bdColorEncoding,bd->bdBitsPerPixel);
		    return -1;
		}
	    break;
	case BMcoRGB:
	    switch( bd->bdBitsPerPixel )
		{
		case 4:
		case 8:
		default:
		    LLDEB(bd->bdColorEncoding,bd->bdBitsPerPixel);
		    return -1;
		}
	    /* colorBits= bd->bdBitsPerPixel; */
	    /* break; */
	default:
	    LLDEB(bd->bdColorEncoding,bd->bdBitsPerPixel);
	    return -1;
	}

    gft= EGifOpenFileName( (char *)filename, 0 );
    if  ( ! gft )
	{ SXDEB(filename,gft); return -1;	}

    if  ( EGifPutScreenDesc( gft,
				bd->bdPixelsWide, bd->bdPixelsHigh,
				cmap.ColorCount, 0, &cmap ) != GIF_OK )
	{ LDEB(GifLastError()); EGifCloseFile( gft ); return -1;	}

    if  ( EGifPutImageDesc( gft, left, top,
				bd->bdPixelsWide, bd->bdPixelsHigh,
				interlace, &cmap ) != GIF_OK )
	{ LDEB(GifLastError()); EGifCloseFile( gft ); return -1;	}

    if  ( bd->bdBitsPerPixel == 8 )
	{
	from= buffer;
	for ( row= 0; row < bd->bdPixelsHigh; row++ )
	    {
	    if  ( EGifPutLine( gft, (unsigned char *)from,
						bd->bdPixelsWide ) != GIF_OK )
		{ LDEB(row); EGifCloseFile( gft ); return -1; }

	    from += bd->bdBytesPerRow;
	    }
	}
    else{
	unsigned char *		line;

	line= (unsigned char *)malloc( bd->bdPixelsWide );
	if  ( ! line )
	    { XDEB(line); EGifCloseFile( gft ); return -1; }

	switch( bd->bdBitsPerPixel )
	    {
	    case 1: case 2: case 4:
		for ( row= 0; row < bd->bdPixelsHigh; row++ )
		    {
		    from= buffer+ row* bd->bdBytesPerRow;

		    bmInflateTo8bit( line, from, bd );

		    if  ( EGifPutLine( gft, line, bd->bdPixelsWide ) != GIF_OK )
			{
			LDEB(row);
			EGifCloseFile( gft ); free( line );
			return -1;
			}
		    }
		break;

	    default:
		LDEB(bd->bdBitsPerPixel);
		EGifCloseFile( gft ); free( line );
		return -1;
	    }

	free( line );
	}

    EGifCloseFile( gft );

    return 0;
    }

/************************************************************************/
/*  Can this bitmap be written in GIF?					*/
/************************************************************************/
int bmCanWriteGifFile(	const BitmapDescription *	bd,
			int				privateFormat,
			double				compressionFactor )
    {
    if  ( bd->bdBitsPerPixel <= 8 )
	{ return 0;	}

    return -1;
    }
