#   ifndef	IND_H						/*  {{	*/
#   define	IND_H

#   include	<stdio.h>

#   define	INDhASIS	1	/*  knudde -> knudde		*/
#   define	INDhFIRSTUP	2	/*  Knudde -> knudde		*/
#   define	INDhIJUP	3	/*  IJsco -> ijsco		*/
#   define	INDhALLUP	4	/*  KNUDDE -> knudde		*/
#   define	INDhTAILUP	5	/*  EDAM -> Edam		*/
#   define	INDhIJTAILUP	6	/*  IJMUIDEN -> IJmuiden	*/

/************************************************************************/
/*  A list of Guesses.							*/
/************************************************************************/
typedef struct IndGuessScore
    {
    unsigned char *	igsWord;
    int			igsScore;
    } IndGuessScore;

typedef struct IndGuessList
    {
    int			iglGuessCount;
    IndGuessScore *	iglGuesses;
    } IndGuessList;

/************************************************************************/
/*  Scores for frequent substitutions: Helps making guesses.		*/
/************************************************************************/
typedef struct GuessSubstitution
    {
    unsigned char *	gsFrom;
    unsigned char *	gsTo;
    int			gsFromLength;
    int			gsToLength;
    int			gsCost;

    } GuessSubstitution;

/************************************************************************/
/*  A possible 'word' that is collected doring the scan of the input.	*/
/************************************************************************/
#   define	FORM_MAX	100

typedef struct PossibleWord
    {
    int				pwStartPosition;
    int				pwInsertionPoint;
    int				pwRejectedAt;
    int				pwAcceptedAt;
    struct PossibleWord *	pwNext;
    unsigned char		pwForm[FORM_MAX+2];
    } PossibleWord;

/************************************************************************/
/*  Operating environment for a checker.				*/
/************************************************************************/
typedef struct SpellCheckContext
    {
    char *		sccDictionaryPrefix;
    void *		sccStaticInd;
    void *		sccForgotInd;
    void *		sccLearntInd;
    unsigned char	sccCharKinds[256];
    unsigned char	sccCharShifts[256];
    } SpellCheckContext;

typedef struct SpellGuessContext
    {
    IndGuessList *	sgcGuessList;
    SpellCheckContext *	sgcCheckContext;
    } SpellGuessContext;

/************************************************************************/
/*  Routine declarations.						*/
/************************************************************************/
extern void *	indMake( void );
extern void *	indRead( const char * filename, int readonly );
extern int		indPut( void * ind, const unsigned char * key );
extern int		indForget( void * ind, const unsigned char * key );
extern int		indGet( int *, void * ind, const unsigned char * key );
extern void		indFree( void * ind );
extern int		indWrite( void * ind, const char * filename );
extern void *	indMini( void * ind );
extern void *	indRenumber( void * ind );

extern int indGuess(	void *				voidind,
			const unsigned char *		word,
			SpellGuessContext *		sgc,
			int				how,
			const GuessSubstitution *	typos,
			int				count,
			const unsigned char *	charKinds,
			const unsigned char *	charShifts );

extern int	indSetItem( void *, int, int );
extern int	indGetItems( void *, int, int *, int ** );

extern int	indGetWord(	int *			pWhatWasShifted,
				void *			voidind,
				const unsigned char *	word,
				int			asPrefix,
				const unsigned char *	charKinds,
				const unsigned char *	charShifts );

extern int indGuessWord(    void *				voidind,
			    const unsigned char *		word,
			    SpellGuessContext *			sgc,
			    const GuessSubstitution *		typos,
			    int					count,
			    const unsigned char *		charKinds,
			    const unsigned char *		charShifts );

extern int indShiftWord(	unsigned char *		copy,
				const unsigned char *	word,
				int			how,
				const unsigned char *	charKinds,
				const unsigned char *	charShifts );

extern int indAddGuess(		IndGuessList *		igl,
				const unsigned char *	word,
				int			score	);

extern void 	indCleanGuesses( IndGuessList *		igl );
extern void 	indSortGuesses(	IndGuessList *		igl );

extern void	indFreePossibilities(	PossibleWord *	pw	);
extern void	indLogPossibilities(	PossibleWord *	pw	);

extern PossibleWord *	indNewPossibility(	int		start,
						PossibleWord *	next,
						int		first	);

extern void indAddCharacterToPossibilities(	PossibleWord *	pw,
						int		c	);

extern int indCountPossibilities(	PossibleWord *		pw,
					int			position,
					SpellCheckContext *	scc,
					int			cnx );

extern PossibleWord * indRejectPossibilities(	PossibleWord *	pw	);
extern PossibleWord * indMaximalPossibility(	PossibleWord *	pw	);

extern int	indMoveWord(	void *			fromInd,
				void *			toInd,
				const unsigned char *	word );

extern int indReadPrivateDictionary(	FILE *		f,
					void **		pLearntInd,
					void **		pForgotInd	);

extern int indLearnWord(	FILE *			f,
				void *			learntInd,
				void *			forgotInd,
				const unsigned char *	word	);

extern int indForgetWord(	FILE *			f,
				void *			learntInd,
				void *			forgotInd,
				const unsigned char *	word	);

#   endif /*	IND_H						    }}	*/
