;;; x-symbol-utex.el --- token language "Unique TeX macro" for package x-symbol

;; Copyright (C) 1998-1999 Free Software Foundation, Inc.
;;
;; Author: Christoph Wedler <wedler@fmi.uni-passau.de>
;; Maintainer: (Please use `M-x x-symbol-package-bug' to contact the maintainer)
;; Version: $Id: x-symbol-utex.el,v 3.3 1999/01/18 14:17:22 wedler Exp wedler $
;; Keywords: WYSIWYG, LaTeX, wp, math, internationalization
;; X-URL: http://www.fmi.uni-passau.de/~wedler/x-symbol/

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.
;;
;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

;;; Commentary:

;; If you want to use package x-symbol, please visit the URL (use
;; \\[x-symbol-package-web]) and read the info (use \\[x-symbol-package-info]).

;; Token language utex should be registered by yourself, see x-symbol-site.el.

;;; Code:

(provide 'x-symbol-utex)
(require 'x-symbol-vars)
(require 'x-symbol-tex)


;;;===========================================================================
;;;  "Own" variables
;;;===========================================================================

(defcustom x-symbol-utex-modeline-name "utex"
  "*String naming the language Unique TeX in the modeline."
  :group 'x-symbol-utex
  :type 'string)

(defvar x-symbol-utex-token-list
  (lambda (tokens) (list (car (x-symbol-tex-default-token-list tokens))))
  "Used to get a list of one Unique TeX macro from table specification.
See `x-symbol-init-language'.")

(defvar x-symbol-utex-input-token-ignore nil
  "Regexp matching Unique TeX macros not being used for input method TOKEN.
See `x-symbol-init-language'.")

(defvar x-symbol-utex-user-table nil
  "User table defining Unique TeX macros, used in `x-symbol-utex-table'.")

(defvar x-symbol-utex-table
  (append x-symbol-utex-user-table x-symbol-tex-table)
  "Complete table defining Unique TeX macros, see `x-symbol-utex-user-table'.
Default value uses all definitions in `x-symbol-tex-table'.")


;;;===========================================================================
;;;  Mainly inheritance from x-symbol-tex
;;;===========================================================================

(put 'utex 'x-symbol-font-lock-keywords 'x-symbol-tex-font-lock-keywords)

(defcustom x-symbol-utex-master-directory x-symbol-tex-master-directory
  "`utex's version of `x-symbol-tex-master-directory'."
  :group 'x-symbol-utex
  :group 'x-symbol-image-language
  :type 'function)

(defcustom x-symbol-utex-image-searchpath x-symbol-tex-image-searchpath
  "`utex's version of `x-symbol-tex-image-searchpath'."
  :group 'x-symbol-utex
  :group 'x-symbol-image-language
  :type '(repeat directory))

(defcustom x-symbol-utex-image-cached-dirs x-symbol-tex-image-cached-dirs
  "`utex's version of `x-symbol-tex-image-cached-dirs'."
  :group 'x-symbol-utex
  :group 'x-symbol-image-language
  :type '(repeat string))

(defcustom x-symbol-utex-image-keywords x-symbol-tex-image-keywords
  "`utex's version of `x-symbol-tex-image-keywords'."
  :group 'x-symbol-utex
  :group 'x-symbol-image-language
  :type 'x-symbol-image-keywords)

(defcustom x-symbol-utex-header-groups-alist x-symbol-tex-header-groups-alist
  "`utex's version of `x-symbol-tex-header-groups-alist'."
  :group 'x-symbol-utex
  :group 'x-symbol-input-init
  :type 'x-symbol-headers)

(defcustom x-symbol-utex-electric-ignore x-symbol-tex-electric-ignore
  "`utex's version of `x-symbol-tex-electric-ignore'."
  :group 'x-symbol-utex
  :group 'x-symbol-input-control
  :type 'x-symbol-function-or-regexp)

(defvar x-symbol-utex-required-fonts x-symbol-tex-required-fonts
  "List of features providing fonts for language `utex'.")
(defvar x-symbol-utex-case-insensitive x-symbol-tex-case-insensitive
  "`utex's version of `x-symbol-tex-case-insensitive'.")
(defvar x-symbol-utex-token-shape x-symbol-tex-token-shape
  "`utex's version of `x-symbol-tex-token-shape'.")
(defvar x-symbol-utex-exec-specs x-symbol-tex-exec-specs
  "`utex's version of `x-symbol-tex-exec-specs'.")

(defcustom x-symbol-utex-class-alist x-symbol-tex-class-alist
  "`utex's version of `x-symbol-tex-class-alist'."
  :group 'x-symbol-utex
  :group 'x-symbol-info-strings
  :set 'x-symbol-set-cache-variable
  :type 'x-symbol-class-info)

(defcustom x-symbol-utex-class-face-alist x-symbol-tex-class-face-alist
  "`utex's version of `x-symbol-tex-class-face-alist'."
  :group 'x-symbol-utex
  :group 'x-symbol-input-init
  :group 'x-symbol-info-general
  :set 'x-symbol-set-cache-variable
  :type 'x-symbol-class-faces)


;;;===========================================================================
;;;  Internal
;;;===========================================================================

(defvar x-symbol-utex-menu-alist nil
  "Internal.  Alist used for Unique TeX specific menu.")
(defvar x-symbol-utex-grid-alist nil
  "Internal.  Alist used for Unique TeX specific grid.")

(defvar x-symbol-utex-decode-atree nil
  "Internal.  Atree used by `x-symbol-token-input'.")
(defvar x-symbol-utex-decode-alist nil
  "Internal.  Alist used for decoding of Unique TeX macros.")
(defvar x-symbol-utex-encode-alist nil
  "Internal.  Alist used for encoding to Unique TeX macros.")

(defvar x-symbol-utex-nomule-decode-exec nil
  "Internal.  File name of Unique TeX decode executable.")
(defvar x-symbol-utex-nomule-encode-exec nil
  "Internal.  File name of Unique TeX encode executable.")

;;; Local IspellPersDict: .ispell_xsymb
;;; x-symbol-utex.el ends here
