//  UMenu.cpp version 1.5
//  yudit package - Unicode Editor for the X Window System (and Linux) 
//
//  Author: gsinai@iname.com (Gaspar Sinai)
//  GNU Copyright (C) 1997,1998,1999  Gaspar Sinai
// 
//  yudit version 1.5  Copyright(C) 30 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.4  Copyright(C) 25 November, 1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.3  Copyright(C)  5 April,    1999, Tokyo Japan  Gaspar Sinai
//  yudit version 1.2  Copyright(C) 10 December, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.1  Copyright(C) 23 August,   1998, Tokyo Japan  Gaspar Sinai
//  yudit version 1.0  Copyright(C) 17 May,      1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.99 Copyright(C)  4 April,    1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.97 Copyright(C)  4 February, 1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.95 Copyright(C) 10 January,  1998, Tokyo Japan  Gaspar Sinai
//  yudit version 0.94 Copyright(C) 17 December, 1997, Tokyo Japan  Gaspar Sinai
//  yudit version 0.9 Copyright (C)  8 December, 1997, Tokyo Japan  Gaspar Sinai
//  yutex version 0.8 Copyright (C)  5 November, 1997, Tokyo Japan  Gaspar Sinai
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
#include "UMenu.h"
#include "UComponent.h"

#include <iostream.h>

UMenu::UMenu(void)
{
	left=NO_LEFT; arrow=NO_ARROW;
	highlighted = 0; checked = 0;
}

UMenu::UMenu (UMenuLeft left_, UMenuArrow arrow_)
{
	left=left_; arrow=arrow_;
	highlighted = 0; checked = 0;
}

UMenu::~UMenu ()
{
}

void
UMenu::check()
{
	checked = 1;
}
void
UMenu::uncheck()
{
	checked = 0;
}

void
UMenu::highlight()
{
	highlighted = 1;
}

void
UMenu::unhighlight()
{
	highlighted = 0;
}

UMenuItem::UMenuItem (UComponent* parent_,
	UMenuLeft left_, UMenuArrow arrow_) :
	UMenu (left_, arrow_)
{
	parent = parent_;
	popUpLink=0;
}

UMenuItem::~UMenuItem ()
{
}

void
UMenuItem::setPopUp (UComponent* popup)
{
	if (popup->isA (UComponent::POPUP))
	{
		popUpLink = popup;
		return;
	}
	cerr << "warn: only popups should  use  setPopUp\n";
}

void
UMenuItem::check()
{
	if (checked || parent==0) return;
	checked = 1;
	UEvent event;
	event.client=this;
	event.type=UEvent::CHECK;
	parent->eventUp (&event);
}
void
UMenuItem::uncheck()
{
	if (!checked || parent==0) return;
	checked = 0;
	UEvent event;
	event.client=this;
	event.type=UEvent::UNCHECK;
	parent->eventUp (&event);
}

void
UMenuItem::highlight()
{
	if (highlighted || parent==0) return;
	highlighted = 1;
	UEvent event;
	event.client=this;
	event.type=UEvent::HIGHLIGHT;
	parent->eventUp (&event);
}

void
UMenuItem::unhighlight()
{
	if (!highlighted || parent==0) return;
	highlighted = 0;
	UEvent event;
	event.client=this;
	event.type=UEvent::UNHIGHLIGHT;
	parent->eventUp (&event);
}
