/*$Id: bm_pwl.cc,v 15.14 1999/10/20 08:53:59 al Exp $ -*- C++ -*-
 * HSPICE compatible PWL
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_PWL::EVAL_BM_PWL(int c);
//		EVAL_BM_PWL::EVAL_BM_PWL(const EVAL_BM_PWL&);
//	void	EVAL_BM_PWL::parse(CS& cmd);
// 	void	EVAL_BM_PWL::print(int)const;
//	void	EVAL_BM_PWL::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
const double _default_delta (NOT_INPUT);
const int    _default_smooth(0);
/*--------------------------------------------------------------------------*/
EVAL_BM_PWL::EVAL_BM_PWL(int c)
  :EVAL_BM_ACTION_BASE(c),
   _delta(_default_delta),
   _smooth(_default_smooth)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_PWL::EVAL_BM_PWL(const EVAL_BM_PWL& p)
  :EVAL_BM_ACTION_BASE(p),
   _delta(p._delta),
   _smooth(p._smooth),
   _table(p._table)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_PWL::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    for (;;){
      double key  =NOT_VALID;
      double value=NOT_VALID;
      cmd >> key >> value;
      if (cmd.stuck()){
	break;
      }
      PAIR<double,double> p(key,value);
      _table.push_back(p);
    }
    paren -= cmd.skiprparen();
    if (paren != 0){
      cmd.warn(bWARNING, "need )");
    }
    cmd.get("Delta",  &_delta);
    cmd.get("SMooth", &_smooth);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_PWL::print(OMSTREAM where)const
{
  where << "  " << name() << '(';
  for (std::vector<PAIR<double,double> >::const_iterator
	 p = _table.begin();  p != _table.end();  ++p){
    where << "  " << p->Key() << ',' << p->Value();
  }
  where << ')';
  print_base(where);
  if (_delta  != _default_delta)  {where << "  delta=" << _delta;  untested();}
  if (_smooth != _default_smooth) {where << "  smooth="<< _smooth; untested();}
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_PWL::tr_eval(COMPONENT* d)const
{
  INTERP_FLAG f = (d->is_source()) ? ifFLAT : ifEXTEND;
  d->y0 = interpolate(_table.begin(), _table.end(), ioffset(d->y0.x), f);
  if (d->is_source()){
    d->y0.f1 = d->y0.f0;
    d->y0.f0 = 0.;
  }
  tr_final_adjust(&(d->y0));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
