/*$Id: io_trace.h,v 14.18 1999/08/16 02:43:02 al Exp $ -*- C++ -*-
 * trace macros for model debugging
 */
/* allow multiple inclusions with different DO_TRACE */
#undef trace0
#undef trace1
#undef trace2
#undef trace3
#undef trace4
#undef untested
#include "md.h"
/*--------------------------------------------------------------------------*/
#ifdef DO_TRACE
#define trace0(s) (::error(bDEBUG, "@@%s\n", s))
#define trace1(s,x) (::error(bDEBUG, "@@%s  %s=%s\n",\
	s, #x, trim(ftos(x, 0, 5, 0))))
#define trace2(s,x,y) (::error(bDEBUG, "@@%s  %s=%s  %s=%s\n",\
	s, #x, trim(ftos(x, 0, 5, 0)), #y, trim(ftos(y, 0, 5, 0))))
#define trace3(s,x,y,z) (::error(bDEBUG, "@@%s  %s=%s  %s=%s  %s=%s\n",\
	s, #x, trim(ftos(x, 0, 5, 0)), #y, trim(ftos(y, 0, 5, 0)),\
	   #z, trim(ftos(z, 0, 5, 0))))
#define trace4(s,w,x,y,z)(::error(bDEBUG,"@@%s  %s=%s  %s=%s  %s=%s  %s=%s\n",\
	s, #w, trim(ftos(w, 0, 5, 0)), #x, trim(ftos(x, 0, 5, 0)),\
	   #y, trim(ftos(y, 0, 5, 0)), #z, trim(ftos(z, 0, 5, 0))))
#else
#define trace0(s)
#define trace1(s,x)
#define trace2(s,x,y)
#define trace3(s,x,y,z)
#define trace4(s,w,x,y,z)
#endif

#define unreachable() (printf("@@#\n@@@unreachable code:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))

#ifdef TRACE_UNTESTED
#define untested() (printf("@@#\n@@@:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))
#else
#define untested()
#endif

#ifdef TRACE_UNDERTESTED
#define undertested() (printf("@@#\n@@@:%s:%u:%s\n", \
			   __FILE__, __LINE__, __FUNCTION__))
#else
#define undertested()
#endif
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
