#ifndef IIRSCRAM_CHOICE_HH
#define IIRSCRAM_CHOICE_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_Choice.hh,v 1.2 1999/03/09 20:53:21 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_Choice.hh"

class IIR_TypeDefinition;
template <class type> class set;
class IIR_DesignatorList;
class IIR_List;

class IIRScram_Choice : public IIRBase_Choice {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  void _publish_cc_discrete_range();
  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean (IIR::*constraint_function)()=0); 
  IIR *_rval_to_decl( IIR_TypeDefinition * );
  set<IIR_Declaration> *_symbol_lookup();
  void _type_check( set<IIR_TypeDefinition> * );
  IIR_Boolean _is_resolved();

  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  ostream &_print( ostream &os );

  IIR *_clone();

protected:
  IIRScram_Choice() {};
  virtual ~IIRScram_Choice() = 0;
    
private:
};
#endif
