// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// $Id: IIRScram_ConcurrentStatementList.cc,v 1.3 1999/07/23 21:08:01 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_ConcurrentStatementList.hh"
#include "IIR_ConcurrentStatement.hh"

IIRScram_ConcurrentStatementList::~IIRScram_ConcurrentStatementList() {}

void 
IIRScram_ConcurrentStatementList::_publish_cc() {
  IIR_ConcurrentStatement *node;
  IIR_ConcurrentStatement *transmutedNode = NULL;
  IIR* _old_publish_node = _current_publish_node;
  
  // This is needed for some checks in process statements.
  // So please don't delete this NULL assignment unless you are 101% sure
  // it is not needed or wrong.
  // _current_publish_node = NULL;
  
  for (node = first(); node != NULL; node = successor(node)) {
    node->_set_enclosing_scope( _old_publish_node );
    
    transmutedNode = (IIR_ConcurrentStatement *) node->_transmute();
    if(node != transmutedNode) {
      _replace(node, transmutedNode);
      node = transmutedNode;
    }
    
    node->_set_enclosing_scope( _old_publish_node );
    node->_publish_cc();
  }
}

void 
IIRScram_ConcurrentStatementList::_publish_cc_type_info() {
  IIR_ConcurrentStatement *node;
  IIR_ConcurrentStatement *transmutedNode = NULL;
  
  // This is needed for some checks in process statements.
  // So please don't delete this NULL assignment unless you are 101% sure
  // it is not needed or wrong.
  // _current_publish_node = NULL;
  
  for (node = first(); node != NULL; node = successor(node)) {
    //4 lines added to do transmogrification once
    transmutedNode = (IIR_ConcurrentStatement*)node->_transmute();
    if(node != transmutedNode) {
      _replace(node, transmutedNode);
      //      insert_after(node, transmutedNode);
      //      remove(node);
      node = transmutedNode;
    }
    if (node->get_kind() == IIR_PROCESS_STATEMENT ||
	node->get_kind() == IIR_BLOCK_STATEMENT){
      node->_publish_cc_type_info();
    }
  }
}

void 
IIRScram_ConcurrentStatementList::_publish_cc_extern_type_info() {
  IIR_ConcurrentStatement *node;
  IIR_ConcurrentStatement *transmutedNode = NULL;
  
  // This is needed for some checks in process statements.
  // So please don't delete this NULL assignment unless you are 101% sure
  // it is not needed or wrong.
  // _current_publish_node = NULL;
  
  for (node = first(); node != NULL; node = successor(node)) {
    //4 lines added to do transmogrification once
    transmutedNode = (IIR_ConcurrentStatement*)node->_transmute();
    if(node != transmutedNode) {
      _replace(node, transmutedNode);
      //      insert_after(node, transmutedNode);
      //      remove(node);
      node = transmutedNode;
    }
    if (node->get_kind() == IIR_PROCESS_STATEMENT ||
	node->get_kind() == IIR_BLOCK_STATEMENT){
      node->_publish_cc_extern_type_info();
    }
  }
}

IIR_Label *
IIRScram_ConcurrentStatementList::_find_instantiate_label( IIR_SimpleName *to_find ){
  IIR_Label *retval = NULL;

  IIR_ConcurrentStatement *current_statement = first();
  while( current_statement != NULL ){
    retval = current_statement->_find_instantiate_label( to_find );
    if( retval != NULL ){
      break;
    }

    current_statement = successor( current_statement );
  }

  return retval;
}

void 
IIRScram_ConcurrentStatementList::_type_check_instantiate_statements(){
  IIR_ConcurrentStatement *current = first();
  while( current != NULL ){
    current->_type_check_instantiate_statements();
    current = successor( current );
  }
}

int
IIRScram_ConcurrentStatementList::_get_number_of_component_instantiations() {
  int compInstCounter = 0;
  IIR_ConcurrentStatement *current = first();
  
  while (current != NULL) {
    if (current->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT) {
      compInstCounter++;
    }

    current = successor(current);
  }
  
  return compInstCounter;
}
