
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingSubtypeDefinition.cc,v 1.2 1999/03/09 20:54:35 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_FloatingSubtypeDefinition.hh"
#include "IIR_FloatingTypeDefinition.hh"
#include <iostream.h>
#include "IIR_FunctionDeclaration.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIRScram_FloatingPointLiteral.hh"

IIRScram_FloatingSubtypeDefinition::~IIRScram_FloatingSubtypeDefinition(){}

IIR_Boolean
IIRScram_FloatingSubtypeDefinition::_is_subtype() {
  return TRUE;
}

void 
IIRScram_FloatingSubtypeDefinition::_publish_cc_type_info(){
  _cc_out << "realInfo ";
  if (_is_anonymous() == FALSE) {
    _publish_cc();
  }
  else {
    _get_base_type()->_publish_cc();
  }
  
  _cc_out << "_info(";
  get_left()->_publish_cc_universal_value();
  _cc_out << ", ";
  if(get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "to, ";
  }
  else {
    _cc_out << "downto, ";
  }
  get_right()->_publish_cc_universal_value();
  _cc_out << ")";
}

void 
IIRScram_FloatingSubtypeDefinition::_publish_cc_extern_type_info(){
  _cc_out << "extern realInfo ";
  if (_is_anonymous() == FALSE) {
    _publish_cc();
  }
  else {
    _get_base_type()->_publish_cc();
  }
  
  _cc_out << "_info;" << endl;
}

