#ifndef IIRSCRAM_QUIET_ATTRIBUTE_HH
#define IIRSCRAM_QUIET_ATTRIBUTE_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_QuietAttribute.hh,v 1.2 1999/03/09 20:56:05 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_QuietAttribute.hh"

class IIRScram_QuietAttribute : public IIRBase_QuietAttribute {

public:
  void _publish_vhdl(ostream &);
  IIR_TextLiteral *_build_attribute_name();
  IIR_TypeDefinition *_get_subtype();
  IIR_Boolean _is_signal(){ return TRUE; }
  
  IIR_Declaration *_get_implicit_declaration( char *decl_name,
					      IIR_TypeDefinition *decl_type );

  void _publish_cc();
  void _publish_cc_necessary_decl_in_state();
  void _publish_cc_name_in_caps();
  void _publish_cc_attrib_type();
  void _publish_cc_necessary_decl_init();
  void _publish_cc_init_val();
  void _publish_cc_elaborate();
  void _publish_cc_sigtype();
  void _publish_cc_type_cast();
  void _publish_cc_state_object_init();
  void _publish_cc_necessary_copying();
  void _publish_cc_read_or_write(const char *, const char *);
  
  IIR_Boolean _has_suffix(){ return TRUE; }
  void _set_suffix( IIR *new_suffix ){ set_suffix( new_suffix ); }

  IIR *_clone();
  virtual IIR_Boolean _is_quiet_attribute() { return TRUE; }
  IIR_Boolean _is_signal_attribute(){ return TRUE; }

protected:
  void _resolve_suffix_special();

  IIRScram_QuietAttribute() {}
  virtual ~IIRScram_QuietAttribute() = 0;
    
private:
  IIR_Boolean _need_to_process_prefix_prefix(){ 
    return _need_to_process_prefix_prefix_signal_attribute();
  }
};
#endif
