
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_SubprogramDeclaration.cc,v 1.3 1999/10/21 15:13:36 dmadhava Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_SubprogramDeclaration.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_SubtypeDeclaration.hh"
#include "IIR_SequentialStatement.hh"
#include "IIR_ReturnStatement.hh"
#include "IIR_TextLiteral.hh"
#include "IIR_StringLiteral.hh"
#include "IIR_FunctionDeclaration.hh"
#include "set.hh"
#include "resolution_func.hh"
#include "IIR_AttributeSpecificationList.hh"
#include "IIR_AttributeSpecification.hh"
#include "IIR_InterfaceList.hh"
#include "IIR_InterfaceDeclaration.hh"
#include "IIR_SequentialStatementList.hh"
#include "symbol_table.hh"
#include "IIR_AliasDeclaration.hh"

IIRScram_SubprogramDeclaration::IIRScram_SubprogramDeclaration(){
  _my_contains_body = FALSE;
}

IIRScram_SubprogramDeclaration::~IIRScram_SubprogramDeclaration() {}

void 
IIRScram_SubprogramDeclaration::_get_headers(set<IIR> &headerSet) {
  // First the default includes.
  if(_contains_body() == TRUE){

    // The types used in the interface declarations.
    IIR_InterfaceDeclaration *interface_decl = interface_declarations.first();
    while (interface_decl != NULL) {
      switch(interface_decl->get_kind()) {
      case IIR_SIGNAL_INTERFACE_DECLARATION:
      case IIR_VARIABLE_INTERFACE_DECLARATION:
      case IIR_CONSTANT_INTERFACE_DECLARATION:
	if(((IIR_InterfaceDeclaration*) interface_decl)->get_subtype()->_get_declaration() != NULL) {
	  headerSet.add(((IIR_ObjectDeclaration*)interface_decl)->get_subtype()->_get_declaration());
	}
	break;
      case IIR_FILE_INTERFACE_DECLARATION:
	// Do Nothing!!
	break;
      default:
	cerr << "IIRScram_SubprogramDeclaration.cc::_publish_cc_headers():"
	     << " Unknown declaration type: " 
	     << interface_decl->get_kind_text() << endl;
	break;
      }
      interface_decl = interface_declarations.successor(interface_decl);
    }
    
    // The types in the subprogram declarations.
    IIR_Declaration *decl = subprogram_declarations.first();
    while (decl != NULL) {
      switch(decl->get_kind()) {
      case IIR_TYPE_DECLARATION:
      case IIR_SUBTYPE_DECLARATION:
	headerSet.add(decl);
	break;
      default:
	break;
      }
      decl = subprogram_declarations.successor(decl);
    }
    
    // Finally, the return type.
//     if(_get_return_type() != NULL) { // Then this is a function
//       _get_return_type()->_publish_cc_headers(headerSet);
//       headerSet.add(_get_return_type());
//     }
  }
}

void 
IIRScram_SubprogramDeclaration::_publish_cc_declarations() {
  IIR_Declaration *decl = subprogram_declarations.first();
  char *temp_str = NULL;
  char *current_file_name = NULL;

  if(_cc_out.get_file_output() == true) {
    temp_str = _cc_out.get_file_name();
    current_file_name = new char[strlen(temp_str)+1];
    strcpy(current_file_name, temp_str);
  }

  while (decl != NULL) {
    // Some publishing changes the output file, so to return to this
    // file, we have to save it and restore it here.
   _cc_out.set_file(current_file_name);
    switch(decl->get_kind()) {
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
      // These have been published earlier.  Nothing to be done here.
      break;
    case IIR_SIGNAL_DECLARATION:
    case IIR_VARIABLE_DECLARATION:
    case IIR_CONSTANT_DECLARATION:
      if(decl->_get_subtype()->_is_access_type()) {
	decl->_publish_cc_decl();
      } else {
	decl->_get_subtype()->_publish_cc_type_name();
	_cc_out << " ";
	decl->_get_declarator()->_publish_cc();
	decl->_publish_cc_constructor_args();
	_cc_out << ";" << endl;
      }
      break;
    case IIR_ALIAS_DECLARATION:
      decl->_get_subtype()->_publish_cc_type_name();
      _cc_out << " ";
      ((IIR_AliasDeclaration*)decl)->_publish_cc_alias_object_init();
      _cc_out << ";" << endl;
      break;
    case IIR_ATTRIBUTE_SPECIFICATION:
      ((IIR_AttributeSpecification *) decl)->_publish_cc_decl_with_constructor();
      break;
    case IIR_ATTRIBUTE_DECLARATION:
      break;			// Nothing to be done.
    case IIR_FILE_DECLARATION:
      decl->_publish_cc_decl();
      break;
      
    case IIR_FILE_INTERFACE_DECLARATION:
      // Do Nothing Yet.  Possibly wrong -- SK!!
    case IIR_FUNCTION_DECLARATION: 
    case IIR_PROCEDURE_DECLARATION:
      // Has been taken care of before this subprogram publishing was
      // started.  Look at _publish_cc_decl()
      break;
    default:
      cerr << "IIRScram_SubprogramDeclaration.cc::_publish_cc_declarations():"
	   << " Unknown declaration type: " << decl->get_kind_text() << endl;
      break;
    }
    decl = subprogram_declarations.successor(decl);
  }
  if(_cc_out.get_file_output() == true) {
    delete [] current_file_name;
  }

  // After the declarations are over, we publish the identifiers necessary
  // for th for loop statements in the body.
  subprogram_body._publish_cc_decl_for_loop_iterator();
}
  
void 
IIRScram_SubprogramDeclaration::_publish_cc_prototype() {
  if(_contains_body() == TRUE){
    
    _publish_cc_redefine_savantnow();
    
    if(_get_return_type() != NULL) {
      _get_return_type()->_publish_cc_type_name();
    } else {
      _cc_out << "int";
    }
    _cc_out << " ";
    
    if(get_declarator()->_is_string_literal()) {
      // ((IIR_StringLiteral*)get_declarator())->_publish_cc_function_name();
      _get_declarator()->_publish_cc();
    }
    else {
      // _cc_out << "savant";
      _get_declarator()->_publish_cc();
      // if(_get_return_type() != NULL) {
      //_cc_out << "_";
      //_get_return_type()->_publish_cc_type_name();
      //}
    }
    _cc_out << "(VHDLKernelBase *processPtr";
    if(interface_declarations.num_elements() != 0) {
      _cc_out << ", ";
      interface_declarations._publish_cc_decl_subprogram_args(FALSE);
    }
    _cc_out << ");" << endl;
    
    
    if(_is_possible_resolution_function() == TRUE) {
      // Publish the prototype of the function, as a resolution function.
      _cc_out << "VHDLType* ";
      _publish_cc_resolution_function_name();
      _cc_out << "(VHDLKernelBase*, int, VHDLType**);" << endl;
    } // if
    
    if(_is_possible_type_conversion_function() == TRUE) {
      // Publish the prototype of the function, as a type conversion
      // function.
      _cc_out << "VHDLType* ";
      _publish_cc_type_conversion_function_name();
      _cc_out << "(VHDLKernelBase*, VHDLType*);" << endl;
    } // if
    
    _publish_cc_restore_savantnow();
    
    subprogram_declarations._publish_cc_prototype();
  }
}

void
IIRScram_SubprogramDeclaration::_publish_cc_resolution_function_name() {
  _report_undefined_scram_fn("_publish_cc_resolution_function_name()");
}

void
IIRScram_SubprogramDeclaration::_publish_cc_type_conversion_function_name() {
  _report_undefined_scram_fn("_publish_cc_type_conversion_function_name()");
}

// This method publishes file_close (which is implicit) for files declared
// in this subprogram

void
IIRScram_SubprogramDeclaration::_publish_cc_implicit_file_close() {
  IIR_Declaration *decl   = subprogram_declarations.first();

  while (decl != NULL) {
    if (decl->get_kind() == IIR_FILE_DECLARATION) {
      _cc_out << "  savantfile_close(processPtr, ";
      decl->_publish_cc();
      _cc_out << ");\n";
    }
    
    decl = subprogram_declarations.successor(decl);
  }
}
    
// Subprograms need to access the time (LVT of the parent process) through
// the processPtr, which is not the same for processes, so we need to
// redefine time for subprograms.  This MUST be just before the prototype
// definitions, so that they do not interfere with anything else.
// Further, the old definition is restored after the prototype definition.
void
IIRScram_SubprogramDeclaration::_publish_cc_redefine_savantnow() {
  _cc_out << "#ifdef savantnow" << endl
	  << "#undef savantnow" << endl
	  << "#define savantnow (PhysicalType(ObjectBase::VARIABLE,"
	  << "UniversalLongLongInteger(processPtr->getTimeNow().time),"
	  << " SavanttimeType_info))"<< endl
	  << "#endif" << endl;
}

void
IIRScram_SubprogramDeclaration::_publish_cc_restore_savantnow() {
  _cc_out << "#ifdef savantnow" << endl
	  << "#undef savantnow" << endl
	  << "#define savantnow (PhysicalType(ObjectBase::VARIABLE, "
	  << "UniversalLongLongInteger(getTimeNow().time), "
	  << "SavanttimeType_info))" << endl
	  << "#endif" << endl;
}

IIR_TypeDefinition* 
IIRScram_SubprogramDeclaration::_get_return_type() {
  return NULL;
}

bool 
IIRScram_SubprogramDeclaration::_check_param( IIR_TypeDefinition *type_def,
					      int param_num ){

  ASSERT( param_num >= 0 );
  ASSERT( type_def != NULL );

  IIR_TypeDefinition *param_type = _get_type_of_param( param_num );
  if( param_type == NULL ){
    return false;
  }

  // Now current is on the right argument...
  if( param_type->_is_compatible( type_def ) != NULL ){
    return true;
  }
  else{
    return false;
  }

}

IIR_Int32
IIRScram_SubprogramDeclaration::_num_subprogram_args(){
  return interface_declarations.num_elements();
}

IIR_Int32
IIRScram_SubprogramDeclaration::_num_required_args(){
  int retval = 0;

  IIR_InterfaceDeclaration *current_decl;
  current_decl =  interface_declarations.first();
  while ( current_decl != NULL ){
    if( current_decl->get_value() == NULL ){
      retval++;
    }
    current_decl =  interface_declarations.successor( current_decl );
  }

  return retval;
}

void 
IIRScram_SubprogramDeclaration::_type_check(){
  subprogram_declarations._type_check_attribute_specifications( subprogram_body );
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_type_check_return_statements( IIR_TypeDefinition *my_rval ){
  IIR_Boolean retval = FALSE;
  
  set<IIR_TypeDefinition> *context_set = NULL;
  if( my_rval != NULL ){
    context_set = new set<IIR_TypeDefinition>( my_rval );
  }

  IIR_SequentialStatement *stmt;

  IIR_Boolean found_one = FALSE;  
  stmt = subprogram_body.first();
  while( stmt != NULL ){
    if( stmt->get_kind() == IIR_RETURN_STATEMENT ){
      IIR_ReturnStatement *return_stmt = (IIR_ReturnStatement *)stmt;
      return_stmt->set_enclosing_subprogram((IIR_SubprogramDeclaration *)this);
      return_stmt->_type_check( context_set );

      ASSERT( return_stmt->_is_resolved() == TRUE );

      retval = TRUE;
    }
    else if( stmt->_has_statement_list() == TRUE ){
      found_one = 
	stmt->_type_check_return_statements( context_set, (IIR_SubprogramDeclaration *)this );
      if( found_one == TRUE ){
	retval = TRUE;
      }      
    }

    stmt = subprogram_body.successor( stmt );
  }
  
  delete context_set;

  return retval;
}


ostream &
IIRScram_SubprogramDeclaration::_print( ostream &os ){
  os << *get_declarator();
  os << "(";

  IIR_InterfaceDeclaration *current_param = interface_declarations.first();
  while( current_param != NULL ){
    os << *current_param;
    current_param = interface_declarations.successor( current_param );
    if( current_param != NULL ){
      os << ", ";
    }
  }
  
  os << ")";

  return os;
}

IIR_TypeDefinition *
IIRScram_SubprogramDeclaration::_get_type_of_param( int param_number ){

  IIR_InterfaceDeclaration *current = interface_declarations.first();
  if( current == NULL ){
    return NULL;
  }

  int i;
  for( i = 0; i < param_number; i++ ){
    current = interface_declarations.successor( current );

    if( current == NULL ){
      return NULL;
    }  
  }

  return current->_get_subtype();
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_compare_signatures( IIR_SubprogramDeclaration *a,
						     IIR_SubprogramDeclaration *b ){
  ASSERT( a != NULL );
  ASSERT( b != NULL );
  
  if( a->_get_subtype()->_is_compatible( b->_get_subtype() ) == NULL ){
    return FALSE;
  }

  int a_num_params =  a->interface_declarations.num_elements();
  int b_num_params =  b->interface_declarations.num_elements();
  if( a_num_params != b_num_params ){
    return FALSE;
  }

  int i;
  for( i = 0 ; i < a_num_params; i++ ){
    if( a->_get_type_of_param( i )->_is_compatible( b->_get_type_of_param( i ) ) == NULL ){
      return FALSE;
    }
  }

  // If we made it here, everything matched up...
  return TRUE;
}

void 
IIRScram_SubprogramDeclaration::_make_interface_visible( symbol_table *sym_tab ){
  sym_tab->make_visible( (IIR_DeclarationList *)&interface_declarations );
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_contains_body(){
  return _my_contains_body;
}

void
IIRScram_SubprogramDeclaration::_set_contains_body( IIR_Boolean new_contains_body ){
  _my_contains_body = new_contains_body;
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_is_homograph_of( IIR_Declaration *compare_to ){
  ASSERT( compare_to != NULL );
  ASSERT( IIR_TextLiteral::_cmp( compare_to->get_declarator(), get_declarator() ) == 0 );

  // If they're not the same kind of node, they're not.
  if( get_kind() != compare_to->get_kind() ){
    return FALSE;
  }

  ASSERT( compare_to->_is_iir_subprogram_declaration() == TRUE );
  IIR_SubprogramDeclaration *compare_as_subprog;
  compare_as_subprog = (IIR_SubprogramDeclaration *)compare_to;
  
  if( _compare_signatures( (IIR_SubprogramDeclaration *)this, compare_as_subprog ) == FALSE ){
    return FALSE;
  }
  
  return TRUE;
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_can_be_in_same_region( IIR_Declaration *to_check ){
  if(( _contains_body() == TRUE && to_check->_contains_body() == FALSE ) ||
     ( _contains_body() == FALSE && to_check->_contains_body() == TRUE )){
    return TRUE;
  }
  else if(( _is_implicit_operator() == TRUE && to_check->_is_implicit_operator() == FALSE )||
	  ( _is_implicit_operator() == FALSE && to_check->_is_implicit_operator() == TRUE )){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

void 
IIRScram_SubprogramDeclaration::_add_declaration(){
  ASSERT( get_declarator() != NULL );
  _get_symbol_table()->add_declaration( this );
  _get_symbol_table()->open_scope( this );
  _get_symbol_table()->add_declaration( &interface_declarations );
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_is_operator(){
  IIR_TextLiteral *declarator = get_declarator();
  if( declarator->operator[]( 0 ) == '"' &&
      declarator->operator[]( declarator->get_text_length() ) == '"' ){
    ASSERT( interface_declarations.num_elements() == 1 ||
	    interface_declarations.num_elements() == 2 );
    
    return TRUE;
  }
  else{
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_SubprogramDeclaration::_is_implicit_operator(){
  if( _is_implicit_declaration() == TRUE && _is_operator() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}
