
#ifndef IIRSCRAM_TEXT_LITERAL_HH
#define IIRSCRAM_TEXT_LITERAL_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_TextLiteral.hh,v 1.2 1999/03/09 20:56:54 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_TextLiteral.hh"
#include "IRBasicDataTypes.hh"
#include "savant.hh"
#include "hash_table.hh"

class ostream;
class IIR_TextLiteral;
class IIR_Name;
template <class type> class set;
class IIR_TypeDefinition;
class IIR_Declaration;

class IIRScram_TextLiteral : public IIRBase_TextLiteral {

public:
  ostream &_print( ostream & );
  ostream &_print_cc( ostream & );
  // These methods returns the comparison of two IIR_Identifiers just as
  // strcmp does...
  static int _cmp( IIR_TextLiteral *, IIR_TextLiteral *);
  static int _cmp( IIR_TextLiteral *, char *);
  static int _cmp( IIR_TextLiteral *, IIR_Name *);
  static int _ncmp( IIR_TextLiteral *, char *, int);

  // Makes this string go to lower case.
  void _to_lower();

  IIR_Boolean _is_text_literal(){ return TRUE; }
  IIR_Boolean _is_iir_text_literal(){ return TRUE; }

  IIR_TextLiteral *_get_prefix_string(){
    return (IIR_TextLiteral *)this;
  }

  IIR_Char *_convert_to_c_string(){
    return text->_convert_to_c_string();
  }

  set<IIR_TypeDefinition> *_get_rval_set(IIR_Boolean(IIR::*constraint_function)()=0);  

  set<IIR_Declaration> *_symbol_lookup();
  set<IIR_Declaration> *_symbol_lookup(IIR_Boolean(IIR::*constraint_function)());

  // Implements "get_rval_set" for String and BitString Literals
  set<IIR_TypeDefinition> *_get_rval_set_for_string();
  
  void _publish_vhdl(ostream &);
  virtual void _publish_cc();

protected:
  IIRScram_TextLiteral();
  virtual ~IIRScram_TextLiteral() = 0;

  // This method is intended for use on NEW objects only...  (Otherwise,
  // it will leak - and an assertion will fail)
  void _set_text( IIR_Char *, IIR_Int32 );
    
private:
  static hash_table<IIRScram_String> string_table;
};

#endif
