
#ifndef SCRAM_FUNC_HH
#define SCRAM_FUNC_HH

// Copyright (c) 1995 The University of Cincinnati.
// All rights reserved. 

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// author: Dale E. Martin          dmartin@ece.uc.edu

//---------------------------------------------------------------------------
//
// $Id: scram_func.hh,v 1.2 1999/03/09 20:57:26 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "error_func.hh"

#include "IIR_Label.hh"
#include "IIR_Identifier.hh"
#include "IIR_Expression.hh"
#include "IIR_FunctionCall.hh"
#include "IIR_AssociationElement.hh"
#include "IIR_AssociationList.hh"
#include "IIR_AssociationElementByExpression.hh"

int strcmp(const char *s1, const char *s2);

// inline 
// int strcmp(IIR_Name *fn, IIR_Label *fl){
//   return strcmp( fn->get_string(), fl->get_string() );
// };


// inline
// IIR_Expression* 
// make_fn_call (IIR_Identifier *op, 
// 	      IIR_Expression *lhs,
// 	      IIR_Expression *rhs) {
  
//   IIR_FunctionCall *fn_call;
//   IIR_AssociationElement *assoc;
//   IIR_AssociationElementByExpression *assoc_by_expr;
  
//   fn_call = new IIR_FunctionCall();
  
//   fn_call->name = op;
  
//   fn_call->argument_list = new IIR_AssociationList();
  
//   assoc = new IIR_AssociationElement();
//   assoc_by_expr = new IIR_AssociationElementByExpression();
//   assoc_by_expr->expression = lhs;
//   assoc->actual_part = assoc_by_expr;
//   fn_call->argument_list->append(assoc);
  
//   if (rhs != NULL) {
//     assoc = new IIR_AssociationElement();
//     assoc_by_expr = new IIR_AssociationElementByExpression();
//     assoc_by_expr->expression = rhs;
//     assoc->actual_part = assoc_by_expr;
//     fn_call->argument_list->append(assoc);
    
//   };
  
//   return fn_call;
  
// };

#endif
