//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef VARIABLE_HH
#define VARIABLE_HH

#include "vhdl.hh"
#include "ObjectBase.hh"
#include "ArrayInfo.hh"

struct VarBase : public ObjectBase{
  const char* name;
  VarType variableType;  // normal or access type
  int length;            // length of data pointed to

  VarBase() {}
  VarBase(const char* newname) : name(newname) {
    variableType = NORMAL;
    length = 0;
  }
  VarBase(const VarBase&) {}
  virtual ~VarBase() {}
  virtual ObjectType getKind() const { return VARIABLE; }
};


template <class Type>
class Variable : public VarBase {
public:
  Variable() { 
    name = NULL; 
  }

  Variable(const VHDLData& value) {
    name = NULL;
    this->operator=(value);
  }

  Variable(const int& value) {
    val = Type(value);
  }

  Variable(const char& c) {
    val = Type(c);
  }
  
  Variable(const bool& b) {
    val = Type(b);
  }

  Variable(const double& d) {
    val = Type(d);
  }

  Variable(const VarBase& v) {
    Variable<Type>* ptr = (Variable<Type>*)&v;

    name = ptr->name;
    variableType = ptr->variableType;
    length = ptr->length;
    val = ptr->val;
  }

  Variable(const char* newname) : VarBase(newname) {}

  ~Variable(){}; 

  //  Variable(const Variable<char*>&);
  void print(ostream& os = cout) const  {
    os << "Variable: " << variableType << ": val(" << val << ")";    
  }
  
  const VHDLData& readVal(void) const {
    return val;
  }

  void updateVal(const VHDLData& value) {
    val = value;
  }

  ObjectBase& operator=(const ObjectBase& value) {
    val = ((VHDLData &) value.readVal());
    parentCompositeType = value.parentCompositeType;
    return ((ObjectBase &)(*this));
  }
  
  ObjectBase& operator=(const VHDLData& value) {
    val = value;
    return ((ObjectBase &) (*this));
  }
  
  Variable<Type>& operator=(const Variable<Type>& rhs) {
    val          = ((VHDLData &) rhs.readVal());
    name         = rhs.name;
    variableType = rhs.variableType;
    length       = rhs.length;
    
    parentCompositeType = rhs.parentCompositeType;
    
    return *this;
  }
  
  ObjectBase* clone() const{
    Variable<Type> *retval = new Variable<Type>;
    *retval = *this;
    return ((ObjectBase *) retval);
  }
  
  Type val;
};

template <class Type>
inline
ostream& operator << (ostream& os, Variable<Type> var) {
  os << var.val;
  return os;
}

#include "Variable.cc"

#endif
