// Copyright (c) 1997 by Jim Lynch.
// This software comes with NO WARRANTY WHATSOEVER.
//
// This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; version 2 dated June, 1991, or, at your
//    option, any LATER version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program;  if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// On Debian Linux systems, the complete text of the GNU General
// Public License can be found in `/usr/doc/copyright/GPL' (on some
// installations) or /usr/share/common-licenses/GPL (on newer 
// ones).

#include <iostream.h>
#include <strstream.h>

#include "Record.h"
#include "Animal.h"
#include "Question.h"

#include "db2++-stuff.h"

#include <string>

void readline(istream &in, string &it)
{
  in >> it;
}

int IsSpace(const char theChar)
{
  int result = 0;
  
  switch(theChar)
    {
    case ' ':
    case '\n':
    case '\t':
    case '\r':
    case '\v':
    case '\f':
      result = 1;
      break;
    }
  
  return result;
}

void ChopTrailingWhiteSpace(string &it)
{
  int n = it.size() - 1;

  while(IsSpace( it[n] ))
    n--;

  it = it.substr(0, n + 1);
}

void ChopQuestionMark(string &it)
{
  ChopTrailingWhiteSpace(it);

  if(*(it.end() - 1) == '?')
    {
      it = it.substr(0, it.size() - 1);
      ChopTrailingWhiteSpace(it);
    }
}

string progName;

int main(int argc, char *argv[])
{
  Db *theFileHandle;
  string wantsToContinue;
  char ret[3];
  
  progName = argv[0];

  theFileHandle = OpenFile();
  string response(GetLast(*theFileHandle));
  CloseFile(*theFileHandle);

  cout << response << endl;

  return 0;
}
